"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolEmail = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const punycode_1 = require("punycode/");
/**
 * Configure how Cognito sends emails
 */
class UserPoolEmail {
    /**
     * Send email using Cognito
     */
    static withCognito(replyTo) {
        return new CognitoEmail(replyTo);
    }
    /**
     * Send email using SES
     */
    static withSES(options) {
        jsiiDeprecationWarnings._aws_cdk_aws_cognito_UserPoolSESOptions(options);
        return new SESEmail(options);
    }
}
exports.UserPoolEmail = UserPoolEmail;
_a = JSII_RTTI_SYMBOL_1;
UserPoolEmail[_a] = { fqn: "@aws-cdk/aws-cognito.UserPoolEmail", version: "1.148.0" };
class CognitoEmail extends UserPoolEmail {
    constructor(replyTo) {
        super();
        this.replyTo = replyTo;
    }
    _bind(_scope) {
        return {
            replyToEmailAddress: encodeAndTest(this.replyTo),
            emailSendingAccount: 'COGNITO_DEFAULT',
        };
    }
}
class SESEmail extends UserPoolEmail {
    constructor(options) {
        super();
        this.options = options;
    }
    _bind(scope) {
        var _b;
        const region = core_1.Stack.of(scope).region;
        if (core_1.Token.isUnresolved(region) && !this.options.sesRegion) {
            throw new Error('Your stack region cannot be determined so "sesRegion" is required in SESOptions');
        }
        let from = this.options.fromEmail;
        if (this.options.fromName) {
            from = `${this.options.fromName} <${this.options.fromEmail}>`;
        }
        return {
            from: encodeAndTest(from),
            replyToEmailAddress: encodeAndTest(this.options.replyTo),
            configurationSet: this.options.configurationSetName,
            emailSendingAccount: 'DEVELOPER',
            sourceArn: core_1.Stack.of(scope).formatArn({
                service: 'ses',
                resource: 'identity',
                resourceName: encodeAndTest(this.options.fromEmail),
                region: (_b = this.options.sesRegion) !== null && _b !== void 0 ? _b : region,
            }),
        };
    }
}
function encodeAndTest(input) {
    if (input) {
        const local = input.split('@')[0];
        if (!/[\p{ASCII}]+/u.test(local)) {
            throw new Error('the local part of the email address must use ASCII characters only');
        }
        return punycode_1.toASCII(input);
    }
    else {
        return undefined;
    }
}
//# sourceMappingURL=data:application/json;base64,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