/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.iom.WorkspaceConnector;
import com.sas.iom.WorkspaceFactory;
import com.sas.iom.WorkspaceFactoryException;
import com.sas.iom.WorkspacePoolException;
import java.io.PrintWriter;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class WorkspacePoolDriver {
    private static PrintWriter logWriter = null;

    private WorkspacePoolDriver() {
    }

    public static WorkspaceConnector getPooledWorkspace(Hashtable credentials, String searchContext, String sasLogicalName, String userDN, long waitMilliseconds) throws WorkspacePoolException {
        String password = WorkspacePoolDriver.findPassword(credentials, userDN);
        WorkspaceConnector connector = null;
        try {
            WorkspaceFactory wf = WorkspaceFactory.getFactory(userDN, password, credentials, searchContext, sasLogicalName);
            if (wf == null) {
                wf = new WorkspaceFactory(credentials, searchContext, sasLogicalName, userDN != null, false, logWriter);
            }
            connector = wf.getWorkspaceConnector(userDN, password, waitMilliseconds);
        }
        catch (WorkspaceFactoryException wfe) {
            throw new WorkspacePoolException((Throwable)((Object)wfe));
        }
        return connector;
    }

    public static void closePool(Hashtable credentials, String searchContext, String sasLogicalName, String userDN) throws WorkspacePoolException {
        String password = WorkspacePoolDriver.findPassword(credentials, userDN);
        try {
            WorkspaceFactory wf = WorkspaceFactory.getFactory(userDN, password, credentials, searchContext, sasLogicalName);
            if (wf != null) {
                wf.shutdown();
            }
        }
        catch (WorkspaceFactoryException wfe) {
            throw new WorkspacePoolException((Throwable)((Object)wfe));
        }
    }

    public static void setLog(PrintWriter l) {
        logWriter = l;
    }

    public static PrintWriter getLog() {
        return logWriter;
    }

    private static String findPassword(Hashtable credentials, String userDN) throws WorkspacePoolException {
        if (userDN == null) {
            return null;
        }
        String password = null;
        try {
            InitialDirContext ctx = new InitialDirContext(credentials);
            Attributes attrs = ctx.getAttributes(userDN);
            Attribute attr = attrs.get("Password");
            password = (String)attr.get();
            ctx.close();
        }
        catch (NamingException ne) {
            throw new WorkspacePoolException(ne);
        }
        return password;
    }
}

