/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.CP_ID;
import com.sas.iom.SASIOMDefs.ConnectionPoint;
import com.sas.iom.SASIOMDefs.ConnectionPointContainer;
import com.sas.iom.SASIOMDefs.ConnectionPointContainerHelper;
import com.sas.iom.SASIOMDefs.ConnectionPointHolder;
import com.sas.iom.orb.CP_IDConverter;
import com.sas.iom.orb.ORBBase;
import com.sas.iom.orb.POAImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.PortableServer.DynamicImplementation;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ThreadPolicyValue;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class EventUtil {
    private static final Logger LOGGER = Logger.getLogger(EventUtil.class);
    private static final Map<Delegate, Map<String, POAImpl>> SOURCE_MAP = new WeakHashMap<Delegate, Map<String, POAImpl>>();
    private static final String POA_NAME_PREFIX = "com.sas.iom.orb.POAImpl event listener ";
    private static int _poaCounter;

    private EventUtil() {
    }

    public static int advise(Object source, String id, DynamicImplementation listener) {
        return EventUtil.advise(source, id, listener, null);
    }

    public static int advise(Object source, String id, DynamicImplementation listener, int[][] policyValues) {
        POAImpl rootPOA;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((java.lang.Object)("Advising event " + id + " of listener"));
        }
        ConnectionPoint cp = EventUtil.findConnectionPoint(source, id);
        POAImpl poa = rootPOA = EventUtil.getRootPOA(source);
        if (policyValues != null && policyValues.length > 0) {
            try {
                String poaName = EventUtil.createPoaName(id);
                Policy[] policyArr = EventUtil.getPolicies(rootPOA, policyValues);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((java.lang.Object)("Creating POA " + poaName));
                    for (Policy p : policyArr) {
                        LOGGER.debug((java.lang.Object)("Adding policy " + p));
                    }
                }
                poa = (POAImpl)poa.create_POA(poaName, null, policyArr);
            }
            catch (InvalidPolicy ip) {
                throw new IllegalArgumentException(ip);
            }
            catch (AdapterAlreadyExists aae) {
                throw new IllegalStateException(aae);
            }
        }
        Object ref = poa.activateTransientObject((Servant)listener);
        IntHolder handleHolder = new IntHolder();
        cp.Advise(ref, handleHolder);
        int handle = handleHolder.value;
        if (poa != rootPOA) {
            EventUtil.addAdvised(source, id, handle, poa);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((java.lang.Object)("Listener handle is " + handle));
        }
        return handle;
    }

    public static void unadvise(Object source, String id, int handle) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((java.lang.Object)("Unadvising event " + id + " of listener " + handle));
        }
        ConnectionPoint cp = EventUtil.findConnectionPoint(source, id);
        cp.Unadvise(handle);
        EventUtil.removeAdvised(source, id, handle);
    }

    private static ConnectionPoint findConnectionPoint(Object source, String id) {
        ConnectionPointContainer cpContainer = ConnectionPointContainerHelper.narrow(source);
        if (cpContainer == null) {
            throw new BAD_PARAM();
        }
        CP_ID cpid = CP_IDConverter.stringToCP_ID(id);
        ConnectionPointHolder cpHolder = new ConnectionPointHolder();
        cpContainer.FindConnectionPoint(cpid, cpHolder);
        ConnectionPoint cp = cpHolder.value;
        return cp;
    }

    private static POAImpl getRootPOA(Object source) {
        ORB orb = ((ObjectImpl)source)._orb();
        if (!(orb instanceof ORBBase)) {
            throw new BAD_PARAM();
        }
        POAImpl rootPOA = ((ORBBase)orb).getRootPOA();
        return rootPOA;
    }

    private static Policy[] getPolicies(POAImpl rootPOA, int[][] policyValues) {
        Policy[] policyArr = new Policy[policyValues.length];
        block9: for (int i = 0; i < policyValues.length; ++i) {
            int[] policyValue = policyValues[i];
            if (policyValue == null || policyValue.length < 2) {
                throw new IllegalArgumentException("All policyValue array elements should have length of 2");
            }
            switch (policyValue[0]) {
                case 19: {
                    IdAssignmentPolicyValue value = IdAssignmentPolicyValue.from_int((int)policyValue[1]);
                    policyArr[i] = rootPOA.create_id_assignment_policy(value);
                    continue block9;
                }
                case 18: {
                    IdAssignmentPolicyValue value = IdUniquenessPolicyValue.from_int((int)policyValue[1]);
                    policyArr[i] = rootPOA.create_id_uniqueness_policy((IdUniquenessPolicyValue)value);
                    continue block9;
                }
                case 20: {
                    IdAssignmentPolicyValue value = ImplicitActivationPolicyValue.from_int((int)policyValue[1]);
                    policyArr[i] = rootPOA.create_implicit_activation_policy((ImplicitActivationPolicyValue)value);
                    continue block9;
                }
                case 17: {
                    IdAssignmentPolicyValue value = LifespanPolicyValue.from_int((int)policyValue[1]);
                    policyArr[i] = rootPOA.create_lifespan_policy((LifespanPolicyValue)value);
                    continue block9;
                }
                case 22: {
                    IdAssignmentPolicyValue value = RequestProcessingPolicyValue.from_int((int)policyValue[1]);
                    policyArr[i] = rootPOA.create_request_processing_policy((RequestProcessingPolicyValue)value);
                    continue block9;
                }
                case 21: {
                    IdAssignmentPolicyValue value = ServantRetentionPolicyValue.from_int((int)policyValue[1]);
                    policyArr[i] = rootPOA.create_servant_retention_policy((ServantRetentionPolicyValue)value);
                    continue block9;
                }
                case 16: {
                    IdAssignmentPolicyValue value = ThreadPolicyValue.from_int((int)policyValue[1]);
                    policyArr[i] = rootPOA.create_thread_policy((ThreadPolicyValue)value);
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Unknown policy ID " + policyValue[0]);
                }
            }
        }
        return policyArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addAdvised(Object source, String id, int handle, POAImpl poa) {
        Map<Delegate, Map<String, POAImpl>> map = SOURCE_MAP;
        synchronized (map) {
            Delegate delegate = ((ObjectImpl)source)._get_delegate();
            Map<String, POAImpl> advisedMap = SOURCE_MAP.get(delegate);
            if (advisedMap == null) {
                advisedMap = new HashMap<String, POAImpl>();
                SOURCE_MAP.put(delegate, advisedMap);
            }
            String key = EventUtil.createAdvisedMapKey(id, handle);
            advisedMap.put(key, poa);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeAdvised(Object source, String id, int handle) {
        POAImpl poa = null;
        Map<Delegate, Map<String, POAImpl>> map = SOURCE_MAP;
        synchronized (map) {
            Delegate delegate = ((ObjectImpl)source)._get_delegate();
            Map<String, POAImpl> advisedMap = SOURCE_MAP.get(delegate);
            if (advisedMap != null) {
                String key = EventUtil.createAdvisedMapKey(id, handle);
                poa = advisedMap.remove(key);
                if (advisedMap.isEmpty()) {
                    SOURCE_MAP.remove(delegate);
                }
            }
        }
        if (poa != null) {
            poa.destroy(false, false);
        }
    }

    private static String createAdvisedMapKey(String id, int handle) {
        return id + handle;
    }

    private static String createPoaName(String eventId) {
        return POA_NAME_PREFIX + ++_poaCounter;
    }
}

