/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb;

import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.SelectionHub;
import com.sas.iom.orb.SelectionHubKey;
import com.sas.iom.orb.ThreadPool;
import com.sas.iom.orb.WorkException;
import com.sas.iom.orb.WorkInterface;

@SASScope
public class SelectionHubActivation {
    private SelectionHub.Spoke spoke;
    private SelectionHubKey key;
    private ThreadPool threadPool;
    private boolean deactivated;

    protected SelectionHubActivation(SelectionHub.Spoke spoke, SelectionHubKey key, ThreadPool threadPool) {
        this.spoke = spoke;
        this.key = key;
        this.threadPool = threadPool;
    }

    public synchronized void register() {
        this.checkState();
        this.spoke.register(this);
    }

    public synchronized void updateInterestOps(int interestOps) {
        this.checkState();
        this.spoke.update(this, interestOps);
    }

    public synchronized void executeWork(WorkInterface task) throws WorkException {
        this.checkState();
        this.threadPool.executeDaemon(task);
    }

    public synchronized void deactivate() {
        if (this.deactivated) {
            return;
        }
        this.spoke.deactivate(this);
    }

    protected SelectionHubKey getKey() {
        return this.key;
    }

    private void checkState() {
        if (this.deactivated) {
            throw new IllegalStateException();
        }
    }
}

