/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb.brg;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.AnySeqHelper;
import com.sas.iom.SASIOMDefs.BooleanSeqHelper;
import com.sas.iom.SASIOMDefs.DateTimeHelper;
import com.sas.iom.SASIOMDefs.DateTimeSeqHelper;
import com.sas.iom.SASIOMDefs.DoubleSeqHelper;
import com.sas.iom.SASIOMDefs.FloatSeqHelper;
import com.sas.iom.SASIOMDefs.LongLongSeqHelper;
import com.sas.iom.SASIOMDefs.LongSeqHelper;
import com.sas.iom.SASIOMDefs.OctetSeqHelper;
import com.sas.iom.SASIOMDefs.ShortSeqHelper;
import com.sas.iom.SASIOMDefs.StringSeqHelper;
import com.sas.iom.SASIOMDefs.UUID;
import com.sas.iom.SASIOMDefs.UUIDHelper;
import com.sas.iom.SASIOMDefs.UUIDSeqHelper;
import com.sas.iom.SASIOMDefs.VariableArray2dOfAnyHelper;
import com.sas.iom.SASIOMDefs.VariableArray2dOfBooleanHelper;
import com.sas.iom.SASIOMDefs.VariableArray2dOfDateTimeHelper;
import com.sas.iom.SASIOMDefs.VariableArray2dOfDoubleHelper;
import com.sas.iom.SASIOMDefs.VariableArray2dOfFloatHelper;
import com.sas.iom.SASIOMDefs.VariableArray2dOfLongHelper;
import com.sas.iom.SASIOMDefs.VariableArray2dOfLongLongHelper;
import com.sas.iom.SASIOMDefs.VariableArray2dOfOctetHelper;
import com.sas.iom.SASIOMDefs.VariableArray2dOfShortHelper;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHelper;
import com.sas.iom.SASIOMDefs.VariableArray2dOfUUIDHelper;
import com.sas.iom.orb.AnyImpl;
import com.sas.iom.orb.DelegateLocal;
import com.sas.iom.orb.GenericObject;
import com.sas.iom.orb.TypeCodeImpl;
import com.sas.iom.orb.UUIDConverter;
import com.sas.iom.orb.brg.BufferManager;
import com.sas.iom.orb.brg.Conversation;
import com.sas.iom.orb.brg.DelegateImpl;
import com.sas.iom.orb.brg.InboundPacket;
import com.sas.iom.orb.brg.ORBImpl;
import com.sas.iom.orb.brg.OutboundPacket;
import com.sas.iom.orb.brg.RB;
import com.sas.text.Message;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;

@SASScope
public class Marshaller {
    protected static final int WZX_REP_MASK = 524287;
    protected static final int WZX_ATTR_MASK = 0xF80000;
    protected static final int WZX_ATTR_UNSIGNED = 0x400000;
    protected static final int WZX_TYPE_MASK = 0x7F000000;
    protected static final int WZX_TYPE_LONG = 0x1000000;
    protected static final int WZX_TYPE_SHORT = 0x2000000;
    protected static final int WZX_TYPE_INT = 0x3000000;
    protected static final int WZX_TYPE_FLOAT = 0x4000000;
    protected static final int WZX_TYPE_DOUBLE = 0x5000000;
    protected static final int WZX_TYPE_CHAR = 0x6000000;
    protected static final int WZX_TYPE_CHAR_B = 0x7000000;
    protected static final int WZX_TYPE_INT64 = 0x19000000;
    protected static final int WZX_MAP32XTND = Integer.MIN_VALUE;
    private static final short PE_ANY_TYPE_ANY = 0;
    private static final short PE_ANY_TYPE_BOOLEAN = 1;
    private static final short PE_ANY_TYPE_DATETIME = 2;
    private static final short PE_ANY_TYPE_DOUBLE = 3;
    private static final short PE_ANY_TYPE_ENUM = 4;
    private static final short PE_ANY_TYPE_FLOAT = 5;
    private static final short PE_ANY_TYPE_IFACE = 6;
    private static final short PE_ANY_TYPE_INT16 = 7;
    private static final short PE_ANY_TYPE_INT32 = 8;
    private static final short PE_ANY_TYPE_INT64 = 9;
    private static final short PE_ANY_TYPE_OCTET = 10;
    private static final short PE_ANY_TYPE_STRING = 11;
    private static final short PE_ANY_TYPE_UUID = 12;
    private static final short PE_ANY_TYPE_NULL = 13;
    private static final short PE_ANY_TYPE_ARRAY = Short.MIN_VALUE;
    protected static final int headerSize = 64;
    protected static final int mapL = 4;
    private static final int attrTypeMask = 2146959360;

    protected Marshaller() {
    }

    protected void calculatePacketSize(Conversation conversation, OutboundPacket packet) {
        AnyImpl[] parmArray = packet.getParameterArray();
        int dataSize = 0;
        int mapCount = 0;
        LinkedList stringList = null;
        if (parmArray != null && parmArray.length > 0 || packet.isReply()) {
            IntHolder mapCountHolder = new IntHolder();
            IntHolder dataSizeHolder = new IntHolder();
            stringList = new LinkedList();
            this.calculatePayloadSize(conversation, packet, mapCountHolder, dataSizeHolder, stringList);
            dataSize = dataSizeHolder.value;
            mapCount = mapCountHolder.value;
            List roStringList = stringList.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableList(stringList);
            packet.setEncodedStringLst(roStringList);
        }
        packet.setMapCount(mapCount);
        int mapSize = mapCount * 4;
        int packetSize = 64 + mapSize + dataSize;
        packet.setSize(packetSize);
    }

    protected void calculatePayloadSize(Conversation conversation, OutboundPacket packet, IntHolder mapCountHolder, IntHolder dataSizeHolder, List stringList) {
        if (packet.isReply()) {
            this.calculateWZXUnsignedIntSize(conversation, mapCountHolder, dataSizeHolder);
            int packetType = packet.getType();
            int methodID = packet.getMethodId();
            if (packetType == 2 && (methodID == 1 || methodID == 2)) {
                this.calculateWZXUnsignedIntSize(conversation, mapCountHolder, dataSizeHolder);
            }
        }
        this.calculateParameterArraySize(conversation, packet, mapCountHolder, dataSizeHolder, stringList);
    }

    protected void calculateParameterArraySize(Conversation conversation, OutboundPacket packet, IntHolder mapCountHolder, IntHolder dataSizeHolder, List stringList) {
        AnyImpl[] parmArray = packet.getParameterArray();
        if (parmArray != null) {
            for (int i = 0; i < parmArray.length; ++i) {
                AnyImpl parm = parmArray[i];
                this.calculateParameterSize(conversation, parm, mapCountHolder, dataSizeHolder, stringList);
            }
        }
    }

    protected final void calculateParameterSize(Conversation conversation, AnyImpl parm, IntHolder mapCountHolder, IntHolder dataSizeHolder, List stringList) {
        int iomType = parm.iomType();
        switch (iomType) {
            case 33: {
                Any d = (Any)parm.extractIOM();
                this.calculateAnySize(conversation, d, mapCountHolder, dataSizeHolder, stringList);
                break;
            }
            case 34: {
                Any[] d = (Any[])parm.extractIOM();
                this.calculateAny1dArraySize(conversation, d, mapCountHolder, dataSizeHolder, stringList);
                break;
            }
            case 35: {
                Any[][] d = (Any[][])parm.extractIOM();
                this.calculateAny2dArraySize(conversation, d, mapCountHolder, dataSizeHolder, stringList);
                break;
            }
            case 0: {
                this.calculateBooleanSize(conversation, mapCountHolder, dataSizeHolder);
                break;
            }
            case 1: {
                boolean[] d = (boolean[])parm.extractIOM();
                this.calculateBoolean1dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 2: {
                boolean[][] d = (boolean[][])parm.extractIOM();
                this.calculateBoolean2dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 27: {
                this.calculateDatetimeSize(conversation, mapCountHolder, dataSizeHolder);
                break;
            }
            case 28: {
                long[] d = (long[])parm.extractIOM();
                this.calculateDatetime1dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 29: {
                long[][] d = (long[][])parm.extractIOM();
                this.calculateDatetime2dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 15: {
                this.calculateDoubleSize(conversation, mapCountHolder, dataSizeHolder);
                break;
            }
            case 16: {
                double[] d = (double[])parm.extractIOM();
                this.calculateDouble1dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 17: {
                double[][] d = (double[][])parm.extractIOM();
                this.calculateDouble2dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 21: {
                this.calculateEnumSize(conversation, mapCountHolder, dataSizeHolder);
                break;
            }
            case 22: {
                int[] d = (int[])parm.extractIOM();
                this.calculateEnum1dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 23: {
                int[][] d = (int[][])parm.extractIOM();
                this.calculateEnum2dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 12: {
                this.calculateFloatSize(conversation, mapCountHolder, dataSizeHolder);
                break;
            }
            case 13: {
                float[] d = (float[])parm.extractIOM();
                this.calculateFloat1dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 14: {
                float[][] d = (float[][])parm.extractIOM();
                this.calculateFloat2dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 36: {
                this.calculateInt64Size(conversation, mapCountHolder, dataSizeHolder);
                break;
            }
            case 37: {
                long[] d = (long[])parm.extractIOM();
                this.calculateInt641dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 38: {
                long[][] d = (long[][])parm.extractIOM();
                this.calculateInt642dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 9: {
                this.calculateLongSize(conversation, mapCountHolder, dataSizeHolder);
                break;
            }
            case 10: {
                int[] d = (int[])parm.extractIOM();
                this.calculateLong1dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 11: {
                int[][] d = (int[][])parm.extractIOM();
                this.calculateLong2dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 39: {
                break;
            }
            case 24: {
                this.calculateObjectSize(conversation, mapCountHolder, dataSizeHolder);
                break;
            }
            case 3: {
                this.calculateOctetSize(conversation, mapCountHolder, dataSizeHolder);
                break;
            }
            case 4: {
                byte[] d = (byte[])parm.extractIOM();
                this.calculateOctet1dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 5: {
                byte[][] d = (byte[][])parm.extractIOM();
                this.calculateOctet2dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 6: {
                this.calculateShortSize(conversation, mapCountHolder, dataSizeHolder);
                break;
            }
            case 7: {
                short[] d = (short[])parm.extractIOM();
                this.calculateShort1dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 8: {
                short[][] d = (short[][])parm.extractIOM();
                this.calculateShort2dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 18: {
                String d = (String)parm.extractIOM();
                this.calculateStringNTSize(conversation, d, mapCountHolder, dataSizeHolder, stringList);
                break;
            }
            case 19: {
                String[] d = (String[])parm.extractIOM();
                this.calculateStringNT1dArraySize(conversation, d, mapCountHolder, dataSizeHolder, stringList);
                break;
            }
            case 20: {
                String[][] d = (String[][])parm.extractIOM();
                this.calculateStringNT2dArraySize(conversation, d, mapCountHolder, dataSizeHolder, stringList);
                break;
            }
            case 30: {
                UUID d = (UUID)parm.extractIOM();
                this.calculateUUIDSize(conversation, d, mapCountHolder, dataSizeHolder, stringList);
                break;
            }
            case 31: {
                UUID[] d = (UUID[])parm.extractIOM();
                this.calculateUUID1dArraySize(conversation, d, mapCountHolder, dataSizeHolder, stringList);
                break;
            }
            case 32: {
                UUID[][] d = (UUID[][])parm.extractIOM();
                this.calculateUUID2dArraySize(conversation, d, mapCountHolder, dataSizeHolder, stringList);
                break;
            }
            case -100: {
                TypeCode type = parm.type();
                String typeName = TypeCodeImpl.toString(type);
                String messageIndex = "Engine.039.ex.fmt";
                String messagePattern = RB.getStringResource(messageIndex);
                String message = Message.format((String)messagePattern, (java.lang.Object)typeName);
                throw new BAD_PARAM(message);
            }
            default: {
                throw new INTERNAL();
            }
        }
    }

    protected void calculateAnySize(Conversation conversation, Any d, IntHolder mapCountHolder, IntHolder dataSizeHolder, List stringList) {
        this.calculateShortSize(conversation, mapCountHolder, dataSizeHolder);
        if (d instanceof AnyImpl) {
            this.calculateParameterSize(conversation, (AnyImpl)d, mapCountHolder, dataSizeHolder, stringList);
        } else {
            this.extractAndCalculate(conversation, d, mapCountHolder, dataSizeHolder, stringList);
        }
    }

    protected void calculateAny1dArraySize(Conversation conversation, Any[] d, IntHolder mapCountHolder, IntHolder dataSizeHolder, List stringList) {
        this.calculate1dArrayHeaderSize(mapCountHolder, dataSizeHolder);
        for (int i = 0; i < d.length; ++i) {
            this.calculateAnySize(conversation, d[i], mapCountHolder, dataSizeHolder, stringList);
        }
    }

    protected void calculateAny2dArraySize(Conversation conversation, Any[][] d, IntHolder mapCountHolder, IntHolder dataSizeHolder, List stringList) {
        this.calculate2dArrayHeaderSize(mapCountHolder, dataSizeHolder);
        for (int i = 0; i < d.length; ++i) {
            for (int j = 0; j < d[i].length; ++j) {
                this.calculateAnySize(conversation, d[i][j], mapCountHolder, dataSizeHolder, stringList);
            }
        }
    }

    protected void calculateBooleanSize(Conversation conversation, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitiveDataSize(1, 1, mapCountHolder, dataSizeHolder);
    }

    protected void calculateBoolean1dArraySize(Conversation conversation, boolean[] d, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitive1dArraySize(1, d, mapCountHolder, dataSizeHolder);
    }

    protected void calculateBoolean2dArraySize(Conversation conversation, boolean[][] d, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitive2dArraySize(1, d, mapCountHolder, dataSizeHolder);
    }

    protected void calculateDatetimeSize(Conversation conversation, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitiveDataSize(8, 1, mapCountHolder, dataSizeHolder);
    }

    protected void calculateDatetime1dArraySize(Conversation conversation, long[] d, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitive1dArraySize(8, d, mapCountHolder, dataSizeHolder);
    }

    protected void calculateDatetime2dArraySize(Conversation conversation, long[][] d, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitive2dArraySize(8, d, mapCountHolder, dataSizeHolder);
    }

    protected void calculateDoubleSize(Conversation conversation, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitiveDataSize(8, 1, mapCountHolder, dataSizeHolder);
    }

    protected void calculateDouble1dArraySize(Conversation conversation, double[] d, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitive1dArraySize(8, d, mapCountHolder, dataSizeHolder);
    }

    protected void calculateDouble2dArraySize(Conversation conversation, double[][] d, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitive2dArraySize(8, d, mapCountHolder, dataSizeHolder);
    }

    protected void calculateEnumSize(Conversation conversation, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitiveDataSize(4, 1, mapCountHolder, dataSizeHolder);
    }

    protected void calculateEnum1dArraySize(Conversation conversation, int[] d, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitive1dArraySize(4, d, mapCountHolder, dataSizeHolder);
    }

    protected void calculateEnum2dArraySize(Conversation conversation, int[][] d, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitive2dArraySize(4, d, mapCountHolder, dataSizeHolder);
    }

    protected void calculateFloatSize(Conversation conversation, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitiveDataSize(8, 1, mapCountHolder, dataSizeHolder);
    }

    protected void calculateFloat1dArraySize(Conversation conversation, float[] d, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitive1dArraySize(8, d, mapCountHolder, dataSizeHolder);
    }

    protected void calculateFloat2dArraySize(Conversation conversation, float[][] d, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitive2dArraySize(8, d, mapCountHolder, dataSizeHolder);
    }

    protected void calculateInt64Size(Conversation conversation, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitiveDataSize(8, 1, mapCountHolder, dataSizeHolder);
    }

    protected void calculateInt641dArraySize(Conversation conversation, long[] d, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitive1dArraySize(8, d, mapCountHolder, dataSizeHolder);
    }

    protected void calculateInt642dArraySize(Conversation conversation, long[][] d, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitive2dArraySize(8, d, mapCountHolder, dataSizeHolder);
    }

    protected void calculateLongSize(Conversation conversation, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitiveDataSize(4, 1, mapCountHolder, dataSizeHolder);
    }

    protected void calculateLong1dArraySize(Conversation conversation, int[] d, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitive1dArraySize(4, d, mapCountHolder, dataSizeHolder);
    }

    protected void calculateLong2dArraySize(Conversation conversation, int[][] d, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitive2dArraySize(4, d, mapCountHolder, dataSizeHolder);
    }

    protected void calculateObjectSize(Conversation conversation, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitiveDataSize(4, 1, mapCountHolder, dataSizeHolder);
    }

    protected void calculateOctetSize(Conversation conversation, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitiveDataSize(1, 1, mapCountHolder, dataSizeHolder);
    }

    protected void calculateOctet1dArraySize(Conversation conversation, byte[] d, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitive1dArraySize(1, d, mapCountHolder, dataSizeHolder);
    }

    protected void calculateOctet2dArraySize(Conversation conversation, byte[][] d, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitive2dArraySize(1, d, mapCountHolder, dataSizeHolder);
    }

    protected void calculateShortSize(Conversation conversation, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitiveDataSize(2, 1, mapCountHolder, dataSizeHolder);
    }

    protected void calculateShort1dArraySize(Conversation conversation, short[] d, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitive1dArraySize(2, d, mapCountHolder, dataSizeHolder);
    }

    protected void calculateShort2dArraySize(Conversation conversation, short[][] d, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitive2dArraySize(2, d, mapCountHolder, dataSizeHolder);
    }

    protected void calculateStringNTSize(Conversation conversation, String d, IntHolder mapCountHolder, IntHolder dataSizeHolder, List stringList) {
        ByteBuffer strBuf = this.stringToBuffer(conversation, d);
        stringList.add(strBuf);
        int dataSize = strBuf.remaining() + 1;
        mapCountHolder.value += this.calculateMapCount(dataSize);
        dataSizeHolder.value += dataSize;
    }

    protected void calculateStringNT1dArraySize(Conversation conversation, String[] d, IntHolder mapCountHolder, IntHolder dataSizeHolder, List stringList) {
        this.calculate1dArrayHeaderSize(mapCountHolder, dataSizeHolder);
        for (int i = 0; i < d.length; ++i) {
            this.calculateStringNTSize(conversation, d[i], mapCountHolder, dataSizeHolder, stringList);
        }
    }

    protected void calculateStringNT2dArraySize(Conversation conversation, String[][] d, IntHolder mapCountHolder, IntHolder dataSizeHolder, List stringList) {
        this.calculate2dArrayHeaderSize(mapCountHolder, dataSizeHolder);
        for (int i = 0; i < d.length; ++i) {
            for (int j = 0; j < d[i].length; ++j) {
                this.calculateStringNTSize(conversation, d[i][j], mapCountHolder, dataSizeHolder, stringList);
            }
        }
    }

    protected void calculateUUIDSize(Conversation conversation, UUID d, IntHolder mapCountHolder, IntHolder dataSizeHolder, List stringList) {
        String str = UUIDConverter.uuidToString(d);
        ByteBuffer strBuf = this.stringToBuffer(conversation, str);
        stringList.add(strBuf);
        int dataSize = strBuf.remaining() + 1;
        int mapCount = this.calculateMapCount(dataSize);
        mapCountHolder.value += mapCount;
        dataSizeHolder.value += dataSize;
    }

    protected void calculateUUID1dArraySize(Conversation conversation, UUID[] d, IntHolder mapCountHolder, IntHolder dataSizeHolder, List stringList) {
        this.calculate1dArrayHeaderSize(mapCountHolder, dataSizeHolder);
        for (int i = 0; i < d.length; ++i) {
            this.calculateUUIDSize(conversation, d[i], mapCountHolder, dataSizeHolder, stringList);
        }
    }

    protected void calculateUUID2dArraySize(Conversation conversation, UUID[][] d, IntHolder mapCountHolder, IntHolder dataSizeHolder, List stringList) {
        this.calculate2dArrayHeaderSize(mapCountHolder, dataSizeHolder);
        for (int i = 0; i < d.length; ++i) {
            for (int j = 0; j < d[i].length; ++j) {
                this.calculateUUIDSize(conversation, d[i][j], mapCountHolder, dataSizeHolder, stringList);
            }
        }
    }

    protected void calculateWZXUnsignedIntSize(Conversation conversation, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculatePrimitiveDataSize(4, 1, mapCountHolder, dataSizeHolder);
    }

    protected void calculateWZXOctet1dArrayNTSize(Conversation conversation, byte[] d, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        int l = d.length + 1;
        mapCountHolder.value += this.calculateMapCount(l);
        dataSizeHolder.value += l;
    }

    protected int calculateMapCount(int repFactor) {
        if (repFactor == 0) {
            return 0;
        }
        if (repFactor <= 524287) {
            return 1;
        }
        return repFactor / 524287 + 2;
    }

    private void calculatePrimitiveDataSize(int elementSize, int elementCount, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        mapCountHolder.value += this.calculateMapCount(elementCount);
        dataSizeHolder.value += elementSize * elementCount;
    }

    private void calculate1dArrayHeaderSize(IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        mapCountHolder.value += 2 * this.calculateMapCount(1);
        dataSizeHolder.value += 6;
    }

    private void calculate2dArrayHeaderSize(IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        mapCountHolder.value += this.calculateMapCount(1) + this.calculateMapCount(2);
        dataSizeHolder.value += 10;
    }

    private void calculatePrimitive1dArraySize(int elementSize, java.lang.Object d, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculate1dArrayHeaderSize(mapCountHolder, dataSizeHolder);
        int l = Array.getLength(d);
        this.calculatePrimitiveDataSize(elementSize, l, mapCountHolder, dataSizeHolder);
    }

    private void calculatePrimitive2dArraySize(int elementSize, java.lang.Object d, IntHolder mapCountHolder, IntHolder dataSizeHolder) {
        this.calculate2dArrayHeaderSize(mapCountHolder, dataSizeHolder);
        int l1 = Array.getLength(d);
        int l2 = l1 > 0 ? Array.getLength(Array.get(d, 0)) : 0;
        int l = l1 * l2;
        this.calculatePrimitiveDataSize(elementSize, l, mapCountHolder, dataSizeHolder);
    }

    protected void marshalPacket(Conversation conversation, OutboundPacket packet, ByteBuffer buf) {
        this.marshalHeader(conversation, packet, buf);
        this.marshalPayload(conversation, packet, buf);
        buf.rewind();
    }

    protected void marshalHeader(Conversation conversation, OutboundPacket packet, ByteBuffer buf) {
        int packetSize = packet.getSize();
        buf.putInt(packetSize);
        int clientID = packet.getClientId();
        buf.putInt(clientID);
        int objectID = packet.getObjectId();
        buf.putInt(objectID);
        int methodID = packet.getMethodId();
        buf.putInt(methodID);
        int replyID = packet.getReplyId();
        buf.putInt(replyID);
        int type = packet.getType();
        buf.putInt(type);
        int mapCount = packet.getMapCount();
        buf.putInt(mapCount);
        String uuid = packet.getUuid();
        this.encodeString(conversation, uuid, buf);
    }

    protected void marshalPayload(Conversation conversation, OutboundPacket packet, ByteBuffer buf) {
        int packetSize = packet.getSize();
        if (packetSize == 64) {
            return;
        }
        ByteBuffer mapBuf = buf;
        ByteBuffer dataBuf = BufferManager.duplicate(buf);
        int mapCount = packet.getMapCount();
        int mapSize = mapCount * 4;
        int dataPos = 64 + mapSize;
        dataBuf.position(dataPos);
        if (packet.isReply()) {
            Integer RC = packet.getRC();
            int rc = RC;
            this.marshalWZXUnsignedInt(conversation, rc, mapBuf, dataBuf);
            int packetType = packet.getType();
            int methodID = packet.getMethodId();
            if (packetType == 2 && (methodID == 1 || methodID == 2)) {
                int refCount = 2 - methodID;
                this.marshalWZXUnsignedInt(conversation, refCount, mapBuf, dataBuf);
            }
        }
        this.marshalParameterArray(conversation, packet, mapBuf, dataBuf);
    }

    protected void marshalParameterArray(Conversation conversation, OutboundPacket packet, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        AnyImpl[] parmArray = packet.getParameterArray();
        if (parmArray != null && parmArray.length > 0) {
            List stringLst = packet.getEncodedStringLst();
            Iterator stringItr = stringLst.iterator();
            for (int i = 0; i < parmArray.length; ++i) {
                AnyImpl parm = parmArray[i];
                this.marshalParameter(conversation, parm, mapBuf, dataBuf, stringItr);
            }
        }
    }

    protected final void marshalParameter(Conversation conversation, AnyImpl a, ByteBuffer mapBuf, ByteBuffer dataBuf, Iterator stringItr) {
        int iomTC = a.iomType();
        switch (iomTC) {
            case 33: {
                Any aa = (Any)a.extractIOM();
                this.marshalAny(conversation, aa, mapBuf, dataBuf, stringItr);
                break;
            }
            case 34: {
                Any[] aa = (Any[])a.extractIOM();
                this.marshalAny1dArray(conversation, aa, mapBuf, dataBuf, stringItr);
                break;
            }
            case 35: {
                Any[][] aa = (Any[][])a.extractIOM();
                this.marshalAny2dArray(conversation, aa, mapBuf, dataBuf, stringItr);
                break;
            }
            case 0: {
                boolean b = (Boolean)a.extractIOM();
                this.marshalBoolean(conversation, b, mapBuf, dataBuf);
                break;
            }
            case 1: {
                boolean[] b = (boolean[])a.extractIOM();
                this.marshalBoolean1dArray(conversation, b, mapBuf, dataBuf);
                break;
            }
            case 2: {
                boolean[][] b = (boolean[][])a.extractIOM();
                this.marshalBoolean2dArray(conversation, b, mapBuf, dataBuf);
                break;
            }
            case 27: {
                long d = (Long)a.extractIOM();
                this.marshalDatetime(conversation, d, mapBuf, dataBuf);
                break;
            }
            case 28: {
                long[] d = (long[])a.extractIOM();
                this.marshalDatetime1dArray(conversation, d, mapBuf, dataBuf);
                break;
            }
            case 29: {
                long[][] d = (long[][])a.extractIOM();
                this.marshalDatetime2dArray(conversation, d, mapBuf, dataBuf);
                break;
            }
            case 15: {
                double d = (Double)a.extractIOM();
                this.marshalDouble(conversation, d, mapBuf, dataBuf);
                break;
            }
            case 16: {
                double[] d = (double[])a.extractIOM();
                this.marshalDouble1dArray(conversation, d, mapBuf, dataBuf);
                break;
            }
            case 17: {
                double[][] d = (double[][])a.extractIOM();
                this.marshalDouble2dArray(conversation, d, mapBuf, dataBuf);
                break;
            }
            case 21: {
                int e = ((Long)a.extractIOM()).intValue();
                this.marshalEnum(conversation, e, mapBuf, dataBuf);
                break;
            }
            case 22: {
                int[] e = (int[])a.extractIOM();
                this.marshalEnum1dArray(conversation, e, mapBuf, dataBuf);
                break;
            }
            case 23: {
                int[][] e = (int[][])a.extractIOM();
                this.marshalEnum2dArray(conversation, e, mapBuf, dataBuf);
                break;
            }
            case 12: {
                float f = ((Double)a.extractIOM()).floatValue();
                this.marshalFloat(conversation, f, mapBuf, dataBuf);
                break;
            }
            case 13: {
                float[] f = (float[])a.extractIOM();
                this.marshalFloat1dArray(conversation, f, mapBuf, dataBuf);
                break;
            }
            case 14: {
                float[][] f = (float[][])a.extractIOM();
                this.marshalFloat2Array(conversation, f, mapBuf, dataBuf);
                break;
            }
            case 36: {
                long i = (Long)a.extractIOM();
                this.marshalInt64(conversation, i, mapBuf, dataBuf);
                break;
            }
            case 37: {
                long[] i = (long[])a.extractIOM();
                this.marshalInt641dArray(conversation, i, mapBuf, dataBuf);
                break;
            }
            case 38: {
                long[][] i = (long[][])a.extractIOM();
                this.marshalInt642dArray(conversation, i, mapBuf, dataBuf);
                break;
            }
            case 9: {
                int l = ((Long)a.extractIOM()).intValue();
                this.marshalLong(conversation, l, mapBuf, dataBuf);
                break;
            }
            case 10: {
                int[] l = (int[])a.extractIOM();
                this.marshalLong1dArray(conversation, l, mapBuf, dataBuf);
                break;
            }
            case 11: {
                int[][] l = (int[][])a.extractIOM();
                this.marshalLong2dArray(conversation, l, mapBuf, dataBuf);
                break;
            }
            case 39: {
                break;
            }
            case 24: {
                Object obj = (Object)a.extractIOM();
                this.marshalObject(conversation, obj, mapBuf, dataBuf);
                break;
            }
            case 3: {
                byte o = ((Long)a.extractIOM()).byteValue();
                this.marshalOctet(conversation, o, mapBuf, dataBuf);
                break;
            }
            case 4: {
                byte[] o = (byte[])a.extractIOM();
                this.marshalOctet1dArray(conversation, o, mapBuf, dataBuf);
                break;
            }
            case 5: {
                byte[][] o = (byte[][])a.extractIOM();
                this.marshalOctet2dArray(conversation, o, mapBuf, dataBuf);
                break;
            }
            case 6: {
                short s = ((Long)a.extractIOM()).shortValue();
                this.marshalShort(conversation, s, mapBuf, dataBuf);
                break;
            }
            case 7: {
                short[] s = (short[])a.extractIOM();
                this.marshalShort1dArray(conversation, s, mapBuf, dataBuf);
                break;
            }
            case 8: {
                short[][] s = (short[][])a.extractIOM();
                this.marshalShort2dArray(conversation, s, mapBuf, dataBuf);
                break;
            }
            case 18: {
                String s = (String)a.extractIOM();
                this.marshalStringNT(conversation, s, mapBuf, dataBuf, stringItr);
                break;
            }
            case 19: {
                String[] s = (String[])a.extractIOM();
                this.marshalStringNT1dArray(conversation, s, mapBuf, dataBuf, stringItr);
                break;
            }
            case 20: {
                String[][] s = (String[][])a.extractIOM();
                this.marshalStringNT2dArray(conversation, s, mapBuf, dataBuf, stringItr);
                break;
            }
            case 30: {
                UUID u = (UUID)a.extractIOM();
                this.marshalUUID(conversation, u, mapBuf, dataBuf, stringItr);
                break;
            }
            case 31: {
                UUID[] u = (UUID[])a.extractIOM();
                this.marshalUUID1dArray(conversation, u, mapBuf, dataBuf, stringItr);
                break;
            }
            case 32: {
                UUID[][] u = (UUID[][])a.extractIOM();
                this.marshalUUID2dArray(conversation, u, mapBuf, dataBuf, stringItr);
                break;
            }
            default: {
                throw new INTERNAL();
            }
        }
    }

    protected void marshalAny(Conversation conversation, Any d, ByteBuffer mapBuf, ByteBuffer dataBuf, Iterator stringItr) {
        if (d instanceof AnyImpl) {
            AnyImpl _d = (AnyImpl)d;
            int iomTC = _d.iomType();
            this.marshalAnyTC(conversation, iomTC, mapBuf, dataBuf);
            this.marshalParameter(conversation, _d, mapBuf, dataBuf, stringItr);
        } else {
            TypeCode orbTC = d.type();
            int iomTC = TypeCodeImpl.typeCodeToIOMType(orbTC);
            this.marshalAnyTC(conversation, iomTC, mapBuf, dataBuf);
            this.extractAndMarshal(conversation, d, iomTC, mapBuf, dataBuf, stringItr);
        }
    }

    protected void marshalAny1dArray(Conversation conversation, Any[] d, ByteBuffer mapBuf, ByteBuffer dataBuf, Iterator stringItr) {
        this.marshalShort(conversation, (short)1, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong(conversation, d.length, mapBuf, dataBuf);
        for (int i = 0; i < d.length; ++i) {
            this.marshalAny(conversation, d[i], mapBuf, dataBuf, stringItr);
        }
    }

    protected void marshalAny2dArray(Conversation conversation, Any[][] d, ByteBuffer mapBuf, ByteBuffer dataBuf, Iterator stringItr) {
        int l0 = d.length;
        int l1 = l0 > 0 ? d[0].length : 0;
        this.marshalShort(conversation, (short)2, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong1dArray2Elements(conversation, l0, l1, mapBuf, dataBuf);
        for (int i0 = 0; i0 < l0; ++i0) {
            for (int i1 = 0; i1 < l1; ++i1) {
                this.marshalAny(conversation, d[i0][i1], mapBuf, dataBuf, stringItr);
            }
        }
    }

    protected void marshalBoolean(Conversation conversation, boolean d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.marshalBooleanData(d, dataBuf);
        Marshaller.marshalMaps(0x7000000, 1, mapBuf);
    }

    protected void marshalBoolean1dArray(Conversation conversation, boolean[] d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        this.marshalShort(conversation, (short)1, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong(conversation, d.length, mapBuf, dataBuf);
        if (d.length > 0) {
            Marshaller.marshalMaps(0x7000000, d.length, mapBuf);
            for (int i = 0; i < d.length; ++i) {
                Marshaller.marshalBooleanData(d[i], dataBuf);
            }
        }
    }

    protected void marshalBoolean2dArray(Conversation conversation, boolean[][] d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        int l0 = d.length;
        int l1 = l0 > 0 ? d[0].length : 0;
        int l = l0 * l1;
        this.marshalShort(conversation, (short)2, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong1dArray2Elements(conversation, l0, l1, mapBuf, dataBuf);
        if (l > 0) {
            Marshaller.marshalMaps(0x7000000, l, mapBuf);
            for (int i0 = 0; i0 < l0; ++i0) {
                for (int i1 = 0; i1 < l1; ++i1) {
                    Marshaller.marshalBooleanData(d[i0][i1], dataBuf);
                }
            }
        }
    }

    protected void marshalDatetime(Conversation conversation, long d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        this.marshalInt64(conversation, d, mapBuf, dataBuf);
    }

    protected void marshalDatetime1dArray(Conversation conversation, long[] d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        this.marshalInt641dArray(conversation, d, mapBuf, dataBuf);
    }

    protected void marshalDatetime2dArray(Conversation conversation, long[][] d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        this.marshalInt642dArray(conversation, d, mapBuf, dataBuf);
    }

    protected void marshalDouble(Conversation conversation, double d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        dataBuf.putDouble(d);
        Marshaller.marshalMaps(0x5000000, 1, mapBuf);
    }

    protected void marshalDouble1dArray(Conversation conversation, double[] d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        this.marshalShort(conversation, (short)1, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong(conversation, d.length, mapBuf, dataBuf);
        if (d.length > 0) {
            Marshaller.marshalMaps(0x5000000, d.length, mapBuf);
            for (int i = 0; i < d.length; ++i) {
                dataBuf.putDouble(d[i]);
            }
        }
    }

    protected void marshalDouble2dArray(Conversation conversation, double[][] d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        int l0 = d.length;
        int l1 = l0 > 0 ? d[0].length : 0;
        int l = l0 * l1;
        this.marshalShort(conversation, (short)2, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong1dArray2Elements(conversation, l0, l1, mapBuf, dataBuf);
        if (l > 0) {
            Marshaller.marshalMaps(0x5000000, l, mapBuf);
            for (int i0 = 0; i0 < l0; ++i0) {
                for (int i1 = 0; i1 < l1; ++i1) {
                    dataBuf.putDouble(d[i0][i1]);
                }
            }
        }
    }

    protected void marshalEnum(Conversation conversation, int d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        this.marshalWZXUnsignedInt(conversation, d, mapBuf, dataBuf);
    }

    protected void marshalEnum1dArray(Conversation conversation, int[] d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        this.marshalShort(conversation, (short)1, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong(conversation, d.length, mapBuf, dataBuf);
        if (d.length > 0) {
            Marshaller.marshalMaps(0x3400000, d.length, mapBuf);
            for (int i = 0; i < d.length; ++i) {
                dataBuf.putInt(d[i]);
            }
        }
    }

    protected void marshalEnum2dArray(Conversation conversation, int[][] d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        int l0 = d.length;
        int l1 = l0 > 0 ? d[0].length : 0;
        int l = l0 * l1;
        this.marshalShort(conversation, (short)2, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong1dArray2Elements(conversation, l0, l1, mapBuf, dataBuf);
        if (l > 0) {
            Marshaller.marshalMaps(0x3400000, l, mapBuf);
            for (int i0 = 0; i0 < l0; ++i0) {
                for (int i1 = 0; i1 < l1; ++i1) {
                    dataBuf.putInt(d[i0][i1]);
                }
            }
        }
    }

    protected void marshalFloat(Conversation conversation, float d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        this.marshalDouble(conversation, d, mapBuf, dataBuf);
    }

    protected void marshalFloat1dArray(Conversation conversation, float[] d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        this.marshalShort(conversation, (short)1, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong(conversation, d.length, mapBuf, dataBuf);
        if (d.length > 0) {
            Marshaller.marshalMaps(0x5000000, d.length, mapBuf);
            for (int i = 0; i < d.length; ++i) {
                dataBuf.putDouble(d[i]);
            }
        }
    }

    protected void marshalFloat2Array(Conversation conversation, float[][] d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        int l0 = d.length;
        int l1 = l0 > 0 ? d[0].length : 0;
        int l = l0 * l1;
        this.marshalShort(conversation, (short)2, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong1dArray2Elements(conversation, l0, l1, mapBuf, dataBuf);
        if (l > 0) {
            Marshaller.marshalMaps(0x5000000, l, mapBuf);
            for (int i0 = 0; i0 < l0; ++i0) {
                for (int i1 = 0; i1 < l1; ++i1) {
                    dataBuf.putDouble(d[i0][i1]);
                }
            }
        }
    }

    protected void marshalInt64(Conversation conversation, long d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        dataBuf.putLong(d);
        Marshaller.marshalMaps(0x19000000, 1, mapBuf);
    }

    protected void marshalInt641dArray(Conversation conversation, long[] d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        this.marshalShort(conversation, (short)1, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong(conversation, d.length, mapBuf, dataBuf);
        if (d.length > 0) {
            Marshaller.marshalMaps(0x19000000, d.length, mapBuf);
            for (int i = 0; i < d.length; ++i) {
                dataBuf.putLong(d[i]);
            }
        }
    }

    protected void marshalInt642dArray(Conversation conversation, long[][] d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        int l0 = d.length;
        int l1 = l0 > 0 ? d[0].length : 0;
        int l = l0 * l1;
        this.marshalShort(conversation, (short)2, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong1dArray2Elements(conversation, l0, l1, mapBuf, dataBuf);
        if (l > 0) {
            Marshaller.marshalMaps(0x19000000, l, mapBuf);
            for (int i0 = 0; i0 < l0; ++i0) {
                for (int i1 = 0; i1 < l1; ++i1) {
                    dataBuf.putLong(d[i0][i1]);
                }
            }
        }
    }

    protected void marshalLong(Conversation conversation, int d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        dataBuf.putInt(d);
        Marshaller.marshalMaps(0x1000000, 1, mapBuf);
    }

    protected void marshalLong1dArray(Conversation conversation, int[] d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        this.marshalShort(conversation, (short)1, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong(conversation, d.length, mapBuf, dataBuf);
        if (d.length > 0) {
            Marshaller.marshalMaps(0x1000000, d.length, mapBuf);
            for (int x = 0; x < d.length; ++x) {
                dataBuf.putInt(d[x]);
            }
        }
    }

    protected void marshalLong2dArray(Conversation conversation, int[][] d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        int l0 = d.length;
        int l1 = l0 > 0 ? d[0].length : 0;
        int l = l0 * l1;
        this.marshalShort(conversation, (short)2, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong1dArray2Elements(conversation, l0, l1, mapBuf, dataBuf);
        if (l > 0) {
            Marshaller.marshalMaps(0x1000000, l, mapBuf);
            for (int i0 = 0; i0 < l0; ++i0) {
                for (int i1 = 0; i1 < l1; ++i1) {
                    dataBuf.putInt(d[i0][i1]);
                }
            }
        }
    }

    protected void marshalObject(Conversation conversation, Object d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        int objectID = this.objectToObjectID(conversation, d);
        this.marshalWZXUnsignedInt(conversation, objectID, mapBuf, dataBuf);
    }

    protected void marshalOctet(Conversation conversation, byte d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        dataBuf.put(d);
        Marshaller.marshalMaps(0x7000000, 1, mapBuf);
    }

    protected void marshalOctet1dArray(Conversation conversation, byte[] d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        this.marshalShort(conversation, (short)1, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong(conversation, d.length, mapBuf, dataBuf);
        if (d.length > 0) {
            Marshaller.marshalMaps(0x7000000, d.length, mapBuf);
            dataBuf.put(d);
        }
    }

    protected void marshalOctet2dArray(Conversation conversation, byte[][] d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        int l0 = d.length;
        int l1 = l0 > 0 ? d[0].length : 0;
        int l = l0 * l1;
        this.marshalShort(conversation, (short)2, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong1dArray2Elements(conversation, l0, l1, mapBuf, dataBuf);
        if (l > 0) {
            Marshaller.marshalMaps(0x7000000, l, mapBuf);
            for (int i0 = 0; i0 < l0; ++i0) {
                dataBuf.put(d[i0]);
            }
        }
    }

    protected void marshalShort(Conversation conversation, short d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        dataBuf.putShort(d);
        Marshaller.marshalMaps(0x2000000, 1, mapBuf);
    }

    protected void marshalShort1dArray(Conversation conversation, short[] d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        this.marshalShort(conversation, (short)1, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong(conversation, d.length, mapBuf, dataBuf);
        if (d.length > 0) {
            Marshaller.marshalMaps(0x2000000, d.length, mapBuf);
            for (int i = 0; i < d.length; ++i) {
                dataBuf.putShort(d[i]);
            }
        }
    }

    protected void marshalShort2dArray(Conversation conversation, short[][] d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        int l0 = d.length;
        int l1 = l0 > 0 ? d[0].length : 0;
        int l = l0 * l1;
        this.marshalShort(conversation, (short)2, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong1dArray2Elements(conversation, l0, l1, mapBuf, dataBuf);
        if (l > 0) {
            Marshaller.marshalMaps(0x2000000, l, mapBuf);
            for (int i0 = 0; i0 < l0; ++i0) {
                for (int i1 = 0; i1 < l1; ++i1) {
                    dataBuf.putShort(d[i0][i1]);
                }
            }
        }
    }

    protected void marshalStringNT(Conversation conversation, String d, ByteBuffer mapBuf, ByteBuffer dataBuf, Iterator stringItr) {
        ByteBuffer b = stringItr != null ? (ByteBuffer)stringItr.next() : this.stringToBuffer(conversation, d);
        int r = b.remaining() + 1;
        dataBuf.put(b);
        dataBuf.put((byte)0);
        Marshaller.marshalMaps(0x6400000, r, mapBuf);
    }

    protected void marshalStringNT1dArray(Conversation conversation, String[] d, ByteBuffer mapBuf, ByteBuffer dataBuf, Iterator stringItr) {
        this.marshalShort(conversation, (short)1, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong(conversation, d.length, mapBuf, dataBuf);
        for (int i = 0; i < d.length; ++i) {
            this.marshalStringNT(conversation, d[i], mapBuf, dataBuf, stringItr);
        }
    }

    protected void marshalStringNT2dArray(Conversation conversation, String[][] d, ByteBuffer mapBuf, ByteBuffer dataBuf, Iterator stringItr) {
        int l0 = d.length;
        int l1 = l0 > 0 ? d[0].length : 0;
        this.marshalShort(conversation, (short)2, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong1dArray2Elements(conversation, l0, l1, mapBuf, dataBuf);
        for (int i0 = 0; i0 < l0; ++i0) {
            for (int i1 = 0; i1 < l1; ++i1) {
                this.marshalStringNT(conversation, d[i0][i1], mapBuf, dataBuf, stringItr);
            }
        }
    }

    protected void marshalUUID(Conversation conversation, UUID d, ByteBuffer mapBuf, ByteBuffer dataBuf, Iterator stringItr) {
        ByteBuffer b = null;
        if (stringItr != null) {
            b = (ByteBuffer)stringItr.next();
        } else {
            String s = UUIDConverter.uuidToString(d);
            b = this.stringToBuffer(conversation, s);
        }
        int r = b.remaining() + 1;
        dataBuf.put(b);
        dataBuf.put((byte)0);
        Marshaller.marshalMaps(0x6400000, r, mapBuf);
    }

    protected void marshalUUID1dArray(Conversation conversation, UUID[] d, ByteBuffer mapBuf, ByteBuffer dataBuf, Iterator stringItr) {
        this.marshalShort(conversation, (short)1, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong(conversation, d.length, mapBuf, dataBuf);
        for (int i = 0; i < d.length; ++i) {
            this.marshalUUID(conversation, d[i], mapBuf, dataBuf, stringItr);
        }
    }

    protected void marshalUUID2dArray(Conversation conversation, UUID[][] d, ByteBuffer mapBuf, ByteBuffer dataBuf, Iterator stringItr) {
        int l0 = d.length;
        int l1 = l0 > 0 ? d[0].length : 0;
        this.marshalShort(conversation, (short)2, mapBuf, dataBuf);
        this.marshalWZXUnsignedLong1dArray2Elements(conversation, l0, l1, mapBuf, dataBuf);
        for (int i0 = 0; i0 < l0; ++i0) {
            for (int i1 = 0; i1 < l1; ++i1) {
                this.marshalUUID(conversation, d[i0][i1], mapBuf, dataBuf, stringItr);
            }
        }
    }

    protected void marshalWZXOctet1dArrayNT(Conversation conversation, byte[] d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        int l = d.length + 1;
        dataBuf.put(d);
        dataBuf.put((byte)0);
        Marshaller.marshalMaps(0x7000000, l, mapBuf);
    }

    protected void marshalWZXUnsignedChar1dArrayNTFromBuf(Conversation conversation, ByteBuffer d, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        int l = this.marshalBufNTData(conversation, d, dataBuf);
        Marshaller.marshalMaps(0x6400000, l, mapBuf);
    }

    protected void marshalWZXUnsignedInt(Conversation conversation, int i, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        dataBuf.putInt(i);
        Marshaller.marshalMaps(0x3400000, 1, mapBuf);
    }

    protected void marshalWZXUnsignedLong(Conversation converation, int l, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        dataBuf.putInt(l);
        Marshaller.marshalMaps(0x1400000, 1, mapBuf);
    }

    protected void marshalWZXUnsignedLong1dArray2Elements(Conversation converation, int l0, int l1, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        dataBuf.putInt(l0);
        dataBuf.putInt(l1);
        Marshaller.marshalMaps(0x1400000, 2, mapBuf);
    }

    protected static void marshalMaps(int wzxType, int repFactor, ByteBuffer mapBuf) {
        if (repFactor == 0) {
            return;
        }
        if (repFactor <= 524287) {
            mapBuf.putInt(wzxType | repFactor);
        } else {
            mapBuf.putInt(wzxType | Integer.MIN_VALUE);
            do {
                mapBuf.putInt(wzxType | Integer.MIN_VALUE | 0x7FFFF);
            } while ((repFactor -= 524287) > 524287);
            mapBuf.putInt(wzxType | repFactor);
        }
    }

    private void marshalAnyTC(Conversation conversation, int iomTC, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        short anyTC = Marshaller.iomTypeToAnyType(iomTC);
        this.marshalShort(conversation, anyTC, mapBuf, dataBuf);
    }

    private int marshalBufNTData(Conversation conversation, ByteBuffer d, ByteBuffer dataBuf) {
        int l = 1;
        if (d != null) {
            l += d.remaining();
            dataBuf.put(d);
        }
        dataBuf.put((byte)0);
        return l;
    }

    private static void marshalBooleanData(boolean b, ByteBuffer dataBuf) {
        byte v = b ? (byte)1 : 0;
        dataBuf.put(v);
    }

    protected void unmarshalHeader(Conversation conversation, InboundPacket packet, ByteBuffer buf) {
        int tempInt = buf.getInt();
        packet.setSize(tempInt);
        tempInt = buf.getInt();
        packet.setClientId(tempInt);
        tempInt = buf.getInt();
        packet.setObjectId(tempInt);
        tempInt = buf.getInt();
        packet.setMethodId(tempInt);
        tempInt = buf.getInt();
        packet.setReplyId(tempInt);
        tempInt = buf.getInt();
        packet.setType(tempInt);
        tempInt = buf.getInt();
        packet.setMapCount(tempInt);
        String uuid = this.decodeString(conversation, buf, 36);
        packet.setUuid(uuid);
    }

    protected final java.lang.Object unmarshalParameter(Conversation conversation, int iomType, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        switch (iomType) {
            case 33: {
                return this.unmarshalAny(conversation, mapBuf, dataBuf);
            }
            case 34: {
                return this.unmarshalAny1dArray(conversation, mapBuf, dataBuf);
            }
            case 35: {
                return this.unmarshalAny2dArray(conversation, mapBuf, dataBuf);
            }
            case 0: {
                return new Boolean(this.unmarshalBoolean(conversation, mapBuf, dataBuf));
            }
            case 1: {
                return this.unmarshalBoolean1dArray(conversation, mapBuf, dataBuf);
            }
            case 2: {
                return this.unmarshalBoolean2dArray(conversation, mapBuf, dataBuf);
            }
            case 27: {
                return new Long(this.unmarshalDatetime(conversation, mapBuf, dataBuf));
            }
            case 28: {
                return this.unmarshalDatetime1dArray(conversation, mapBuf, dataBuf);
            }
            case 29: {
                return this.unmarshalDatetime2dArray(conversation, mapBuf, dataBuf);
            }
            case 15: {
                return new Double(this.unmarshalDouble(conversation, mapBuf, dataBuf));
            }
            case 16: {
                return this.unmarshalDouble1dArray(conversation, mapBuf, dataBuf);
            }
            case 17: {
                return this.unmarshalDouble2dArray(conversation, mapBuf, dataBuf);
            }
            case 21: {
                return new Long(this.unmarshalEnum(conversation, mapBuf, dataBuf));
            }
            case 22: {
                return this.unmarshalEnum1dArray(conversation, mapBuf, dataBuf);
            }
            case 23: {
                return this.unmarshalEnum2dArray(conversation, mapBuf, dataBuf);
            }
            case 12: {
                return new Double(this.unmarshalFloat(conversation, mapBuf, dataBuf));
            }
            case 13: {
                return this.unmarshalFloat1dArray(conversation, mapBuf, dataBuf);
            }
            case 14: {
                return this.unmarshalFloat2dArray(conversation, mapBuf, dataBuf);
            }
            case 36: {
                return new Long(this.unmarshalInt64(conversation, mapBuf, dataBuf));
            }
            case 37: {
                return this.unmarshalInt641dArray(conversation, mapBuf, dataBuf);
            }
            case 38: {
                return this.unmarshalInt642dArray(conversation, mapBuf, dataBuf);
            }
            case 9: {
                return new Long(this.unmarshalLong(conversation, mapBuf, dataBuf));
            }
            case 10: {
                return this.unmarshalLong1dArray(conversation, mapBuf, dataBuf);
            }
            case 11: {
                return this.unmarshalLong2dArray(conversation, mapBuf, dataBuf);
            }
            case 39: {
                return null;
            }
            case 24: {
                return this.unmarshalObject(conversation, mapBuf, dataBuf);
            }
            case 3: {
                return new Long(this.unmarshalOctet(conversation, mapBuf, dataBuf));
            }
            case 4: {
                return this.unmarshalOctet1dArray(conversation, mapBuf, dataBuf);
            }
            case 5: {
                return this.unmarshalOctet2dArray(conversation, mapBuf, dataBuf);
            }
            case 6: {
                return new Long(this.unmarshalShort(conversation, mapBuf, dataBuf));
            }
            case 7: {
                return this.unmarshalShort1dArray(conversation, mapBuf, dataBuf);
            }
            case 8: {
                return this.unmarshalShort2dArray(conversation, mapBuf, dataBuf);
            }
            case 18: {
                return this.unmarshalStringNT(conversation, mapBuf, dataBuf);
            }
            case 19: {
                return this.unmarshalStringNT1dArray(conversation, mapBuf, dataBuf);
            }
            case 20: {
                return this.unmarshalStringNT2dArray(conversation, mapBuf, dataBuf);
            }
            case 30: {
                return this.unmarshalUUID(conversation, mapBuf, dataBuf);
            }
            case 31: {
                return this.unmarshalUUID1dArray(conversation, mapBuf, dataBuf);
            }
            case 32: {
                return this.unmarshalUUID2dArray(conversation, mapBuf, dataBuf);
            }
        }
        throw new NO_IMPLEMENT();
    }

    protected Any unmarshalAny(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        short anyTC = dataBuf.getShort();
        int dim = 0;
        if ((anyTC & Short.MIN_VALUE) != 0) {
            int pos = dataBuf.position();
            dim = dataBuf.getShort(pos);
        }
        int iomTC = Marshaller.anyTypeToIOMType(anyTC, dim);
        java.lang.Object val = this.unmarshalParameter(conversation, iomTC, mapBuf, dataBuf);
        ORBImpl orb = conversation.getORB();
        AnyImpl d = (AnyImpl)orb.create_any();
        d.insertIOM(iomTC, val);
        return d;
    }

    protected Any[] unmarshalAny1dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        if (dataBuf.getShort() == 0) {
            return new Any[0];
        }
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1400000, 1);
        int l = dataBuf.getInt();
        Any[] d = new Any[l];
        for (int i = 0; i < l; ++i) {
            d[i] = this.unmarshalAny(conversation, mapBuf, dataBuf);
        }
        return d;
    }

    protected Any[][] unmarshalAny2dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        if (dataBuf.getShort() == 0) {
            return new Any[0][0];
        }
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1400000, 2);
        int l0 = dataBuf.getInt();
        int l1 = dataBuf.getInt();
        Any[][] d = new Any[l0][l1];
        for (int i0 = 0; i0 < l0; ++i0) {
            for (int i1 = 0; i1 < l1; ++i1) {
                d[i0][i1] = this.unmarshalAny(conversation, mapBuf, dataBuf);
            }
        }
        return d;
    }

    protected boolean unmarshalBoolean(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x7000000, 1);
        return Marshaller.unmarshalBooleanData(dataBuf);
    }

    protected boolean[] unmarshalBoolean1dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        if (dataBuf.getShort() == 0) {
            return new boolean[0];
        }
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1400000, 1);
        int l = dataBuf.getInt();
        boolean[] d = new boolean[l];
        if (l > 0) {
            Marshaller.unmarshalMaps(conversation, mapBuf, 0x7000000, l);
            for (int i = 0; i < l; ++i) {
                d[i] = Marshaller.unmarshalBooleanData(dataBuf);
            }
        }
        return d;
    }

    protected boolean[][] unmarshalBoolean2dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        if (dataBuf.getShort() == 0) {
            return new boolean[0][0];
        }
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1400000, 2);
        int l0 = dataBuf.getInt();
        int l1 = dataBuf.getInt();
        int l = l0 * l1;
        boolean[][] d = new boolean[l0][l1];
        if (l > 0) {
            Marshaller.unmarshalMaps(conversation, mapBuf, 0x7000000, l);
            for (int i0 = 0; i0 < l0; ++i0) {
                for (int i1 = 0; i1 < l1; ++i1) {
                    d[i0][i1] = Marshaller.unmarshalBooleanData(dataBuf);
                }
            }
        }
        return d;
    }

    protected long unmarshalDatetime(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        return this.unmarshalInt64(conversation, mapBuf, dataBuf);
    }

    protected long[] unmarshalDatetime1dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        return this.unmarshalInt641dArray(conversation, mapBuf, dataBuf);
    }

    protected long[][] unmarshalDatetime2dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        return this.unmarshalInt642dArray(conversation, mapBuf, dataBuf);
    }

    protected double unmarshalDouble(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x5000000, 1);
        return dataBuf.getDouble();
    }

    protected double[] unmarshalDouble1dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        if (dataBuf.getShort() == 0) {
            return new double[0];
        }
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1400000, 1);
        int l = dataBuf.getInt();
        double[] d = new double[l];
        if (l > 0) {
            Marshaller.unmarshalMaps(conversation, mapBuf, 0x5000000, l);
            for (int i = 0; i < l; ++i) {
                d[i] = dataBuf.getDouble();
            }
        }
        return d;
    }

    protected double[][] unmarshalDouble2dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        if (dataBuf.getShort() == 0) {
            return new double[0][0];
        }
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1400000, 2);
        int l0 = dataBuf.getInt();
        int l1 = dataBuf.getInt();
        int l = l0 * l1;
        double[][] d = new double[l0][l1];
        if (l > 0) {
            Marshaller.unmarshalMaps(conversation, mapBuf, 0x5000000, l);
            for (int i0 = 0; i0 < l0; ++i0) {
                for (int i1 = 0; i1 < l1; ++i1) {
                    d[i0][i1] = dataBuf.getDouble();
                }
            }
        }
        return d;
    }

    protected int unmarshalEnum(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        return this.unmarshalWZXUnsignedInt(conversation, mapBuf, dataBuf);
    }

    protected int[] unmarshalEnum1dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        if (dataBuf.getShort() == 0) {
            return new int[0];
        }
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1400000, 1);
        int l = dataBuf.getInt();
        int[] d = new int[l];
        if (l > 0) {
            Marshaller.unmarshalMaps(conversation, mapBuf, 0x3400000, l);
            for (int i = 0; i < l; ++i) {
                d[i] = dataBuf.getInt();
            }
        }
        return d;
    }

    protected int[][] unmarshalEnum2dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        if (dataBuf.getShort() == 0) {
            return new int[0][0];
        }
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1400000, 2);
        int l0 = dataBuf.getInt();
        int l1 = dataBuf.getInt();
        int l = l0 * l1;
        int[][] d = new int[l0][l1];
        if (l > 0) {
            Marshaller.unmarshalMaps(conversation, mapBuf, 0x3400000, l);
            for (int i0 = 0; i0 < l0; ++i0) {
                for (int i1 = 0; i1 < l1; ++i1) {
                    d[i0][i1] = dataBuf.getInt();
                }
            }
        }
        return d;
    }

    protected float unmarshalFloat(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        return (float)this.unmarshalDouble(conversation, mapBuf, dataBuf);
    }

    protected float[] unmarshalFloat1dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        if (dataBuf.getShort() == 0) {
            return new float[0];
        }
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1400000, 1);
        int l = dataBuf.getInt();
        float[] d = new float[l];
        if (l > 0) {
            Marshaller.unmarshalMaps(conversation, mapBuf, 0x5000000, l);
            for (int i = 0; i < l; ++i) {
                d[i] = (float)dataBuf.getDouble();
            }
        }
        return d;
    }

    protected float[][] unmarshalFloat2dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        if (dataBuf.getShort() == 0) {
            return new float[0][0];
        }
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1400000, 2);
        int l0 = dataBuf.getInt();
        int l1 = dataBuf.getInt();
        int l = l0 * l1;
        float[][] d = new float[l0][l1];
        if (l > 0) {
            Marshaller.unmarshalMaps(conversation, mapBuf, 0x5000000, l);
            for (int i0 = 0; i0 < l0; ++i0) {
                for (int i1 = 0; i1 < l1; ++i1) {
                    d[i0][i1] = (float)dataBuf.getDouble();
                }
            }
        }
        return d;
    }

    protected long unmarshalInt64(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x19000000, 1);
        return dataBuf.getLong();
    }

    protected long[] unmarshalInt641dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        if (dataBuf.getShort() == 0) {
            return new long[0];
        }
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1400000, 1);
        int l = dataBuf.getInt();
        long[] d = new long[l];
        if (l > 0) {
            Marshaller.unmarshalMaps(conversation, mapBuf, 0x19000000, l);
            for (int i = 0; i < l; ++i) {
                d[i] = dataBuf.getLong();
            }
        }
        return d;
    }

    protected long[][] unmarshalInt642dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        if (dataBuf.getShort() == 0) {
            return new long[0][0];
        }
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1400000, 2);
        int l0 = dataBuf.getInt();
        int l1 = dataBuf.getInt();
        int l = l0 * l1;
        long[][] d = new long[l0][l1];
        if (l > 0) {
            Marshaller.unmarshalMaps(conversation, mapBuf, 0x19000000, l);
            for (int i0 = 0; i0 < l0; ++i0) {
                for (int i1 = 0; i1 < l1; ++i1) {
                    d[i0][i1] = dataBuf.getLong();
                }
            }
        }
        return d;
    }

    protected int unmarshalLong(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1000000, 1);
        return dataBuf.getInt();
    }

    protected int[] unmarshalLong1dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        if (dataBuf.getShort() == 0) {
            return new int[0];
        }
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1400000, 1);
        int l = dataBuf.getInt();
        int[] d = new int[l];
        if (l > 0) {
            Marshaller.unmarshalMaps(conversation, mapBuf, 0x1000000, l);
            for (int i = 0; i < l; ++i) {
                d[i] = dataBuf.getInt();
            }
        }
        return d;
    }

    protected int[][] unmarshalLong2dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        if (dataBuf.getShort() == 0) {
            return new int[0][0];
        }
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1400000, 2);
        int l0 = dataBuf.getInt();
        int l1 = dataBuf.getInt();
        int l = l0 * l1;
        int[][] d = new int[l0][l1];
        if (l > 0) {
            Marshaller.unmarshalMaps(conversation, mapBuf, 0x1000000, l);
            for (int i0 = 0; i0 < l0; ++i0) {
                for (int i1 = 0; i1 < l1; ++i1) {
                    d[i0][i1] = dataBuf.getInt();
                }
            }
        }
        return d;
    }

    protected Object unmarshalObject(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        int objectID = this.unmarshalWZXUnsignedInt(conversation, mapBuf, dataBuf);
        return this.objectIDToObject(conversation, objectID);
    }

    protected byte unmarshalOctet(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x7000000, 1);
        return dataBuf.get();
    }

    protected byte[] unmarshalOctet1dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        if (dataBuf.getShort() == 0) {
            return new byte[0];
        }
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1400000, 1);
        int l = dataBuf.getInt();
        byte[] d = new byte[l];
        if (l > 0) {
            Marshaller.unmarshalMaps(conversation, mapBuf, 0x7000000, l);
            dataBuf.get(d);
        }
        return d;
    }

    protected byte[][] unmarshalOctet2dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        if (dataBuf.getShort() == 0) {
            return new byte[0][0];
        }
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1400000, 2);
        int l0 = dataBuf.getInt();
        int l1 = dataBuf.getInt();
        int l = l0 * l1;
        byte[][] d = new byte[l0][l1];
        if (l > 0) {
            Marshaller.unmarshalMaps(conversation, mapBuf, 0x7000000, l);
            for (int i0 = 0; i0 < l0; ++i0) {
                dataBuf.get(d[i0]);
            }
        }
        return d;
    }

    protected short unmarshalShort(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        return dataBuf.getShort();
    }

    protected short[] unmarshalShort1dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        if (dataBuf.getShort() == 0) {
            return new short[0];
        }
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1400000, 1);
        int l = dataBuf.getInt();
        short[] d = new short[l];
        if (l > 0) {
            Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, l);
            for (int i = 0; i < l; ++i) {
                d[i] = dataBuf.getShort();
            }
        }
        return d;
    }

    protected short[][] unmarshalShort2dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        if (dataBuf.getShort() == 0) {
            return new short[0][0];
        }
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1400000, 2);
        int l0 = dataBuf.getInt();
        int l1 = dataBuf.getInt();
        int l = l0 * l1;
        short[][] d = new short[l0][l1];
        if (l > 0) {
            Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, l);
            for (int i0 = 0; i0 < l0; ++i0) {
                for (int i1 = 0; i1 < l1; ++i1) {
                    d[i0][i1] = dataBuf.getShort();
                }
            }
        }
        return d;
    }

    protected String unmarshalStringNT(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        int repFactor = Marshaller.unmarshalMaps(conversation, mapBuf, 0x6400000, -1);
        int l = repFactor - 1;
        String str = this.decodeString(conversation, dataBuf, l);
        dataBuf.get();
        return str;
    }

    protected String[] unmarshalStringNT1dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        if (dataBuf.getShort() == 0) {
            return new String[0];
        }
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1400000, 1);
        int l = dataBuf.getInt();
        String[] d = new String[l];
        for (int i = 0; i < l; ++i) {
            d[i] = this.unmarshalStringNT(conversation, mapBuf, dataBuf);
        }
        return d;
    }

    protected String[][] unmarshalStringNT2dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        if (dataBuf.getShort() == 0) {
            return new String[0][0];
        }
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1400000, 2);
        int l0 = dataBuf.getInt();
        int l1 = dataBuf.getInt();
        String[][] d = new String[l0][l1];
        for (int i0 = 0; i0 < l0; ++i0) {
            for (int i1 = 0; i1 < l1; ++i1) {
                d[i0][i1] = this.unmarshalStringNT(conversation, mapBuf, dataBuf);
            }
        }
        return d;
    }

    protected UUID unmarshalUUID(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        String s = this.unmarshalStringNT(conversation, mapBuf, dataBuf);
        return UUIDConverter.stringToUUID(s);
    }

    protected UUID[] unmarshalUUID1dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        if (dataBuf.getShort() == 0) {
            return new UUID[0];
        }
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1400000, 1);
        int l = dataBuf.getInt();
        UUID[] d = new UUID[l];
        for (int i = 0; i < l; ++i) {
            d[i] = this.unmarshalUUID(conversation, mapBuf, dataBuf);
        }
        return d;
    }

    protected UUID[][] unmarshalUUID2dArray(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x2000000, 1);
        if (dataBuf.getShort() == 0) {
            return new UUID[0][0];
        }
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x1400000, 2);
        int l0 = dataBuf.getInt();
        int l1 = dataBuf.getInt();
        UUID[][] d = new UUID[l0][l1];
        for (int i0 = 0; i0 < l0; ++i0) {
            for (int i1 = 0; i1 < l1; ++i1) {
                d[i0][i1] = this.unmarshalUUID(conversation, mapBuf, dataBuf);
            }
        }
        return d;
    }

    protected String unmarshalWZXOctet1dArrayNTToString(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        int l = Marshaller.unmarshalMaps(conversation, mapBuf, 0x7000000, -1);
        String d = this.decodeString(conversation, dataBuf, l - 1);
        dataBuf.get();
        return d;
    }

    protected int unmarshalWZXUnsignedInt(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf) {
        Marshaller.unmarshalMaps(conversation, mapBuf, 0x3400000, 1);
        return dataBuf.getInt();
    }

    protected static int unmarshalMaps(Conversation conversation, ByteBuffer mapBuf, int wzxType, int rf) {
        int wzxMap = mapBuf.getInt();
        if ((wzxMap & 0x7FF80000) != wzxType) {
            Locale locale = conversation.getLocale();
            String messageIndex = "Engine.022.ex.txt";
            String message = RB.getStringResource(messageIndex, locale);
            throw new MARSHAL(message);
        }
        boolean xtnd = (wzxMap & Integer.MIN_VALUE) != 0;
        int repFactor = 0;
        if (!xtnd) {
            repFactor = wzxMap & 0x7FFFF;
        } else {
            do {
                wzxMap = mapBuf.getInt();
                repFactor += wzxMap & 0x7FFFF;
            } while (xtnd = (wzxMap & Integer.MIN_VALUE) != 0);
        }
        if (rf >= 0 && repFactor != rf) {
            Locale locale = conversation.getLocale();
            String messageIndex = "Engine.023.ex.txt";
            String message = RB.getStringResource(messageIndex, locale);
            throw new MARSHAL(message);
        }
        return repFactor;
    }

    protected int unmarshalRC(Conversation conversation, InboundPacket reply) {
        ByteBuffer mapBuf = reply.getMapBuf();
        ByteBuffer dataBuf = reply.getDataBuf();
        return this.unmarshalWZXUnsignedInt(conversation, mapBuf, dataBuf);
    }

    private static boolean unmarshalBooleanData(ByteBuffer dataBuf) {
        return dataBuf.get() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int objectToObjectID(Conversation conversation, Object obj) {
        Map localMap;
        if (obj == null) {
            return 0;
        }
        Delegate del = ((ObjectImpl)obj)._get_delegate();
        if (del instanceof DelegateImpl) {
            DelegateImpl delegate = (DelegateImpl)del;
            int objectID = delegate.getObjectID();
            return objectID | Integer.MIN_VALUE;
        }
        DelegateLocal delegate = (DelegateLocal)del;
        Map map = localMap = conversation.getLocalMap();
        synchronized (map) {
            Set entrySet = localMap.entrySet();
            for (Map.Entry entry : entrySet) {
                DelegateLocal entryDel = (DelegateLocal)((java.lang.Object)entry.getValue());
                if (!((java.lang.Object)((java.lang.Object)delegate)).equals((java.lang.Object)entryDel)) continue;
                Integer ID = (Integer)entry.getKey();
                return ID;
            }
            int objectID = conversation.getObjectID();
            Integer ID = new Integer(objectID);
            localMap.put(ID, delegate);
            return objectID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectImpl objectIDToObject(Conversation conversation, int objectID) {
        if ((objectID & Integer.MIN_VALUE) == 0) {
            Integer key = new Integer(objectID);
            Map remoteMap = conversation.getRemoteMap();
            DelegateImpl delegate = null;
            Map map = remoteMap;
            synchronized (map) {
                WeakReference<DelegateImpl> ref = (WeakReference<DelegateImpl>)remoteMap.get(key);
                DelegateImpl delegateImpl = delegate = ref == null ? null : (DelegateImpl)((java.lang.Object)ref.get());
                if (delegate == null) {
                    delegate = new DelegateImpl(conversation, key);
                    ref = new WeakReference<DelegateImpl>(delegate);
                    remoteMap.put(key, ref);
                }
            }
            GenericObject object = new GenericObject();
            object._set_delegate(delegate);
            return object;
        }
        Integer key = new Integer(objectID &= Integer.MAX_VALUE);
        Map localMap = conversation.getLocalMap();
        DelegateLocal delegate = null;
        Map object = localMap;
        synchronized (object) {
            delegate = (DelegateLocal)((java.lang.Object)localMap.get(key));
        }
        if (delegate == null) {
            throw new OBJECT_NOT_EXIST();
        }
        ObjectImpl reference = delegate.getReference();
        return reference;
    }

    private static short iomTypeToAnyType(int iomType) {
        switch (iomType) {
            case 33: {
                return 0;
            }
            case 0: {
                return 1;
            }
            case 27: {
                return 2;
            }
            case 15: {
                return 3;
            }
            case 21: {
                return 4;
            }
            case 12: {
                return 5;
            }
            case 24: {
                return 6;
            }
            case 36: {
                return 9;
            }
            case 9: {
                return 8;
            }
            case 39: {
                return 13;
            }
            case 3: {
                return 10;
            }
            case 6: {
                return 7;
            }
            case 18: {
                return 11;
            }
            case 30: {
                return 12;
            }
            case 34: 
            case 35: {
                return Short.MIN_VALUE;
            }
            case 1: 
            case 2: {
                return -32767;
            }
            case 28: 
            case 29: {
                return -32766;
            }
            case 16: 
            case 17: {
                return -32765;
            }
            case 22: 
            case 23: {
                return -32764;
            }
            case 13: 
            case 14: {
                return -32763;
            }
            case 37: 
            case 38: {
                return -32759;
            }
            case 10: 
            case 11: {
                return -32760;
            }
            case 4: 
            case 5: {
                return -32758;
            }
            case 7: 
            case 8: {
                return -32761;
            }
            case 19: 
            case 20: {
                return -32757;
            }
            case 31: 
            case 32: {
                return -32756;
            }
        }
        throw new NO_IMPLEMENT();
    }

    private static int anyTypeToIOMType(short anyType, int dim) {
        int iomType = 0;
        switch (anyType & Short.MAX_VALUE) {
            case 0: {
                iomType = 33;
                break;
            }
            case 1: {
                iomType = 0;
                break;
            }
            case 2: {
                iomType = 27;
                break;
            }
            case 3: {
                iomType = 15;
                break;
            }
            case 4: {
                iomType = 21;
                break;
            }
            case 5: {
                iomType = 12;
                break;
            }
            case 6: {
                iomType = 24;
                break;
            }
            case 7: {
                iomType = 6;
                break;
            }
            case 8: {
                iomType = 9;
                break;
            }
            case 9: {
                iomType = 36;
                break;
            }
            case 13: {
                iomType = 39;
                break;
            }
            case 10: {
                iomType = 3;
                break;
            }
            case 11: {
                iomType = 18;
                break;
            }
            case 12: {
                iomType = 30;
                break;
            }
            default: {
                throw new NO_IMPLEMENT();
            }
        }
        return iomType += dim;
    }

    private void extractAndMarshal(Conversation conversation, Any a, int iomTC, ByteBuffer mapBuf, ByteBuffer dataBuf, Iterator stringItr) {
        switch (iomTC) {
            case 33: {
                Any aa = a.extract_any();
                this.marshalAny(conversation, aa, mapBuf, dataBuf, stringItr);
                break;
            }
            case 34: {
                Any[] aa = AnySeqHelper.extract(a);
                this.marshalAny1dArray(conversation, aa, mapBuf, dataBuf, stringItr);
                break;
            }
            case 35: {
                Any[][] aa = VariableArray2dOfAnyHelper.extract(a);
                this.marshalAny2dArray(conversation, aa, mapBuf, dataBuf, stringItr);
                break;
            }
            case 0: {
                boolean b = a.extract_boolean();
                this.marshalBoolean(conversation, b, mapBuf, dataBuf);
                break;
            }
            case 1: {
                boolean[] b = BooleanSeqHelper.extract(a);
                this.marshalBoolean1dArray(conversation, b, mapBuf, dataBuf);
                break;
            }
            case 2: {
                boolean[][] b = VariableArray2dOfBooleanHelper.extract(a);
                this.marshalBoolean2dArray(conversation, b, mapBuf, dataBuf);
                break;
            }
            case 27: {
                long d = DateTimeHelper.extract(a);
                this.marshalDatetime(conversation, d, mapBuf, dataBuf);
                break;
            }
            case 28: {
                long[] d = DateTimeSeqHelper.extract(a);
                this.marshalDatetime1dArray(conversation, d, mapBuf, dataBuf);
                break;
            }
            case 29: {
                long[][] d = VariableArray2dOfDateTimeHelper.extract(a);
                this.marshalDatetime2dArray(conversation, d, mapBuf, dataBuf);
                break;
            }
            case 15: {
                double d = a.extract_double();
                this.marshalDouble(conversation, d, mapBuf, dataBuf);
                break;
            }
            case 16: {
                double[] d = DoubleSeqHelper.extract(a);
                this.marshalDouble1dArray(conversation, d, mapBuf, dataBuf);
                break;
            }
            case 17: {
                double[][] d = VariableArray2dOfDoubleHelper.extract(a);
                this.marshalDouble2dArray(conversation, d, mapBuf, dataBuf);
                break;
            }
            case 12: {
                float f = a.extract_float();
                this.marshalFloat(conversation, f, mapBuf, dataBuf);
                break;
            }
            case 13: {
                float[] f = FloatSeqHelper.extract(a);
                this.marshalFloat1dArray(conversation, f, mapBuf, dataBuf);
                break;
            }
            case 14: {
                float[][] f = VariableArray2dOfFloatHelper.extract(a);
                this.marshalFloat2Array(conversation, f, mapBuf, dataBuf);
                break;
            }
            case 36: {
                long i = a.extract_longlong();
                this.marshalInt64(conversation, i, mapBuf, dataBuf);
                break;
            }
            case 37: {
                long[] i = LongLongSeqHelper.extract(a);
                this.marshalInt641dArray(conversation, i, mapBuf, dataBuf);
                break;
            }
            case 38: {
                long[][] i = VariableArray2dOfLongLongHelper.extract(a);
                this.marshalInt642dArray(conversation, i, mapBuf, dataBuf);
                break;
            }
            case 9: {
                int l = a.extract_long();
                this.marshalLong(conversation, l, mapBuf, dataBuf);
                break;
            }
            case 10: {
                int[] l = LongSeqHelper.extract(a);
                this.marshalLong1dArray(conversation, l, mapBuf, dataBuf);
                break;
            }
            case 11: {
                int[][] l = VariableArray2dOfLongHelper.extract(a);
                this.marshalLong2dArray(conversation, l, mapBuf, dataBuf);
                break;
            }
            case 39: {
                break;
            }
            case 24: {
                Object obj = a.extract_Object();
                this.marshalObject(conversation, obj, mapBuf, dataBuf);
                break;
            }
            case 3: {
                byte o = a.extract_octet();
                this.marshalOctet(conversation, o, mapBuf, dataBuf);
                break;
            }
            case 4: {
                byte[] o = OctetSeqHelper.extract(a);
                this.marshalOctet1dArray(conversation, o, mapBuf, dataBuf);
                break;
            }
            case 5: {
                byte[][] o = VariableArray2dOfOctetHelper.extract(a);
                this.marshalOctet2dArray(conversation, o, mapBuf, dataBuf);
                break;
            }
            case 6: {
                short s = a.extract_short();
                this.marshalShort(conversation, s, mapBuf, dataBuf);
                break;
            }
            case 7: {
                short[] s = ShortSeqHelper.extract(a);
                this.marshalShort1dArray(conversation, s, mapBuf, dataBuf);
                break;
            }
            case 8: {
                short[][] s = VariableArray2dOfShortHelper.extract(a);
                this.marshalShort2dArray(conversation, s, mapBuf, dataBuf);
                break;
            }
            case 18: {
                String s = a.extract_string();
                this.marshalStringNT(conversation, s, mapBuf, dataBuf, stringItr);
                break;
            }
            case 19: {
                String[] s = StringSeqHelper.extract(a);
                this.marshalStringNT1dArray(conversation, s, mapBuf, dataBuf, stringItr);
                break;
            }
            case 20: {
                String[][] s = VariableArray2dOfStringHelper.extract(a);
                this.marshalStringNT2dArray(conversation, s, mapBuf, dataBuf, stringItr);
                break;
            }
            case 30: {
                UUID u = UUIDHelper.extract(a);
                this.marshalUUID(conversation, u, mapBuf, dataBuf, stringItr);
                break;
            }
            case 31: {
                UUID[] u = UUIDSeqHelper.extract(a);
                this.marshalUUID1dArray(conversation, u, mapBuf, dataBuf, stringItr);
                break;
            }
            case 32: {
                UUID[][] u = VariableArray2dOfUUIDHelper.extract(a);
                this.marshalUUID2dArray(conversation, u, mapBuf, dataBuf, stringItr);
                break;
            }
            default: {
                throw new INTERNAL();
            }
        }
    }

    private void extractAndCalculate(Conversation conversation, Any a, IntHolder mapCountHolder, IntHolder dataSizeHolder, List stringList) {
        TypeCode orbTC = a.type();
        int iomTC = TypeCodeImpl.typeCodeToIOMType(orbTC);
        switch (iomTC) {
            case 33: {
                Any d = a.extract_any();
                this.calculateAnySize(conversation, d, mapCountHolder, dataSizeHolder, stringList);
                break;
            }
            case 34: {
                Any[] d = AnySeqHelper.extract(a);
                this.calculateAny1dArraySize(conversation, d, mapCountHolder, dataSizeHolder, stringList);
                break;
            }
            case 35: {
                Any[][] d = VariableArray2dOfAnyHelper.extract(a);
                this.calculateAny2dArraySize(conversation, d, mapCountHolder, dataSizeHolder, stringList);
                break;
            }
            case 0: {
                this.calculateBooleanSize(conversation, mapCountHolder, dataSizeHolder);
                break;
            }
            case 1: {
                boolean[] d = BooleanSeqHelper.extract(a);
                this.calculateBoolean1dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 2: {
                boolean[][] d = VariableArray2dOfBooleanHelper.extract(a);
                this.calculateBoolean2dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 27: {
                this.calculateDatetimeSize(conversation, mapCountHolder, dataSizeHolder);
                break;
            }
            case 28: {
                long[] d = DateTimeSeqHelper.extract(a);
                this.calculateDatetime1dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 29: {
                long[][] d = VariableArray2dOfDateTimeHelper.extract(a);
                this.calculateDatetime2dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 15: {
                this.calculateDoubleSize(conversation, mapCountHolder, dataSizeHolder);
                break;
            }
            case 16: {
                double[] d = DoubleSeqHelper.extract(a);
                this.calculateDouble1dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 17: {
                double[][] d = VariableArray2dOfDoubleHelper.extract(a);
                this.calculateDouble2dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 12: {
                this.calculateFloatSize(conversation, mapCountHolder, dataSizeHolder);
                break;
            }
            case 13: {
                float[] d = FloatSeqHelper.extract(a);
                this.calculateFloat1dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 14: {
                float[][] d = VariableArray2dOfFloatHelper.extract(a);
                this.calculateFloat2dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 36: {
                this.calculateInt64Size(conversation, mapCountHolder, dataSizeHolder);
                break;
            }
            case 37: {
                long[] d = LongLongSeqHelper.extract(a);
                this.calculateInt641dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 38: {
                long[][] d = VariableArray2dOfLongLongHelper.extract(a);
                this.calculateInt642dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 9: {
                this.calculateLongSize(conversation, mapCountHolder, dataSizeHolder);
                break;
            }
            case 10: {
                int[] d = LongSeqHelper.extract(a);
                this.calculateLong1dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 11: {
                int[][] d = VariableArray2dOfLongHelper.extract(a);
                this.calculateLong2dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 39: {
                break;
            }
            case 24: {
                this.calculateObjectSize(conversation, mapCountHolder, dataSizeHolder);
                break;
            }
            case 3: {
                this.calculateOctetSize(conversation, mapCountHolder, dataSizeHolder);
                break;
            }
            case 4: {
                byte[] d = OctetSeqHelper.extract(a);
                this.calculateOctet1dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 5: {
                byte[][] d = VariableArray2dOfOctetHelper.extract(a);
                this.calculateOctet2dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 6: {
                this.calculateShortSize(conversation, mapCountHolder, dataSizeHolder);
                break;
            }
            case 7: {
                short[] d = ShortSeqHelper.extract(a);
                this.calculateShort1dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 8: {
                short[][] d = VariableArray2dOfShortHelper.extract(a);
                this.calculateShort2dArraySize(conversation, d, mapCountHolder, dataSizeHolder);
                break;
            }
            case 18: {
                String d = a.extract_string();
                this.calculateStringNTSize(conversation, d, mapCountHolder, dataSizeHolder, stringList);
                break;
            }
            case 19: {
                String[] d = StringSeqHelper.extract(a);
                this.calculateStringNT1dArraySize(conversation, d, mapCountHolder, dataSizeHolder, stringList);
                break;
            }
            case 20: {
                String[][] d = VariableArray2dOfStringHelper.extract(a);
                this.calculateStringNT2dArraySize(conversation, d, mapCountHolder, dataSizeHolder, stringList);
                break;
            }
            case 30: {
                UUID d = UUIDHelper.extract(a);
                this.calculateUUIDSize(conversation, d, mapCountHolder, dataSizeHolder, stringList);
                break;
            }
            case 31: {
                UUID[] d = UUIDSeqHelper.extract(a);
                this.calculateUUID1dArraySize(conversation, d, mapCountHolder, dataSizeHolder, stringList);
                break;
            }
            case 32: {
                UUID[][] d = VariableArray2dOfUUIDHelper.extract(a);
                this.calculateUUID2dArraySize(conversation, d, mapCountHolder, dataSizeHolder, stringList);
                break;
            }
            default: {
                throw new INTERNAL();
            }
        }
    }

    protected byte[] stringToBytes(Conversation conversation, String str) {
        ByteBuffer bBuf = this.stringToBuffer(conversation, str);
        int size = bBuf.remaining();
        byte[] ba = new byte[size];
        bBuf.get(ba);
        return ba;
    }

    protected ByteBuffer stringToBuffer(Conversation conversation, String str) {
        if (str == null) {
            Locale locale = conversation.getLocale();
            String msgIndex = "Marshaller.000.ex.txt";
            String msg = RB.getStringResource("Marshaller.000.ex.txt", locale);
            throw new NullPointerException(msg);
        }
        int l = str.length();
        CharsetEncoder encoder = conversation.getEncoder();
        double f = encoder.maxBytesPerChar();
        double m = f * (double)l;
        int bl = m <= 2.147483647E9 ? (int)Math.ceil(m) : Integer.MAX_VALUE;
        BufferManager bufferManager = conversation.getBufferManager();
        ByteBuffer bBuf = bufferManager.allocate(bl);
        this.encodeString(conversation, str, bBuf);
        bBuf.flip();
        return bBuf;
    }

    protected String bytesToString(Conversation conversation, byte[] ba) {
        String str = this.bytesToString(conversation, ba, 0, ba.length);
        return str;
    }

    protected String bytesToString(Conversation conversation, byte[] ba, int index, int length) {
        ByteBuffer bBuf = ByteBuffer.wrap(ba, index, length);
        String str = this.decodeString(conversation, bBuf, length);
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodeString(Conversation conversation, String str, ByteBuffer bBuf) {
        CharsetEncoder encoder = conversation.getEncoder();
        CharBuffer cBuf = CharBuffer.wrap(str);
        CharsetEncoder charsetEncoder = encoder;
        synchronized (charsetEncoder) {
            encoder.reset();
            try {
                CoderResult cr = encoder.encode(cBuf, bBuf, true);
                if (!cr.isUnderflow()) {
                    cr.throwException();
                }
                if (!(cr = encoder.flush(bBuf)).isUnderflow()) {
                    cr.throwException();
                }
            }
            catch (CharacterCodingException cce) {
                INTERNAL internal = new INTERNAL();
                internal.initCause((Throwable)cce);
                throw internal;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String decodeString(Conversation conversation, ByteBuffer dataBuf, int dataLen) {
        CharsetDecoder decoder = conversation.getDecoder();
        double f = decoder.maxCharsPerByte();
        double m = f * (double)dataLen;
        int bl = m <= 2.147483647E9 ? (int)Math.ceil(m) : Integer.MAX_VALUE;
        CharBuffer strBuf = CharBuffer.allocate(bl);
        int oldLimit = dataBuf.limit();
        int oldPos = dataBuf.position();
        dataBuf.limit(oldPos + dataLen);
        CharsetDecoder charsetDecoder = decoder;
        synchronized (charsetDecoder) {
            decoder.reset();
            try {
                CoderResult cr = decoder.decode(dataBuf, strBuf, true);
                if (!cr.isUnderflow()) {
                    cr.throwException();
                }
                if (!(cr = decoder.flush(strBuf)).isUnderflow()) {
                    cr.throwException();
                }
            }
            catch (CharacterCodingException cce) {
                INTERNAL internal = new INTERNAL();
                internal.initCause((Throwable)cce);
                throw internal;
            }
        }
        strBuf.flip();
        String str = strBuf.toString();
        dataBuf.limit(oldLimit);
        return str;
    }

    protected void printParameters(Conversation conversation, ByteBuffer mapBuf, ByteBuffer dataBuf, PrintWriter pw) {
        while (mapBuf.remaining() > 0) {
            boolean unsigned;
            pw.println();
            int pos = mapBuf.position();
            int wzxMap = mapBuf.getInt(pos);
            int wzxType = wzxMap & 0x7F000000;
            String wzxTypeString = null;
            switch (wzxType) {
                case 0x1000000: {
                    wzxTypeString = "WZX_LONG  ";
                    break;
                }
                case 0x2000000: {
                    wzxTypeString = "WZX_SHORT ";
                    break;
                }
                case 0x3000000: {
                    wzxTypeString = "WZX_INT   ";
                    break;
                }
                case 0x4000000: {
                    wzxTypeString = "WZX_FLOAT ";
                    break;
                }
                case 0x5000000: {
                    wzxTypeString = "WZX_DOUBLE";
                    break;
                }
                case 0x6000000: {
                    wzxTypeString = "WZX_CHAR  ";
                    break;
                }
                case 0x7000000: {
                    wzxTypeString = "WZX_CHAR_B";
                    break;
                }
                case 0x19000000: {
                    wzxTypeString = "WZX_INT64 ";
                    break;
                }
                default: {
                    wzxTypeString = "UNKNOWN   ";
                }
            }
            pw.print(wzxTypeString);
            int wzxAttr = wzxMap & 0xF80000;
            boolean bl = unsigned = (wzxAttr & 0x400000) != 0;
            if (unsigned) {
                pw.print(" (uns)");
            } else {
                pw.print("      ");
            }
            pw.print(":");
            int repFactor = Marshaller.unmarshalMaps(conversation, mapBuf, wzxType | wzxAttr, -1);
            switch (wzxType) {
                case 0x1000000: 
                case 0x3000000: {
                    int i;
                    for (i = 0; i < repFactor; ++i) {
                        long l = dataBuf.getInt();
                        if (i >= 10) continue;
                        if (unsigned && l < 0L) {
                            l += 0x100000000L;
                        }
                        pw.print(" ");
                        pw.print(l);
                    }
                    break;
                }
                case 0x2000000: {
                    int i;
                    for (i = 0; i < repFactor; ++i) {
                        long l = dataBuf.getShort();
                        if (i >= 10) continue;
                        if (unsigned && l < 0L) {
                            l += 65536L;
                        }
                        pw.print(" ");
                        pw.print(l);
                    }
                    break;
                }
                case 0x4000000: {
                    int i;
                    for (i = 0; i < repFactor; ++i) {
                        float l = dataBuf.getFloat();
                        if (i >= 10) continue;
                        pw.print(" ");
                        pw.print(l);
                    }
                    break;
                }
                case 0x5000000: {
                    int i;
                    for (i = 0; i < repFactor; ++i) {
                        double l = dataBuf.getDouble();
                        if (i >= 10) continue;
                        pw.print(" ");
                        pw.print(l);
                    }
                    break;
                }
                case 0x6000000: {
                    int len = repFactor - 1;
                    String s = this.decodeString(conversation, dataBuf, len);
                    dataBuf.get();
                    int sl = s.length();
                    if (sl > 64) {
                        s = s.substring(0, 64);
                    }
                    pw.print(" ");
                    pw.print(s);
                    if (sl <= 64) break;
                    pw.print(" (");
                    pw.print(sl);
                    pw.print(" chars)");
                    break;
                }
                case 0x7000000: {
                    int i;
                    for (i = 0; i < repFactor; ++i) {
                        long l = dataBuf.get();
                        if (i >= 10) continue;
                        if (unsigned && l < 0L) {
                            l += 256L;
                        }
                        pw.print(" ");
                        pw.print(l);
                    }
                    break;
                }
                case 0x19000000: {
                    int i;
                    for (i = 0; i < repFactor; ++i) {
                        long l = dataBuf.getLong();
                        if (i >= 10) continue;
                        pw.print(" ");
                        pw.print(l);
                    }
                    break;
                }
            }
            if (wzxType == 0x6000000 || repFactor <= 10) continue;
            pw.print(" (");
            pw.print(repFactor);
            pw.print(" elements)");
        }
    }

    protected static boolean isWZXUnsignedInt(int map) {
        return (map & 0x7F000000) == 0x3000000 && (map & 0x400000) != 0;
    }
}

