/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb.brg;

import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.AnyImpl;
import com.sas.iom.orb.brg.BufferManager;
import com.sas.iom.orb.brg.InboundPacket;
import com.sas.iom.orb.brg.Packet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

@SASScope
public final class OutboundPacket
extends Packet {
    protected static final Integer zero = new Integer(0);
    private AnyImpl[] _parameterArray;
    private boolean _sent;
    private InboundPacket _reply;
    private IOException _fatalException;
    private int _readCount;
    private Integer _rc;
    private List _encodedStringLst;
    private ByteBuffer _marshalledPacket;
    private ByteBuffer _encryptedPacket;
    private boolean _interrupted;

    protected OutboundPacket() {
    }

    @Override
    public Object clone() {
        ByteBuffer oldOutput;
        OutboundPacket cl = (OutboundPacket)super.clone();
        AnyImpl[] oldParms = cl.getParameterArray();
        if (oldParms != null) {
            AnyImpl[] newParms = new AnyImpl[oldParms.length];
            for (int i = 0; i < oldParms.length; ++i) {
                AnyImpl oldParm = oldParms[i];
                newParms[i] = (AnyImpl)oldParm.clone();
            }
            cl.setParameterArray(newParms);
        }
        if ((oldOutput = cl.getMarshalledPacket()) != null) {
            ByteBuffer newOutput = BufferManager.asReadOnlyBuffer(oldOutput);
            cl.setMarshalledPacket(newOutput);
        }
        return cl;
    }

    @Override
    protected boolean isInbound() {
        return false;
    }

    protected void setParameterArray(AnyImpl[] a) {
        this._parameterArray = a;
    }

    protected AnyImpl[] getParameterArray() {
        return this._parameterArray;
    }

    protected boolean isSent() {
        return this._sent;
    }

    protected void setSent(boolean b) {
        this._sent = b;
    }

    protected InboundPacket getReply() {
        return this._reply;
    }

    protected void setReply(InboundPacket packet) {
        this._reply = packet;
    }

    protected IOException getFatalException() {
        return this._fatalException;
    }

    protected void setFatalException(IOException exception) {
        this._fatalException = exception;
    }

    protected int getReadCount() {
        return this._readCount;
    }

    protected void addRead() {
        ++this._readCount;
    }

    protected void removeRead() {
        --this._readCount;
    }

    protected Integer getRC() {
        return this._rc;
    }

    protected void setRC(Integer rc) {
        this._rc = rc;
    }

    protected boolean isReply() {
        return this._rc != null;
    }

    protected List getEncodedStringLst() {
        return this._encodedStringLst;
    }

    protected void setEncodedStringLst(List encodedStringLst) {
        this._encodedStringLst = encodedStringLst;
    }

    protected ByteBuffer getMarshalledPacket() {
        return this._marshalledPacket;
    }

    protected void setMarshalledPacket(ByteBuffer marshalledPacket) {
        OutboundPacket.checkForReadOnlyBuffer(marshalledPacket);
        this._marshalledPacket = marshalledPacket;
    }

    protected ByteBuffer getEncryptedPacket() {
        return this._encryptedPacket;
    }

    protected void setEncryptedPacket(ByteBuffer encryptedPacket) {
        OutboundPacket.checkForReadOnlyBuffer(encryptedPacket);
        this._encryptedPacket = encryptedPacket;
    }

    protected ByteBuffer getOutputBuffer() {
        return this._encryptedPacket != null ? this._encryptedPacket : this._marshalledPacket;
    }

    protected void setInterrupted(boolean interrupted) {
        this._interrupted = interrupted;
    }

    protected boolean isInterrupted() {
        return this._interrupted;
    }
}

