/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rio;

import com.sas.codepolicy.SASScope;
import com.sas.rio.MVAResultSet;
import com.sas.rio.MVASQLException;
import com.sas.rio.MVAStatement;
import com.sas.rio.MessageCode;
import com.sas.rio.MissingValue;
import com.sas.rio.RIOUtil;
import com.sas.sql.AnnotatedResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

@SASScope(value="ALL")
public class MVAAnnotatedResultSet
extends MVAResultSet
implements AnnotatedResultSet {
    private boolean _annotationNull = false;
    private ArrayList<String> _annotationNulls = new ArrayList();
    private ArrayList<Map<String, String>> _columnCharAttrs = new ArrayList();
    private ArrayList<Map<String, Double>> _columnNumAttrs = new ArrayList();
    private ArrayList<Map<String, Character>> _columnMissingAttrs = new ArrayList();
    private ArrayList<Boolean> _retrievedAllColumnAttrs;
    private Map<String, String> _dataSetCharAttrs = new HashMap<String, String>();
    private Map<String, Double> _dataSetNumAttrs = new HashMap<String, Double>();
    private Map<String, Character> _dataSetMissingAttrs = new HashMap<String, Character>();
    private Boolean _retrievedAllDataSetAttrs = false;
    private RIOUtil _rioUtil;
    private long _numAttrs;
    private boolean _init = false;
    private boolean _noAttributes = false;
    private int _segmentLength = 256;
    private boolean _readOnly = true;
    private static final Logger logger = Logger.getLogger(MVAAnnotatedResultSet.class);
    private static final String className = MVAAnnotatedResultSet.class.getSimpleName();
    private static final String initLayout = className + "(), number of attributes: %d";
    private static final String clearColAnnotatationLayout = className + "::clearColumnAnnotation(), The name \"%s\" was not found on column #%d and was not deleted.";
    private static final String clearRSAnnotatationLayout = className + "::clearResultSetAnnotation(), The name \"%s\" was not found and was not deleted.";

    public MVAAnnotatedResultSet(MVAStatement stmt, String libref, String tableName, String[] password, String options, int bindKey, int resultSetConcurrency, String segmentLength) throws SQLException {
        super(stmt, libref, tableName, password, options, bindKey);
        this._readOnly = resultSetConcurrency == 1007;
        this._retrievedAllColumnAttrs = new ArrayList(this.m_columnCount);
        this._segmentLength = Integer.parseInt(segmentLength);
        for (int i = 0; i < this.m_columnCount; ++i) {
            this._columnCharAttrs.add(new HashMap());
            this._columnNumAttrs.add(new HashMap());
            this._columnMissingAttrs.add(new HashMap());
            this._retrievedAllColumnAttrs.add(false);
        }
        this._rioUtil = stmt.getRioUtil();
    }

    private void init() throws SQLException {
        int iFlags = 0;
        if (this._readOnly) {
            iFlags = 6;
        }
        this._numAttrs = this._rioUtil.openExtendedAttributes(iFlags, this._segmentLength);
        if (this._numAttrs == -1L) {
            this._noAttributes = true;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format(initLayout, this._numAttrs));
        }
        this._init = true;
    }

    public synchronized void clearColumnAnnotations(int columnIndex) throws SQLException {
        this.throwAnnotationExceptions(columnIndex, true);
        if (this._noAttributes) {
            return;
        }
        if (!this._retrievedAllColumnAttrs.get(columnIndex - 1).booleanValue()) {
            this.getRioAttributes(columnIndex, this.m_rowCache.getColumns()[columnIndex - 1].getName(), 4);
            this._retrievedAllColumnAttrs.set(columnIndex - 1, true);
        }
        ArrayList<String> attrList = new ArrayList<String>();
        for (String key : this._columnCharAttrs.get(columnIndex - 1).keySet()) {
            attrList.add(key);
        }
        for (String key : this._columnNumAttrs.get(columnIndex - 1).keySet()) {
            attrList.add(key);
        }
        for (String key : this._columnMissingAttrs.get(columnIndex - 1).keySet()) {
            attrList.add(key);
        }
        this._rioUtil.dropAttributes(4, this.m_rowCache.getColumns()[columnIndex - 1].getName(), attrList);
        this._columnCharAttrs.get(columnIndex - 1).clear();
        this._columnNumAttrs.get(columnIndex - 1).clear();
        this._columnMissingAttrs.get(columnIndex - 1).clear();
        this._retrievedAllColumnAttrs.set(columnIndex - 1, false);
    }

    public synchronized void clearColumnAnnotations(String columnName) throws SQLException {
        this.clearColumnAnnotations(this.findColumn(columnName));
    }

    public synchronized void clearResultSetAnnotations() throws SQLException {
        this.throwAnnotationExceptions(true);
        if (this._noAttributes) {
            return;
        }
        if (!this._retrievedAllDataSetAttrs.booleanValue()) {
            this.getRioAttributes(2);
            this._retrievedAllDataSetAttrs = true;
        }
        ArrayList<String> attrList = new ArrayList<String>();
        for (String key : this._dataSetCharAttrs.keySet()) {
            attrList.add(key);
        }
        for (String key : this._dataSetNumAttrs.keySet()) {
            attrList.add(key);
        }
        for (String key : this._dataSetMissingAttrs.keySet()) {
            attrList.add(key);
        }
        this._rioUtil.dropAttributes(2, "", attrList);
        this._dataSetCharAttrs.clear();
        this._dataSetNumAttrs.clear();
        this._dataSetMissingAttrs.clear();
        this._retrievedAllDataSetAttrs = false;
    }

    public synchronized String getStringColumnAnnotation(int columnIndex, String annotationName) throws SQLException {
        this.throwAnnotationExceptions(columnIndex, false);
        if (this._noAttributes) {
            return "";
        }
        if (!this._retrievedAllColumnAttrs.get(columnIndex - 1).booleanValue()) {
            this.getRioAttributes(columnIndex, this.m_rowCache.getColumns()[columnIndex - 1].getName(), 4);
            this._retrievedAllColumnAttrs.set(columnIndex - 1, true);
        }
        this._annotationNull = false;
        if (this._columnCharAttrs.get(columnIndex - 1).containsKey(annotationName)) {
            return this._columnCharAttrs.get(columnIndex - 1).get(annotationName);
        }
        if (this._columnMissingAttrs.get(columnIndex - 1).containsKey(annotationName)) {
            this._annotationNull = true;
            return null;
        }
        if (this._columnNumAttrs.get(columnIndex - 1).containsKey(annotationName)) {
            return Double.toString(this._columnNumAttrs.get(columnIndex - 1).get(annotationName));
        }
        return "";
    }

    public synchronized String getStringColumnAnnotation(String columnName, String annotationName) throws SQLException {
        return this.getStringColumnAnnotation(this.findColumn(columnName), annotationName);
    }

    public synchronized Map<String, Object> getColumnAnnotations(int columnIndex) throws SQLException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        this.throwAnnotationExceptions(columnIndex, false);
        if (this._noAttributes) {
            return attrs;
        }
        if (!this._retrievedAllColumnAttrs.get(columnIndex - 1).booleanValue()) {
            this.getRioAttributes(columnIndex, this.m_rowCache.getColumns()[columnIndex - 1].getName(), 4);
            this._retrievedAllColumnAttrs.set(columnIndex - 1, true);
        }
        attrs.putAll(this._columnCharAttrs.get(columnIndex - 1));
        attrs.putAll(this._columnNumAttrs.get(columnIndex - 1));
        attrs.putAll(this._columnMissingAttrs.get(columnIndex - 1));
        this._annotationNulls.clear();
        if (!this._columnMissingAttrs.get(columnIndex - 1).isEmpty()) {
            this._annotationNulls.addAll(this._columnMissingAttrs.get(columnIndex - 1).keySet());
        }
        return attrs;
    }

    public synchronized Map<String, Object> getColumnAnnotations(String columnName) throws SQLException {
        return this.getColumnAnnotations(this.findColumn(columnName));
    }

    public synchronized String getStringResultSetAnnotation(String annotationName) throws SQLException {
        this.throwAnnotationExceptions(false);
        if (this._noAttributes) {
            return "";
        }
        if (!this._retrievedAllDataSetAttrs.booleanValue()) {
            this.getRioAttributes(2);
            this._retrievedAllDataSetAttrs = true;
        }
        this._annotationNull = false;
        if (this._dataSetCharAttrs.containsKey(annotationName)) {
            return this._dataSetCharAttrs.get(annotationName);
        }
        if (this._dataSetMissingAttrs.containsKey(annotationName)) {
            this._annotationNull = true;
            return null;
        }
        if (this._dataSetNumAttrs.containsKey(annotationName)) {
            return Double.toString(this._dataSetNumAttrs.get(annotationName));
        }
        return "";
    }

    public synchronized Map<String, Object> getResultSetAnnotations() throws SQLException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        this.throwAnnotationExceptions(false);
        if (this._noAttributes) {
            return attrs;
        }
        if (!this._retrievedAllDataSetAttrs.booleanValue()) {
            this.getRioAttributes(2);
            this._retrievedAllDataSetAttrs = true;
        }
        attrs.putAll(this._dataSetCharAttrs);
        attrs.putAll(this._dataSetNumAttrs);
        attrs.putAll(this._dataSetMissingAttrs);
        this._annotationNulls.clear();
        if (!this._dataSetMissingAttrs.isEmpty()) {
            this._annotationNulls.addAll(this._dataSetMissingAttrs.keySet());
        }
        return attrs;
    }

    public synchronized boolean hasColumnAnnotation(int columnIndex, String annotationName) throws SQLException {
        this.throwAnnotationExceptions(columnIndex, false);
        if (this._noAttributes) {
            return false;
        }
        if (!this._retrievedAllColumnAttrs.get(columnIndex - 1).booleanValue()) {
            this.getRioAttributes(columnIndex, this.m_rowCache.getColumns()[columnIndex - 1].getName(), 4);
            this._retrievedAllColumnAttrs.set(columnIndex - 1, true);
        }
        return this._columnCharAttrs.get(columnIndex - 1).containsKey(annotationName) || this._columnNumAttrs.get(columnIndex - 1).containsKey(annotationName) || this._columnMissingAttrs.get(columnIndex - 1).containsKey(annotationName);
    }

    public synchronized boolean hasColumnAnnotation(String columnName, String annotationName) throws SQLException {
        return this.hasColumnAnnotation(this.findColumn(columnName), annotationName);
    }

    public synchronized boolean hasColumnAnnotations(int columnIndex) throws SQLException {
        this.throwAnnotationExceptions(columnIndex, false);
        if (this._noAttributes) {
            return false;
        }
        if (!this._retrievedAllColumnAttrs.get(columnIndex - 1).booleanValue()) {
            this.getRioAttributes(columnIndex, this.m_rowCache.getColumns()[columnIndex - 1].getName(), 4);
            this._retrievedAllColumnAttrs.set(columnIndex - 1, true);
        }
        return !this._columnCharAttrs.get(columnIndex - 1).isEmpty() || !this._columnNumAttrs.get(columnIndex - 1).isEmpty() || !this._columnMissingAttrs.get(columnIndex - 1).isEmpty();
    }

    public synchronized boolean hasColumnAnnotations(String columnName) throws SQLException {
        return this.hasColumnAnnotations(this.findColumn(columnName));
    }

    public synchronized boolean hasResultSetAnnotation(String annotationName) throws SQLException {
        this.throwAnnotationExceptions(false);
        if (this._noAttributes) {
            return false;
        }
        if (!this._retrievedAllDataSetAttrs.booleanValue()) {
            this.getRioAttributes(2);
            this._retrievedAllDataSetAttrs = true;
        }
        return this._dataSetCharAttrs.containsKey(annotationName) || this._dataSetNumAttrs.containsKey(annotationName) || this._dataSetMissingAttrs.containsKey(annotationName);
    }

    public synchronized boolean hasResultSetAnnotations() throws SQLException {
        this.throwAnnotationExceptions(false);
        if (this._noAttributes) {
            return false;
        }
        if (!this._retrievedAllDataSetAttrs.booleanValue()) {
            this.getRioAttributes(2);
            this._retrievedAllDataSetAttrs = true;
        }
        return !this._dataSetCharAttrs.isEmpty() || !this._dataSetNumAttrs.isEmpty() || !this._dataSetMissingAttrs.isEmpty();
    }

    public synchronized void setStringColumnAnnotation(int columnIndex, String annotationName, String annotationValue) throws SQLException {
        this.throwAnnotationExceptions(columnIndex, true);
        HashMap<String, Object> annotations = new HashMap<String, Object>();
        if (annotationValue == null) {
            annotations.put(annotationName, " ");
        } else {
            annotations.put(annotationName, annotationValue);
        }
        this._rioUtil.setAttributes(4, this.m_rowCache.getColumns()[columnIndex - 1].getName(), annotations);
        if (annotationValue == null) {
            this._columnCharAttrs.get(columnIndex - 1).put(annotationName, " ");
        } else {
            this._columnCharAttrs.get(columnIndex - 1).put(annotationName, annotationValue);
        }
    }

    public synchronized void setStringColumnAnnotation(String columnName, String annotationName, String annotationValue) throws SQLException {
        this.setStringColumnAnnotation(this.findColumn(columnName), annotationName, annotationValue);
    }

    public synchronized void setColumnAnnotations(int columnIndex, Map<String, Object> annotations) throws SQLException {
        this.throwAnnotationExceptions(columnIndex, true);
        for (Map.Entry<String, Object> pairs : annotations.entrySet()) {
            if (pairs.getValue() instanceof String) {
                this._columnCharAttrs.get(columnIndex - 1).put(pairs.getKey(), (String)pairs.getValue());
                continue;
            }
            if (pairs.getValue() instanceof Character) {
                this._columnMissingAttrs.get(columnIndex - 1).put(pairs.getKey(), (Character)pairs.getValue());
                pairs.setValue(MissingValue.getNumericValue("." + pairs.getValue().toString()));
                continue;
            }
            if (!(pairs.getValue() instanceof Double)) continue;
            this._columnNumAttrs.get(columnIndex - 1).put(pairs.getKey(), (Double)pairs.getValue());
        }
        this._rioUtil.setAttributes(4, this.m_rowCache.getColumns()[columnIndex - 1].getName(), annotations);
    }

    public synchronized void setColumnAnnotations(String columnName, Map<String, Object> annotations) throws SQLException {
        this.setColumnAnnotations(this.findColumn(columnName), annotations);
    }

    public synchronized void setStringResultSetAnnotation(String annotationName, String annotationValue) throws SQLException {
        this.throwAnnotationExceptions(true);
        HashMap<String, Object> annotations = new HashMap<String, Object>();
        if (annotationValue == null) {
            annotations.put(annotationName, " ");
        } else {
            annotations.put(annotationName, annotationValue);
        }
        this._rioUtil.setAttributes(2, "", annotations);
        if (annotationValue == null) {
            this._dataSetCharAttrs.put(annotationName, " ");
        } else {
            this._dataSetCharAttrs.put(annotationName, annotationValue);
        }
        this._dataSetCharAttrs.put(annotationName, annotationValue);
    }

    public synchronized void setResultSetAnnotations(Map<String, Object> annotations) throws SQLException {
        this.throwAnnotationExceptions(true);
        for (Map.Entry<String, Object> pairs : annotations.entrySet()) {
            if (pairs.getValue() instanceof String) {
                this._dataSetCharAttrs.put(pairs.getKey(), (String)pairs.getValue());
                continue;
            }
            if (pairs.getValue() instanceof Character) {
                this._dataSetMissingAttrs.put(pairs.getKey(), (Character)pairs.getValue());
                pairs.setValue(MissingValue.getNumericValue("." + pairs.getValue().toString()));
                continue;
            }
            if (!(pairs.getValue() instanceof Double)) continue;
            this._dataSetNumAttrs.put(pairs.getKey(), (Double)pairs.getValue());
        }
        this._rioUtil.setAttributes(2, "", annotations);
    }

    public synchronized double getDoubleColumnAnnotation(int columnIndex, String annotationName) throws SQLException {
        this.throwAnnotationExceptions(columnIndex, false);
        if (this._noAttributes) {
            return 0.0;
        }
        if (!this._retrievedAllColumnAttrs.get(columnIndex - 1).booleanValue()) {
            this.getRioAttributes(columnIndex, this.m_rowCache.getColumns()[columnIndex - 1].getName(), 4);
            this._retrievedAllColumnAttrs.set(columnIndex - 1, true);
        }
        this._annotationNull = false;
        if (this._columnMissingAttrs.get(columnIndex - 1).containsKey(annotationName)) {
            this._annotationNull = true;
            return 0.0;
        }
        if (this._columnNumAttrs.get(columnIndex - 1).containsKey(annotationName)) {
            return this._columnNumAttrs.get(columnIndex - 1).get(annotationName);
        }
        return 0.0;
    }

    public synchronized double getDoubleColumnAnnotation(String columnName, String annotationName) throws SQLException {
        return this.getDoubleColumnAnnotation(this.findColumn(columnName), annotationName);
    }

    public synchronized double getDoubleResultSetAnnotation(String annotationName) throws SQLException {
        this.throwAnnotationExceptions(false);
        if (this._noAttributes) {
            return 0.0;
        }
        if (!this._retrievedAllDataSetAttrs.booleanValue()) {
            this.getRioAttributes(2);
            this._retrievedAllDataSetAttrs = true;
        }
        this._annotationNull = false;
        if (this._dataSetMissingAttrs.containsKey(annotationName)) {
            this._annotationNull = true;
            return 0.0;
        }
        if (this._dataSetNumAttrs.containsKey(annotationName)) {
            return this._dataSetNumAttrs.get(annotationName);
        }
        return 0.0;
    }

    public synchronized void setDoubleColumnAnnotation(int columnIndex, String annotationName, Double annotationValue) throws SQLException {
        this.throwAnnotationExceptions(columnIndex, true);
        HashMap<String, Object> annotations = new HashMap<String, Object>();
        if (annotationValue == null) {
            annotations.put(annotationName, MissingValue.getNumericValue("."));
        } else {
            annotations.put(annotationName, annotationValue);
        }
        this._rioUtil.setAttributes(4, this.m_rowCache.getColumns()[columnIndex - 1].getName(), annotations);
        if (annotationValue == null) {
            this._columnMissingAttrs.get(columnIndex - 1).put(annotationName, Character.valueOf('.'));
        } else {
            this._columnNumAttrs.get(columnIndex - 1).put(annotationName, annotationValue);
        }
    }

    public synchronized void setDoubleColumnAnnotation(String columnName, String annotationName, Double annotationValue) throws SQLException {
        this.setDoubleColumnAnnotation(this.findColumn(columnName), annotationName, annotationValue);
    }

    public synchronized void setDoubleResultSetAnnotation(String annotationName, Double annotationValue) throws SQLException {
        this.throwAnnotationExceptions(true);
        HashMap<String, Object> annotations = new HashMap<String, Object>();
        if (annotationValue == null) {
            annotations.put(annotationName, MissingValue.getNumericValue("."));
        } else {
            annotations.put(annotationName, annotationValue);
        }
        this._rioUtil.setAttributes(2, "", annotations);
        if (annotationValue == null) {
            this._dataSetMissingAttrs.put(annotationName, Character.valueOf('.'));
        } else {
            this._dataSetNumAttrs.put(annotationName, annotationValue);
        }
    }

    public synchronized String[] wasAnnotationsNull() throws SQLException {
        this.throwAnnotationExceptions(false);
        String[] list = new String[]{};
        return this._annotationNulls.toArray(list);
    }

    public synchronized boolean wasAnnotationNull() throws SQLException {
        this.throwAnnotationExceptions(false);
        return this._annotationNull;
    }

    public synchronized void setNullColumnAnnotation(int columnIndex, int jdbcType, String annotationName) throws SQLException {
        this.setNullColumnAnnotation(columnIndex, jdbcType, annotationName, ".");
    }

    public synchronized void setNullColumnAnnotation(int columnIndex, int jdbcType, String annotationName, String missingValue) throws SQLException {
        this.throwAnnotationExceptions(columnIndex, true);
        HashMap<String, Object> annotations = new HashMap<String, Object>();
        if (jdbcType == 8) {
            if (missingValue != null && missingValue.length() == 1) {
                missingValue = "." + missingValue;
            }
            annotations.put(annotationName, MissingValue.getNumericValue(missingValue));
        } else if (jdbcType == 12 || jdbcType == 1 || jdbcType == -16) {
            annotations.put(annotationName, " ");
        } else {
            throw new MVASQLException(MessageCode.MVAAnnotatedResultSet_invalidType, new Object[0]);
        }
        this._rioUtil.setAttributes(4, this.m_rowCache.getColumns()[columnIndex - 1].getName(), annotations);
        if (jdbcType == 8) {
            char annotationValue = '.';
            if (missingValue == null) {
                annotationValue = '.';
            } else if (missingValue.length() == 1) {
                annotationValue = missingValue.charAt(0);
            } else if (missingValue.length() == 2) {
                annotationValue = missingValue.charAt(1);
            }
            this._columnMissingAttrs.get(columnIndex - 1).put(annotationName, Character.valueOf(annotationValue));
        } else {
            this._columnCharAttrs.get(columnIndex - 1).put(annotationName, " ");
        }
    }

    public synchronized void setNullResultSetAnnotation(int jdbcType, String annotationName) throws SQLException {
        this.setNullResultSetAnnotation(jdbcType, annotationName, ".");
    }

    public synchronized void setNullResultSetAnnotation(int jdbcType, String annotationName, String missingValue) throws SQLException {
        this.throwAnnotationExceptions(true);
        HashMap<String, Object> annotations = new HashMap<String, Object>();
        if (jdbcType == 8) {
            annotations.put(annotationName, MissingValue.getNumericValue(missingValue));
        } else if (jdbcType == 12 || jdbcType == 1 || jdbcType == -16) {
            annotations.put(annotationName, " ");
        } else {
            throw new MVASQLException(MessageCode.MVAAnnotatedResultSet_invalidType, new Object[0]);
        }
        this._rioUtil.setAttributes(2, "", annotations);
        if (jdbcType == 8) {
            char annotationValue = '.';
            if (missingValue == null) {
                annotationValue = '.';
            } else if (missingValue.length() == 1) {
                annotationValue = missingValue.charAt(0);
            } else if (missingValue.length() == 2) {
                annotationValue = missingValue.charAt(1);
            }
            this._dataSetMissingAttrs.put(annotationName, Character.valueOf(annotationValue));
        } else {
            this._dataSetCharAttrs.put(annotationName, " ");
        }
    }

    public synchronized int getColumnAnnotationType(String columnName, String annotationName) throws SQLException {
        return this.getColumnAnnotationType(this.findColumn(columnName), annotationName);
    }

    public synchronized int getColumnAnnotationType(int columnIndex, String annotationName) throws SQLException {
        this.throwAnnotationExceptions(columnIndex, false);
        if (this._noAttributes) {
            throw new MVASQLException(MessageCode.MVAAnnotatedResultSet_noAnnotation, annotationName);
        }
        if (!this._retrievedAllColumnAttrs.get(columnIndex - 1).booleanValue()) {
            this.getRioAttributes(columnIndex, this.m_rowCache.getColumns()[columnIndex - 1].getName(), 4);
            this._retrievedAllColumnAttrs.set(columnIndex - 1, true);
        }
        if (this._columnCharAttrs.get(columnIndex - 1).containsKey(annotationName)) {
            return 12;
        }
        if (this._columnMissingAttrs.get(columnIndex - 1).containsKey(annotationName) || this._columnNumAttrs.get(columnIndex - 1).containsKey(annotationName)) {
            return 8;
        }
        throw new MVASQLException(MessageCode.MVAAnnotatedResultSet_noAnnotation, annotationName);
    }

    public synchronized int getResultSetAnnotationType(String annotationName) throws SQLException {
        this.throwAnnotationExceptions(false);
        if (this._noAttributes) {
            throw new MVASQLException(MessageCode.MVAAnnotatedResultSet_noAnnotation, annotationName);
        }
        if (!this._retrievedAllDataSetAttrs.booleanValue()) {
            this.getRioAttributes(2);
            this._retrievedAllDataSetAttrs = true;
        }
        if (this._dataSetCharAttrs.containsKey(annotationName)) {
            return 12;
        }
        if (this._dataSetMissingAttrs.containsKey(annotationName) || this._dataSetNumAttrs.containsKey(annotationName)) {
            return 8;
        }
        throw new MVASQLException(MessageCode.MVAAnnotatedResultSet_noAnnotation, annotationName);
    }

    public synchronized void clearColumnAnnotation(int columnIndex, String annotationName) throws SQLException {
        this.throwAnnotationExceptions(columnIndex, true);
        if (this._noAttributes) {
            return;
        }
        if (annotationName == null) {
            return;
        }
        if (!this._retrievedAllColumnAttrs.get(columnIndex - 1).booleanValue()) {
            this.getRioAttributes(columnIndex, this.m_rowCache.getColumns()[columnIndex - 1].getName(), 4);
            this._retrievedAllColumnAttrs.set(columnIndex - 1, true);
        }
        ArrayList<String> attrList = new ArrayList<String>(1);
        if (this._columnCharAttrs.get(columnIndex - 1).containsKey(annotationName)) {
            attrList.add(annotationName);
        } else if (this._columnNumAttrs.get(columnIndex - 1).containsKey(annotationName)) {
            attrList.add(annotationName);
        } else if (this._columnMissingAttrs.get(columnIndex - 1).containsKey(annotationName)) {
            attrList.add(annotationName);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format(clearColAnnotatationLayout, annotationName, columnIndex));
            }
            return;
        }
        this._rioUtil.dropAttributes(4, this.m_rowCache.getColumns()[columnIndex - 1].getName(), attrList);
        this._columnCharAttrs.get(columnIndex - 1).remove(annotationName);
        this._columnNumAttrs.get(columnIndex - 1).remove(annotationName);
        this._columnMissingAttrs.get(columnIndex - 1).remove(annotationName);
    }

    public synchronized void clearColumnAnnotation(String columnName, String annotationName) throws SQLException {
        this.clearColumnAnnotation(this.findColumn(columnName), annotationName);
    }

    public synchronized void clearResultSetAnnotation(String annotationName) throws SQLException {
        this.throwAnnotationExceptions(true);
        if (this._noAttributes) {
            return;
        }
        if (annotationName == null) {
            return;
        }
        if (!this._retrievedAllDataSetAttrs.booleanValue()) {
            this.getRioAttributes(2);
            this._retrievedAllDataSetAttrs = true;
        }
        ArrayList<String> attrList = new ArrayList<String>(1);
        if (this._dataSetCharAttrs.containsKey(annotationName)) {
            attrList.add(annotationName);
        } else if (this._dataSetNumAttrs.containsKey(annotationName)) {
            attrList.add(annotationName);
        } else if (this._dataSetMissingAttrs.containsKey(annotationName)) {
            attrList.add(annotationName);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format(clearRSAnnotatationLayout, annotationName));
            }
            return;
        }
        this._rioUtil.dropAttributes(2, "", attrList);
        this._dataSetCharAttrs.remove(annotationName);
        this._dataSetNumAttrs.remove(annotationName);
        this._dataSetMissingAttrs.remove(annotationName);
    }

    public synchronized Character getMissingValueResultSetAnnotation(String annotationName) throws SQLException {
        this.throwAnnotationExceptions(false);
        if (this._noAttributes) {
            return null;
        }
        if (!this._retrievedAllDataSetAttrs.booleanValue()) {
            this.getRioAttributes(2);
            this._retrievedAllDataSetAttrs = true;
        }
        if (this._dataSetMissingAttrs.containsKey(annotationName)) {
            this._annotationNull = true;
            return this._dataSetMissingAttrs.get(annotationName);
        }
        this._annotationNull = false;
        return null;
    }

    public synchronized Character getMissingValueColumnAnnotation(int columnIndex, String annotationName) throws SQLException {
        this.throwAnnotationExceptions(columnIndex, false);
        if (this._noAttributes) {
            return null;
        }
        if (!this._retrievedAllColumnAttrs.get(columnIndex - 1).booleanValue()) {
            this.getRioAttributes(columnIndex, this.m_rowCache.getColumns()[columnIndex - 1].getName(), 4);
            this._retrievedAllColumnAttrs.set(columnIndex - 1, true);
        }
        this._annotationNull = false;
        if (this._columnMissingAttrs.get(columnIndex - 1).containsKey(annotationName)) {
            this._annotationNull = true;
            return this._columnMissingAttrs.get(columnIndex - 1).get(annotationName);
        }
        this._annotationNull = false;
        return null;
    }

    public synchronized Character getMissingValueColumnAnnotation(String columnName, String annotationName) throws SQLException {
        return this.getMissingValueColumnAnnotation(this.findColumn(columnName), annotationName);
    }

    @SASScope
    private void getRioAttributes(int iFlags) throws SQLException {
        Map<String, Object> attrs = this._rioUtil.getAttributes(iFlags, "", 50);
        for (Map.Entry<String, Object> pairs : attrs.entrySet()) {
            if (pairs.getValue() instanceof String) {
                this._dataSetCharAttrs.put(pairs.getKey(), (String)pairs.getValue());
                continue;
            }
            if (pairs.getValue() instanceof Character) {
                this._dataSetMissingAttrs.put(pairs.getKey(), (Character)pairs.getValue());
                continue;
            }
            if (!(pairs.getValue() instanceof Double)) continue;
            this._dataSetNumAttrs.put(pairs.getKey(), (Double)pairs.getValue());
        }
    }

    @SASScope
    private void getRioAttributes(int columnIndex, String columnName, int iFlags) throws SQLException {
        Map<String, Object> attrs = this._rioUtil.getAttributes(iFlags, columnName, 50);
        for (Map.Entry<String, Object> pairs : attrs.entrySet()) {
            if (pairs.getValue() instanceof String) {
                this._columnCharAttrs.get(columnIndex - 1).put(pairs.getKey(), (String)pairs.getValue());
                continue;
            }
            if (pairs.getValue() instanceof Character) {
                this._columnMissingAttrs.get(columnIndex - 1).put(pairs.getKey(), (Character)pairs.getValue());
                continue;
            }
            if (!(pairs.getValue() instanceof Double)) continue;
            this._columnNumAttrs.get(columnIndex - 1).put(pairs.getKey(), (Double)pairs.getValue());
        }
    }

    @SASScope
    private void throwAnnotationExceptions(int columnIndex, boolean update) throws SQLException {
        this.throwAnnotationExceptions(update);
        if (columnIndex < 1 || columnIndex > this.m_rowCache.getColumns().length) {
            throw new MVASQLException(MessageCode.General_invalidColumnValue, new Object[0]);
        }
    }

    @SASScope
    private void throwAnnotationExceptions(boolean update) throws SQLException {
        if (this._closed) {
            throw new MVASQLException(MessageCode.MVAResultSet_notOpenError, new Object[0]);
        }
        if (update && this._readOnly) {
            throw new MVASQLException(MessageCode.MVAAnnotatedResultSet_notUpdatableResultSetError, new Object[0]);
        }
        if (!this._init) {
            this.init();
        }
    }
}

