/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.SASScope;
import com.sas.services.connection.ConnectionFactoryAdminInterface;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryEventListener;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryKernel;
import com.sas.services.connection.ConnectionFactoryRequest;
import com.sas.services.connection.ConnectionFactoryShellInterface;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.ConnectionRequest;
import com.sas.services.connection.Credential;
import java.util.List;
import java.util.logging.Logger;

@SASScope
public abstract class ConnectionFactoryShell
implements ConnectionFactoryShellInterface {
    private ConnectionFactoryKernel _kernel = null;

    @Override
    public void addConnectionFactoryEventListener(ConnectionFactoryEventListener listener) {
        this.getKernel().addConnectionFactoryEventListener(listener);
    }

    @Override
    public void removeConnectionFactoryEventListener(ConnectionFactoryEventListener listener) {
        this.getKernel().removeConnectionFactoryEventListener(listener);
    }

    @Override
    public List getDomains() {
        return this.getKernel().getDomains();
    }

    @Override
    public ConnectionInterface getConnection(Credential userLogin) throws ConnectionFactoryException {
        return this.getConnection(userLogin, 0L, null);
    }

    @Override
    public ConnectionInterface getConnection(Credential userLogin, long waitMilliseconds) throws ConnectionFactoryException {
        return this.getConnection(userLogin, waitMilliseconds, null);
    }

    @Override
    public ConnectionFactoryAdminInterface getAdminInterface(Credential adminLogin) throws ConnectionFactoryException {
        return this.getKernel().getAdminInterface(adminLogin);
    }

    protected ConnectionInterface getConnection(Credential userLogin, long waitMilliseconds, Logger cxLogger) throws ConnectionFactoryException {
        ConnectionRequest cxReq = ConnectionRequest.wrap(this._kernel, userLogin, waitMilliseconds);
        ConnectionInterface cx = this._kernel.getConnection(cxReq);
        return cx;
    }

    protected ConnectionInterface getConnection(ConnectionRequest cxReq) throws ConnectionFactoryException {
        ConnectionInterface cx = this._kernel.getConnection(cxReq);
        return cx;
    }

    protected void setKernel(ConnectionFactoryKernel kernel) {
        this._kernel = kernel;
    }

    protected ConnectionFactoryKernel getKernel() {
        return this._kernel;
    }

    protected boolean isSecurityPackageAllowed() {
        boolean securityPackageAllowed = this._kernel.isSecurityPackageAllowed();
        return securityPackageAllowed;
    }

    protected boolean isTrustedPeerAllowed() {
        boolean trustedPeerAllowed = this._kernel.isTrustedPeerAllowed();
        return trustedPeerAllowed;
    }

    protected String getAuthService() {
        String authService = this._kernel.getAuthService();
        return authService;
    }

    protected String getLogicalServerName() {
        ConnectionFactoryConfiguration cxfConfig = this._kernel.getConfig();
        String serverName = cxfConfig.getLogicalServerName();
        return serverName;
    }

    protected ConnectionFactoryRequest getRequest() {
        ConnectionFactoryRequest cxfReq = this._kernel.getRequest();
        return cxfReq;
    }
}

