/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.SASScope;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

@SASScope
public abstract class Request {
    private static final String _loggerName = Request.class.getPackage().getName();
    private static final String _tracerName = _loggerName + ".trace";
    private static final Logger _logger = Logger.getLogger((String)_loggerName);
    private static final Logger _tracer = Logger.getLogger((String)_tracerName);
    private String _msgPrefix;
    private int _msgPrefixL;

    protected Request() {
    }

    public boolean isLoggableWARNING() {
        boolean result = this.isLoggable(Level.WARN);
        return result;
    }

    public boolean isLoggableFINE() {
        boolean result = this.isLoggable(Level.DEBUG);
        return result;
    }

    public boolean isLoggableFINEST() {
        boolean result = this.isLoggable(Level.TRACE);
        return result;
    }

    public boolean isTraceable() {
        boolean result = _tracer.isTraceEnabled();
        return result;
    }

    public void logWARNING(String msg) {
        this.log(Level.WARN, msg, null);
    }

    public void logWARNING(String msg, Throwable thrown) {
        this.log(Level.WARN, msg, thrown);
    }

    public void logFINE(String msg) {
        this.log(Level.DEBUG, msg, null);
    }

    public void logFINE(String msg, Throwable thrown) {
        this.log(Level.DEBUG, msg, thrown);
    }

    public void logFINEST(String msg) {
        this.log(Level.TRACE, msg, null);
    }

    public void logFINEST(String msg, Throwable thrown) {
        this.log(Level.TRACE, msg, thrown);
    }

    public void trace(String msg, Throwable tb) {
        String m = this.attachPrefix(msg);
        _tracer.trace((Object)m, tb);
    }

    protected void setMessagePrefix(String msgPrefix) {
        this._msgPrefix = msgPrefix;
        this._msgPrefixL = msgPrefix != null ? msgPrefix.length() : 0;
    }

    private boolean isLoggable(Level level) {
        boolean result = _logger.isEnabledFor((Priority)level);
        return result;
    }

    private void log(Level level, String msg, Throwable thrown) {
        String m = this.attachPrefix(msg);
        _logger.log((Priority)level, (Object)m, thrown);
    }

    private String attachPrefix(String msg) {
        if (msg != null) {
            int msgL = msg.length();
            int bufL = this._msgPrefixL + msgL;
            StringBuffer buf = new StringBuffer(bufL);
            buf.append(this._msgPrefix).append(msg);
            msg = buf.toString();
        } else {
            msg = this._msgPrefix;
        }
        return msg;
    }
}

