/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection;

import com.sas.PublicClonable;
import com.sas.collection.Entry;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class LongKeyDictionary
implements PublicClonable,
Serializable {
    static final long serialVersionUID = 7961991170118102709L;
    public static final Object NO_SUCH_ELEMENT = new String("NO_SUCH_ELEMENT");
    private transient Entry[] items;
    public static float DEFAULT_LOAD_FACTOR = 0.75f;
    private float loadFactor;
    private transient int max;
    private transient int count;
    private static final int[] tableSizes = new int[]{101, 211, 401, 607, 1009, 2003, 4001, 8009, 16001, 19997, 40009, 80021, 160001, 199967, 499973, 999983};
    private int itemsLength;

    private int hashSlot(long key) {
        int slot = (int)key % this.itemsLength;
        if (slot < 0) {
            slot = -slot;
        }
        return slot;
    }

    public LongKeyDictionary() {
        this(tableSizes[0], DEFAULT_LOAD_FACTOR);
    }

    public LongKeyDictionary(int capacity, float loadFactor) {
        if (capacity <= 0 || loadFactor <= 0.0f) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.itemsLength = this.optimalSize(capacity);
        this.items = new Entry[this.itemsLength];
        this.max = (int)((float)this.itemsLength * loadFactor);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        LongKeyDictionary clone = (LongKeyDictionary)super.clone();
        clone.items = new Entry[this.itemsLength];
        for (int i = 0; i < this.itemsLength; ++i) {
            Entry entry = this.items[i];
            if (entry == null) continue;
            clone.items[i] = (Entry)entry.clone();
        }
        return clone;
    }

    private int optimalSize(int desiredSize) {
        for (int i = 0; i < tableSizes.length - 1; ++i) {
            if (desiredSize > tableSizes[i]) continue;
            return tableSizes[i];
        }
        return tableSizes[tableSizes.length - 1];
    }

    private Entry previous(Object value) {
        return this.previous(value, true);
    }

    private Entry previous(Object value, boolean whenEquals) {
        for (int i = 0; i < this.itemsLength; ++i) {
            Entry entry;
            Entry head = this.items[i];
            if (head == null || (entry = head.previous(value, whenEquals)) == null) continue;
            return entry;
        }
        return null;
    }

    private Entry previous(long key) {
        int slot = this.hashSlot(key);
        Entry head = this.items[slot];
        if (head != null) {
            Entry entry = head.previous(key);
            return entry;
        }
        return null;
    }

    public boolean remove(Object value) {
        Entry prev = this.previous(value);
        if (prev != null) {
            prev.next = prev.next.next;
            --this.count;
            return true;
        }
        return false;
    }

    public boolean removeAt(long key) {
        Entry prev = this.previous(key);
        if (prev != null) {
            prev.next = prev.next.next;
            --this.count;
            return true;
        }
        return false;
    }

    public void set(long key, Object value) {
        Entry prev = this.previous(key);
        if (prev != null) {
            prev.next.value = value;
        } else {
            int slot;
            ++this.count;
            if (this.count >= this.max) {
                this.rehash();
            }
            if (this.items[slot = this.hashSlot(key)] == null) {
                this.items[slot] = new Entry(0L, null, new Entry(key, value, null));
            } else {
                this.items[slot].next = new Entry(key, value, this.items[slot].next);
            }
        }
    }

    private void rehash() {
        int newSize = this.optimalSize(this.count + this.count / 10);
        if (newSize <= this.itemsLength) {
            return;
        }
        this.max = (int)((float)newSize * this.loadFactor);
        Entry[] oldItems = this.items;
        this.items = new Entry[newSize];
        Entry freeChain = null;
        for (int i = 0; i < this.itemsLength; ++i) {
            Entry head = oldItems[i];
            if (head == null) continue;
            oldItems[i] = head.next;
            head.next = freeChain;
            freeChain = head;
        }
        int len = this.itemsLength;
        this.itemsLength = newSize;
        for (int i = 0; i < len; ++i) {
            Entry entry = oldItems[i];
            while (entry != null) {
                Entry next = entry.next;
                int slot = this.hashSlot(entry.key);
                if (this.items[slot] == null) {
                    if (freeChain != null) {
                        this.items[slot] = freeChain;
                        freeChain = freeChain.next;
                        this.items[slot].next = null;
                    } else {
                        this.items[slot] = new Entry();
                    }
                }
                entry.next = this.items[slot].next;
                this.items[slot].next = entry;
                entry = next;
            }
        }
    }

    public void removeAll() {
        for (int i = 0; i < this.itemsLength; ++i) {
            this.items[i] = null;
        }
        this.count = 0;
    }

    public int removeAll(Object value) {
        return this.removeAll(value, true);
    }

    public int removeAll(Object value, boolean whenEquals) {
        Entry previous;
        int nRemoved = 0;
        while ((previous = this.previous(value, whenEquals)) != null) {
            previous.next = previous.next.next;
            --this.count;
            ++nRemoved;
        }
        return nRemoved;
    }

    public boolean containsKey(long key) {
        return this.previous(key) != null;
    }

    public boolean contains(Object value) {
        return this.contains(value, true);
    }

    public boolean contains(Object value, boolean whenEquals) {
        return this.previous(value, whenEquals) != null;
    }

    public Object get(long key) {
        Entry previous = this.previous(key);
        if (previous != null) {
            return previous.next.value;
        }
        throw new NoSuchElementException();
    }

    public Object get(long key, Object defaultValue) {
        Entry previous = this.previous(key);
        if (previous != null) {
            return previous.next.value;
        }
        return defaultValue;
    }

    public long getKey(Object value) {
        Entry previous = this.previous(value);
        if (previous != null) {
            return previous.next.key;
        }
        throw new NoSuchElementException();
    }

    public long getKey(Object value, long defaultKey) {
        Entry previous = this.previous(value);
        if (previous != null) {
            return previous.next.key;
        }
        return defaultKey;
    }

    public long[] getKeys() {
        long[] result = new long[this.count];
        int pos = 0;
        for (int i = 0; i < this.itemsLength; ++i) {
            Entry entry = this.items[i];
            if (entry == null) continue;
            pos += entry.fill(result, pos);
        }
        return result;
    }

    public Object[] getValues() {
        Object[] result = new Object[this.count];
        int pos = 0;
        for (int i = 0; i < this.itemsLength; ++i) {
            Entry entry = this.items[i];
            if (entry == null) continue;
            pos += entry.fill(result, pos);
        }
        return result;
    }

    public int count() {
        return this.count;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int n;
        stream.defaultReadObject();
        this.itemsLength = this.optimalSize(n);
        this.items = new Entry[this.itemsLength];
        this.max = (int)((float)this.itemsLength * this.loadFactor);
        for (n = stream.readInt(); n > 0; --n) {
            long k = stream.readLong();
            Object o = stream.readObject();
            this.set(k, o);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.count);
        for (int i = 0; i < this.itemsLength; ++i) {
            Entry entry = this.items[i];
            if (entry != null) {
                entry = entry.next;
            }
            while (entry != null) {
                stream.writeLong(entry.key);
                stream.writeObject(entry.value);
                entry = entry.next;
            }
        }
    }
}

