/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.StringType;
import com.sas.models.EncodedString;
import com.sas.models.EncodingInterface;
import com.sas.util.ValueItem;
import com.sas.util.transforms.MissingValuesToStringTransform;
import com.sas.util.transforms.StringEchoTransform;
import java.util.List;
import java.util.Locale;

@SASScope
public abstract class BaseMaskedType
extends StringType {
    public abstract String getEncoding();

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        if (inputValue instanceof List && ((List)inputValue).size() == 1) {
            inputValue = ((List)inputValue).get(0);
        }
        if (inputValue instanceof EncodingInterface) {
            return inputValue;
        }
        if (inputValue instanceof String) {
            return new EncodedString(this.getEncoding(), (String)inputValue);
        }
        if (inputValue instanceof ValueItem) {
            return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
        }
        if (inputValue instanceof String[] && ((String[])inputValue).length == 1) {
            return this.coerceValue(((String[])inputValue)[0], inputLocale);
        }
        if (inputValue instanceof MissingValues) {
            return inputValue;
        }
        if (inputValue instanceof SpecialValues) {
            return inputValue;
        }
        if (inputValue == null) {
            return null;
        }
        throw new IllegalArgumentException("Unable to convert input value to masked type: " + inputValue);
    }

    @Override
    public String getValueAsString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        if (value instanceof MissingValues) {
            return (String)MissingValuesToStringTransform.defaultInstance.transform(value);
        }
        if (value instanceof SpecialValues) {
            return this.getSpecialValuesAsString((SpecialValues)value, outputLocale);
        }
        return ((EncodingInterface)value).getEncodedValue();
    }

    @Override
    public String getDisplayString(Object value, Locale outputLocale) {
        if ((value = this.coerceValue(value, outputLocale)) instanceof EncodingInterface) {
            return (String)StringEchoTransform.defaultInstance.transform(((EncodingInterface)value).getValue());
        }
        return super.getDisplayString(value, outputLocale);
    }
}

