/*
 * Decompiled with CFR 0.152.
 */
package com.sas.nls.encoding;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class Encoding {
    private static final Map<String, Integer> s_EncSession;
    private static final Map<String, Integer> s_EncOther;
    private static final Map<Integer, String> s_mapCei2Java;
    private static final Map<Integer, String> s_mapCei2Flex;
    private static final Map<String, String> s_mapJava2Flex;
    private static final Map<String, Integer> s_maxCharLen;
    private static final Map<String, String[]> s_EncodingFamily;
    static String[] Unic;
    static String[] ar;
    static String[] be;
    static String[] ca;
    static String[] cs;
    static String[] da;
    static String[] de;
    static String[] el;
    static String[] en;
    static String[] es;
    static String[] et;
    static String[] fi;
    static String[] fr;
    static String[] ga;
    static String[] hi;
    static String[] hr;
    static String[] hu;
    static String[] fo;
    static String[] it;
    static String[] iw;
    static String[] ja;
    static String[] ko;
    static String[] lt;
    static String[] mt;
    static String[] nl;
    static String[] no;
    static String[] pl;
    static String[] pt;
    static String[] ro;
    static String[] sl;
    static String[] sq;
    static String[] sv;
    static String[] th;
    static String[] tr;
    static String[] vi;
    static String[] zh;
    static String[] zt;

    public static boolean isValidSessionEncoding(String sSASEncoding) {
        return sSASEncoding != null && s_EncSession.containsKey(sSASEncoding.toLowerCase());
    }

    public static boolean isValidSASEncoding(String sSASEncoding) {
        return sSASEncoding != null && (s_EncOther.containsKey(sSASEncoding = sSASEncoding.toLowerCase()) || s_EncSession.containsKey(sSASEncoding));
    }

    private static int getCei(String sSASEncoding) {
        int cei = -1;
        if (sSASEncoding != null) {
            if (s_EncSession.containsKey(sSASEncoding = sSASEncoding.toLowerCase())) {
                cei = s_EncSession.get(sSASEncoding);
            } else if (s_EncOther.containsKey(sSASEncoding)) {
                cei = s_EncOther.get(sSASEncoding);
            }
        }
        return cei;
    }

    public static String getJavaEncoding(String sSASEncoding) throws UnsupportedEncodingException {
        int cei = Encoding.getCei(sSASEncoding);
        if (cei == -1) {
            throw new UnsupportedEncodingException("Error: Unsupported SAS Encoding name.");
        }
        if (s_mapCei2Java.containsKey(cei)) {
            return s_mapCei2Java.get(cei);
        }
        return null;
    }

    public static String getJavaEncodingFromCEI(int cei) {
        if (s_mapCei2Java.containsKey(cei)) {
            return s_mapCei2Java.get(cei);
        }
        return null;
    }

    public static String getFlexEncoding(String sSASEncoding) throws UnsupportedEncodingException {
        int cei = Encoding.getCei(sSASEncoding);
        if (cei == -1) {
            throw new UnsupportedEncodingException("Error: Unsupported SAS Encoding name.");
        }
        if (s_mapCei2Flex.containsKey(cei)) {
            return s_mapCei2Flex.get(cei);
        }
        return null;
    }

    public static String getFlexEncodingFromCEI(int cei) {
        if (s_mapCei2Flex.containsKey(cei)) {
            return s_mapCei2Flex.get(cei);
        }
        return null;
    }

    public static String javaToFlexEncoding(String javaEncoding) throws UnsupportedEncodingException {
        if (javaEncoding != null) {
            if (s_mapJava2Flex.containsKey(javaEncoding.toLowerCase())) {
                return s_mapJava2Flex.get(javaEncoding.toLowerCase());
            }
            throw new UnsupportedEncodingException("Error: No encoding found.");
        }
        return null;
    }

    public static float getMaxBytesPerCharacter(Charset charset) {
        if (s_maxCharLen.containsKey(charset.name())) {
            return s_maxCharLen.get(charset.name()).intValue();
        }
        return charset.newEncoder().maxBytesPerChar();
    }

    protected static List<String> getEncodingList(Locale locale, Locale DisplayLocale, boolean description) {
        ResourceBundle bundle = ResourceBundle.getBundle("com.sas.nls.encoding.Encoding", DisplayLocale);
        ArrayList<String> enclist = new ArrayList<String>();
        String javalocale = locale.getLanguage();
        if (javalocale.equals("zh") && (locale.getCountry().equals("TW") || locale.getCountry().equals("HK"))) {
            javalocale = javalocale.replace("zh", "zt");
        }
        if (s_EncodingFamily.containsKey(javalocale.toString())) {
            int i;
            String[] enc = s_EncodingFamily.get(javalocale.toString());
            for (i = 0; i < enc.length; ++i) {
                if (!Charset.isSupported(enc[i])) continue;
                if (description) {
                    enclist.add(bundle.getString("Encoding." + enc[i] + ".txt"));
                    continue;
                }
                enclist.add(enc[i]);
            }
            for (i = 0; i < Unic.length; ++i) {
                if (!Charset.isSupported(Unic[i])) continue;
                if (description) {
                    enclist.add(bundle.getString("Encoding." + Unic[i] + ".txt"));
                    continue;
                }
                enclist.add(Unic[i]);
            }
            return enclist;
        }
        return null;
    }

    public static List<String> getEncodingDisplayNameList() {
        return Encoding.getEncodingList(Locale.getDefault(), Locale.getDefault(), true);
    }

    public static List<String> getEncodingDisplayNameList(Locale locale) {
        return Encoding.getEncodingList(locale, Locale.getDefault(), true);
    }

    public static List<String> getEncodingNameList() {
        return Encoding.getEncodingList(Locale.getDefault(), Locale.getDefault(), false);
    }

    public static List<String> getEncodingNameList(Locale locale) {
        return Encoding.getEncodingList(locale, Locale.getDefault(), false);
    }

    static {
        Unic = new String[]{"CESU-8", "UTF-8", "UTF-16", "UTF-16BE", "UTF-16LE", "UTF-32", "UTF-32BE", "UTF-32LE", "X-UTF-32BE-BOM", "X-UTF-32LE-BOM", "x-UTF-16LE-BOM"};
        ar = new String[]{"IBM420", "IBM864", "ISO-8859-6", "windows-1256", "x-IBM1046", "x-MacArabic"};
        be = new String[]{"IBM855", "ISO-8859-5", "windows-1251", "x-IBM1025", "x-MacCyrillic", "IBM866", "KOI8-R", "KOI8-U", "x-IBM1123", "x-IBM1124", "x-MacUkraine"};
        ca = new String[]{"IBM01145", "IBM284", "ISO-8859-1", "windows-1252", "IBM850", "IBM1047", "IBM037", "ISO-8859-15", "ISO-8859-3", "IBM00858", "IBM01140", "IBM01148", "IBM500", "US-ASCII", "IBM437"};
        cs = new String[]{"IBM852", "IBM870", "ISO-8859-2", "windows-1250", "x-MacCentralEurope"};
        da = new String[]{"IBM01142", "IBM277", "IBM865", "ISO-8859-3", "ISO-8859-1", "windows-1252", "IBM850", "IBM1047", "IBM037", "ISO-8859-15", "IBM00858", "IBM01140", "IBM01148", "IBM500", "US-ASCII", "IBM437"};
        de = new String[]{"IBM01141", "IBM273", "ISO-8859-3", "ISO-8859-1", "windows-1252", "IBM850", "IBM1047", "IBM037", "IBM852", "IBM870", "ISO-8859-2", "windows-1250", "x-MacCentralEurope", "ISO-8859-15", "ISO-8859-4", "IBM00858", "IBM01140", "IBM01148", "IBM500", "US-ASCII", "IBM437"};
        el = new String[]{"IBM869", "ISO-8859-7", "windows-1253", "x-IBM737", "x-IBM875", "x-MacGreek"};
        en = new String[]{"ISO-8859-1", "windows-1252", "IBM850", "IBM1047", "IBM037", "IBM00858", "IBM01140", "IBM01148", "IBM500", "US-ASCII", "IBM437"};
        es = new String[]{"IBM01145", "IBM284", "ISO-8859-3", "ISO-8859-1", "windows-1252", "IBM850", "IBM1047", "IBM037", "ISO-8859-15", "IBM00858", "IBM01140", "IBM01148", "IBM500", "US-ASCII", "IBM437"};
        et = new String[]{"IBM775", "ISO-8859-13", "windows-1257", "x-IBM1112", "x-IBM922", "x-IBM1122", "x-IBM921", "ISO-8859-4"};
        fi = new String[]{"IBM01143", "IBM278", "ISO-8859-3", "x-MacRomania", "ISO-8859-1", "windows-1252", "IBM850", "IBM1047", "IBM037", "ISO-8859-15", "ISO-8859-4", "IBM00858", "IBM01140", "IBM01148", "IBM500", "US-ASCII", "IBM437"};
        fr = new String[]{"IBM01147", "IBM297", "IBM863", "ISO-8859-3", "ISO-8859-1", "windows-1252", "IBM850", "IBM1047", "IBM037", "ISO-8859-15", "IBM00858", "IBM01140", "IBM01148", "IBM500", "US-ASCII", "IBM437"};
        ga = new String[]{"IBM01146", "IBM285", "ISO-8859-3", "ISO-8859-1", "windows-1252", "IBM850", "IBM1047", "IBM037", "ISO-8859-15", "IBM00858", "IBM01140", "IBM01148", "IBM500", "US-ASCII", "IBM437"};
        hi = new String[]{"x-ISCII91", "IBM868", "IBM918", "x-IBM1006"};
        hr = new String[]{"x-MacCroatian", "IBM852", "IBM870", "ISO-8859-2", "windows-1250", "x-MacCentralEurope"};
        hu = new String[]{"IBM852", "IBM870", "ISO-8859-2", "windows-1250", "x-MacCentralEurope"};
        fo = new String[]{"IBM01149", "IBM861", "IBM871", "x-MacIceland", "ISO-8859-1", "windows-1252", "IBM850", "IBM1047", "IBM037", "ISO-8859-15", "ISO-8859-4", "IBM00858", "IBM01140", "IBM01148", "IBM500", "US-ASCII", "IBM437"};
        it = new String[]{"IBM01144", "IBM280", "ISO-8859-3", "ISO-8859-1", "windows-1252", "IBM850", "IBM1047", "IBM037", "ISO-8859-15", "IBM00858", "IBM01140", "IBM01148", "IBM500", "US-ASCII", "IBM437"};
        iw = new String[]{"IBM424", "IBM862", "ISO-8859-8", "windows-1255", "x-IBM856", "x-MacHebrew"};
        ja = new String[]{"EUC-JP", "IBM290", "ISO-2022-JP", "ISO-2022-JP-2", "JIS_X0201", "JIS_X0212-1990", "Shift_JIS", "windows-31j", "x-IBM300", "x-IBM33722", "x-IBM930", "x-IBM939", "x-IBM942", "x-IBM942C", "x-IBM943", "x-IBM943C", "x-JIS0208", "x-JISAutoDetect", "x-MS932_0213", "x-PCK", "x-SJIS_0213", "x-euc-jp-linux", "x-eucJP-Open", "x-windows-50220", "x-windows-50221", "x-windows-iso2022jp"};
        ko = new String[]{"EUC-KR", "ISO-2022-KR", "x-IBM1364", "x-IBM933", "x-IBM949", "x-IBM949C", "x-IBM970", "x-IBM833", "x-IBM834", "x-Johab", "x-windows-949"};
        lt = new String[]{"IBM775", "ISO-8859-13", "windows-1257", "x-IBM1112", "x-IBM921", "ISO-8859-4"};
        mt = new String[]{"ISO-8859-1", "windows-1252", "IBM850", "IBM1047", "IBM037", "ISO-8859-15", "IBM00858", "IBM01140", "IBM01148", "IBM500", "ISO-8859-3"};
        nl = new String[]{"ISO-8859-3", "ISO-8859-1", "windows-1252", "IBM850", "IBM1047", "IBM037", "ISO-8859-15", "ISO-8859-4", "IBM00858", "IBM01140", "IBM01148", "IBM500", "US-ASCII", "IBM437"};
        no = new String[]{"IBM01142", "IBM277", "IBM865", "ISO-8859-1", "windows-1252", "IBM850", "IBM1047", "IBM037", "ISO-8859-15", "IBM00858", "IBM01140", "IBM01148", "IBM500", "US-ASCII", "IBM437"};
        pl = new String[]{"IBM852", "IBM870", "ISO-8859-2", "windows-1250", "x-MacCentralEurope"};
        pt = new String[]{"IBM860", "ISO-8859-3", "ISO-8859-1", "windows-1252", "IBM850", "IBM1047", "IBM037", "ISO-8859-15", "IBM00858", "IBM01140", "IBM01148", "IBM500", "US-ASCII", "IBM437"};
        ro = new String[]{"x-MacRomania", "IBM852", "IBM870", "ISO-8859-2", "windows-1250", "x-MacCentralEurope", "ISO-8859-3", "ISO-8859-1", "windows-1252", "IBM850", "IBM1047", "IBM037", "ISO-8859-15", "IBM00858", "IBM01140", "IBM01148", "IBM500", "US-ASCII", "IBM437"};
        sl = new String[]{"IBM852", "IBM870", "ISO-8859-2", "windows-1250", "x-MacCentralEurope", "ISO-8859-4"};
        sq = new String[]{"ISO-8859-3", "ISO-8859-1", "windows-1252", "IBM850", "IBM1047", "IBM037", "ISO-8859-15", "IBM00858", "IBM01140", "IBM01148", "IBM500", "US-ASCII", "IBM437"};
        sv = new String[]{"IBM01143", "IBM278", "ISO-8859-3", "ISO-8859-1", "windows-1252", "IBM850", "IBM1047", "IBM037", "ISO-8859-15", "IBM00858", "IBM01140", "IBM01148", "IBM500", "US-ASCII", "IBM437"};
        th = new String[]{"IBM-Thai", "TIS-620", "x-windows-874", "x-IBM874", "x-MacThai", "x-iso-8859-11"};
        tr = new String[]{"IBM1026", "IBM857", "windows-1254", "x-MacTurkish", "ISO-8859-9", "ISO-8859-3"};
        vi = new String[]{"windows-1258"};
        zh = new String[]{"GB18030", "GB2312", "GBK", "x-ISO-2022-CN-GB", "ISO-2022-CN", "x-IBM1381", "x-IBM1383", "x-IBM935", "x-mswin-936"};
        zt = new String[]{"x-IBM948", "Big5", "Big5-HKSCS", "x-Big5-HKSCS-2001", "x-Big5-Solaris", "x-EUC-TW", "x-IBM937", "x-IBM950", "x-IBM964", "x-ISO-2022-CN-CNS", "x-MS950-HKSCS", "x-MS950-HKSCS-XP", "x-windows-950"};
        s_EncSession = new HashMap<String, Integer>();
        s_EncSession.put("utf-8", 20);
        s_EncSession.put("utf8", 20);
        s_EncSession.put("us-ascii", 28);
        s_EncSession.put("latin1", 29);
        s_EncSession.put("latin2", 30);
        s_EncSession.put("latin3", 31);
        s_EncSession.put("latin4", 32);
        s_EncSession.put("cyrillic", 33);
        s_EncSession.put("arabic", 34);
        s_EncSession.put("greek", 35);
        s_EncSession.put("hebrew", 36);
        s_EncSession.put("latin5", 37);
        s_EncSession.put("latin6", 38);
        s_EncSession.put("thai", 39);
        s_EncSession.put("latin9", 40);
        s_EncSession.put("pcoem437", 41);
        s_EncSession.put("pcoem850", 42);
        s_EncSession.put("pcoem852", 43);
        s_EncSession.put("pcoem857", 44);
        s_EncSession.put("pcoem858", 45);
        s_EncSession.put("pcoem862", 46);
        s_EncSession.put("pcoem864", 47);
        s_EncSession.put("pcoem865", 48);
        s_EncSession.put("pcoem866", 49);
        s_EncSession.put("pcoem869", 50);
        s_EncSession.put("pcoem874", 51);
        s_EncSession.put("pcoem921", 52);
        s_EncSession.put("pcoem922", 53);
        s_EncSession.put("pcoem1129", 54);
        s_EncSession.put("msdos720", 55);
        s_EncSession.put("msdos737", 56);
        s_EncSession.put("msdos775", 57);
        s_EncSession.put("pcoem860", 58);
        s_EncSession.put("pcoem863", 59);
        s_EncSession.put("wlatin2", 60);
        s_EncSession.put("wcyrillic", 61);
        s_EncSession.put("wlatin1", 62);
        s_EncSession.put("wgreek", 63);
        s_EncSession.put("wturkish", 64);
        s_EncSession.put("whebrew", 65);
        s_EncSession.put("warabic", 66);
        s_EncSession.put("wbaltic", 67);
        s_EncSession.put("wvietnamese", 68);
        s_EncSession.put("ebcdic037", 78);
        s_EncSession.put("ebcdic273", 79);
        s_EncSession.put("ebcdic277", 80);
        s_EncSession.put("ebcdic278", 81);
        s_EncSession.put("ebcdic280", 82);
        s_EncSession.put("ebcdic284", 83);
        s_EncSession.put("ebcdic285", 84);
        s_EncSession.put("ebcdic297", 85);
        s_EncSession.put("ebcdic424", 87);
        s_EncSession.put("ebcdic500", 88);
        s_EncSession.put("ebcdic838", 89);
        s_EncSession.put("ebcdic870", 90);
        s_EncSession.put("ebcdic875", 91);
        s_EncSession.put("ebcdic924", 93);
        s_EncSession.put("kz1048", 94);
        s_EncSession.put("ebcdic1025", 95);
        s_EncSession.put("ebcdic1026", 96);
        s_EncSession.put("ebcdic1047", 97);
        s_EncSession.put("ebcdic1112", 98);
        s_EncSession.put("ebcdic1122", 99);
        s_EncSession.put("ebcdic1130", 100);
        s_EncSession.put("open_ed-424", 102);
        s_EncSession.put("open_ed-838", 103);
        s_EncSession.put("open_ed-870", 104);
        s_EncSession.put("open_ed-875", 105);
        s_EncSession.put("open_ed-924", 106);
        s_EncSession.put("open_ed-1166", 107);
        s_EncSession.put("open_ed-1025", 108);
        s_EncSession.put("open_ed-1026", 109);
        s_EncSession.put("open_ed-1047", 110);
        s_EncSession.put("open_ed-1112", 111);
        s_EncSession.put("open_ed-1122", 112);
        s_EncSession.put("open_ed-1130", 113);
        s_EncSession.put("roman8", 114);
        s_EncSession.put("ibm-937", 117);
        s_EncSession.put("ms-950", 118);
        s_EncSession.put("euc-tw", 119);
        s_EncSession.put("hp15-tw", 120);
        s_EncSession.put("ibm-950", 122);
        s_EncSession.put("big5", 123);
        s_EncSession.put("ibm-935", 124);
        s_EncSession.put("euc-cn", 125);
        s_EncSession.put("ms-936", 126);
        s_EncSession.put("ibm-939", 129);
        s_EncSession.put("ibm-930", 130);
        s_EncSession.put("dec-jp", 133);
        s_EncSession.put("euc-jp", 134);
        s_EncSession.put("ms-932", 136);
        s_EncSession.put("ibm-942", 137);
        s_EncSession.put("shift-jis", 138);
        s_EncSession.put("ibm-933", 139);
        s_EncSession.put("euc-kr", 140);
        s_EncSession.put("ms-949", 141);
        s_EncSession.put("ibm-949", 142);
        s_EncSession.put("dec-tw", 159);
        s_EncSession.put("dec-cn", 160);
        s_EncSession.put("ebcdic275", 164);
        s_EncSession.put("open_ed-037", 173);
        s_EncSession.put("open_ed-273", 174);
        s_EncSession.put("open_ed-275", 175);
        s_EncSession.put("open_ed-277", 176);
        s_EncSession.put("open_ed-278", 177);
        s_EncSession.put("open_ed-280", 178);
        s_EncSession.put("open_ed-284", 179);
        s_EncSession.put("open_ed-285", 180);
        s_EncSession.put("open_ed-297", 181);
        s_EncSession.put("open_ed-500", 182);
        s_EncSession.put("ebcdic1140", 183);
        s_EncSession.put("ebcdic1141", 184);
        s_EncSession.put("ebcdic1142", 185);
        s_EncSession.put("ebcdic1143", 186);
        s_EncSession.put("ebcdic1144", 187);
        s_EncSession.put("ebcdic1145", 188);
        s_EncSession.put("ebcdic1146", 189);
        s_EncSession.put("ebcdic1147", 190);
        s_EncSession.put("ebcdic1148", 191);
        s_EncSession.put("open_ed-1140", 192);
        s_EncSession.put("open_ed-1141", 193);
        s_EncSession.put("open_ed-1142", 194);
        s_EncSession.put("open_ed-1143", 195);
        s_EncSession.put("open_ed-1144", 196);
        s_EncSession.put("open_ed-1145", 197);
        s_EncSession.put("open_ed-1146", 198);
        s_EncSession.put("open_ed-1147", 199);
        s_EncSession.put("open_ed-1148", 200);
        s_EncSession.put("ebcdic425", 201);
        s_EncSession.put("open_ed-425", 202);
        s_EncSession.put("ebcdic-any", 203);
        s_EncSession.put("any", 204);
        s_EncSession.put("ibm-939e", 206);
        s_EncSession.put("ebcdic1137", 209);
        s_EncSession.put("open_ed-1137", 210);
        s_EncSession.put("ebcdic1149", 211);
        s_EncSession.put("open_ed-1149", 212);
        s_EncSession.put("ebcdic1153", 213);
        s_EncSession.put("open_ed-1153", 214);
        s_EncSession.put("ebcdic1154", 215);
        s_EncSession.put("open_ed-1154", 216);
        s_EncSession.put("ebcdic1155", 217);
        s_EncSession.put("open_ed-1155", 218);
        s_EncSession.put("ebcdic1156", 219);
        s_EncSession.put("open_ed-1156", 220);
        s_EncSession.put("ebcdic1157", 221);
        s_EncSession.put("open_ed-1157", 222);
        s_EncSession.put("ebcdic1158", 223);
        s_EncSession.put("open_ed-1158", 224);
        s_EncSession.put("ebcdic905", 225);
        s_EncSession.put("open_ed-905", 226);
        s_EncSession.put("latin8", 227);
        s_EncSession.put("pciscii806", 228);
        s_EncSession.put("pc1098", 229);
        s_EncSession.put("ebcdic1160", 230);
        s_EncSession.put("open_ed-1160", 231);
        s_EncSession.put("ebcdic1164", 232);
        s_EncSession.put("open_ed-1164", 233);
        s_EncSession.put("open_ed-930", 234);
        s_EncSession.put("open_ed-933", 235);
        s_EncSession.put("open_ed-935", 236);
        s_EncSession.put("open_ed-937", 237);
        s_EncSession.put("open_ed-939", 238);
        s_EncSession.put("open_ed-939e", 239);
        s_EncSession.put("latin7", 242);
        s_EncSession.put("latin10", 243);
        s_EncOther = new HashMap<String, Integer>();
        s_EncOther.put("utf-16", 19);
        s_EncOther.put("utf-16be", 24);
        s_EncOther.put("utf-16le", 25);
        s_EncOther.put("utf-32be", 26);
        s_EncOther.put("utf-32le", 27);
        s_EncOther.put("aroman", 69);
        s_EncOther.put("aarabic", 70);
        s_EncOther.put("ahebrew", 71);
        s_EncOther.put("agreek", 72);
        s_EncOther.put("athai", 73);
        s_EncOther.put("aeasteuro", 74);
        s_EncOther.put("aturkish", 75);
        s_EncOther.put("aukrainian", 76);
        s_EncOther.put("ebcdic420", 86);
        s_EncOther.put("ebcdic880", 92);
        s_EncOther.put("open_ed-420", 101);
        s_EncOther.put("saslatin1", 115);
        s_EncOther.put("saslatin2", 116);
        s_EncOther.put("macos-2", 121);
        s_EncOther.put("macos-25", 127);
        s_EncOther.put("ibm-1381", 128);
        s_EncOther.put("fujitsu-jp", 131);
        s_EncOther.put("hitachi-jp", 132);
        s_EncOther.put("macos-1", 135);
        s_EncOther.put("macos-3", 143);
        s_EncOther.put("fujitsu-tw", 144);
        s_EncOther.put("fujitsu-cn", 145);
        s_EncOther.put("fujitsu-ko", 146);
        s_EncOther.put("hitachi-tw", 147);
        s_EncOther.put("hitachi-cn", 148);
        s_EncOther.put("hitachi-ko", 149);
        s_EncOther.put("hitsas-tw", 150);
        s_EncOther.put("hitsas-cn", 151);
        s_EncOther.put("hitsas-jp", 152);
        s_EncOther.put("hitsas-ko", 153);
        s_EncOther.put("hitsas-kana", 154);
        s_EncOther.put("nec-jp", 155);
        s_EncOther.put("nec-kana", 156);
        s_EncOther.put("pcjis", 157);
        s_EncOther.put("jis-7", 158);
        s_EncOther.put("utf-e", 161);
        s_EncOther.put("ucsu", 162);
        s_EncOther.put("aiceland", 163);
        s_EncOther.put("fujitsu-kana", 165);
        s_EncOther.put("hitachi-kana", 166);
        s_EncOther.put("iso2022jp", 167);
        s_EncOther.put("iso2022kr", 168);
        s_EncOther.put("iso2022cngb", 169);
        s_EncOther.put("sas1047", 170);
        s_EncOther.put("iso2022cncns", 172);
        s_EncOther.put("gb18030", 205);
        s_EncOther.put("ebcdic1097", 207);
        s_EncOther.put("open_ed-1097", 208);
        s_EncOther.put("ibm-930e", 240);
        s_EncOther.put("open_ed-930e", 241);
        s_EncOther.put("teralatin", 244);
        s_EncOther.put("acroatian", 245);
        s_EncOther.put("acyrillic", 246);
        s_EncOther.put("aromania", 247);
        s_EncOther.put("shift-jis04", 248);
        s_mapCei2Java = new HashMap<Integer, String>();
        s_mapCei2Java.put(19, "UTF-16");
        s_mapCei2Java.put(20, "UTF8");
        s_mapCei2Java.put(24, "UnicodeBigUnmarked");
        s_mapCei2Java.put(25, "UnicodeLittleUnmarked");
        s_mapCei2Java.put(26, "UTF_32BE");
        s_mapCei2Java.put(27, "UTF_32LE");
        s_mapCei2Java.put(28, "ASCII");
        s_mapCei2Java.put(29, "ISO8859_1");
        s_mapCei2Java.put(30, "ISO8859_2");
        s_mapCei2Java.put(31, "ISO8859_3");
        s_mapCei2Java.put(32, "ISO8859_4");
        s_mapCei2Java.put(33, "ISO8859_5");
        s_mapCei2Java.put(34, "ISO8859_6");
        s_mapCei2Java.put(35, "ISO8859_7");
        s_mapCei2Java.put(36, "ISO8859_8");
        s_mapCei2Java.put(37, "ISO8859_9");
        s_mapCei2Java.put(39, "TIS620");
        s_mapCei2Java.put(40, "ISO8859_15");
        s_mapCei2Java.put(41, "Cp437");
        s_mapCei2Java.put(42, "Cp850");
        s_mapCei2Java.put(43, "Cp852");
        s_mapCei2Java.put(44, "Cp857");
        s_mapCei2Java.put(45, "Cp858");
        s_mapCei2Java.put(46, "Cp862");
        s_mapCei2Java.put(47, "Cp864");
        s_mapCei2Java.put(48, "Cp865");
        s_mapCei2Java.put(49, "Cp866");
        s_mapCei2Java.put(50, "Cp869");
        s_mapCei2Java.put(51, "Cp874");
        s_mapCei2Java.put(52, "Cp921");
        s_mapCei2Java.put(53, "Cp922");
        s_mapCei2Java.put(56, "Cp737");
        s_mapCei2Java.put(57, "Cp775");
        s_mapCei2Java.put(58, "Cp860");
        s_mapCei2Java.put(59, "Cp863");
        s_mapCei2Java.put(60, "Cp1250");
        s_mapCei2Java.put(61, "Cp1251");
        s_mapCei2Java.put(62, "Cp1252");
        s_mapCei2Java.put(63, "Cp1253");
        s_mapCei2Java.put(64, "Cp1254");
        s_mapCei2Java.put(65, "Cp1255");
        s_mapCei2Java.put(66, "Cp1256");
        s_mapCei2Java.put(67, "Cp1257");
        s_mapCei2Java.put(68, "Cp1258");
        s_mapCei2Java.put(69, "MacRoman");
        s_mapCei2Java.put(70, "MacArabic");
        s_mapCei2Java.put(71, "MacHebrew");
        s_mapCei2Java.put(72, "MacGreek");
        s_mapCei2Java.put(73, "MacThai");
        s_mapCei2Java.put(74, "MacCentralEurope");
        s_mapCei2Java.put(75, "MacTurkish");
        s_mapCei2Java.put(76, "MacUkraine");
        s_mapCei2Java.put(78, "Cp037");
        s_mapCei2Java.put(79, "Cp273");
        s_mapCei2Java.put(80, "Cp277");
        s_mapCei2Java.put(81, "Cp278");
        s_mapCei2Java.put(82, "Cp280");
        s_mapCei2Java.put(83, "Cp284");
        s_mapCei2Java.put(84, "Cp285");
        s_mapCei2Java.put(85, "Cp297");
        s_mapCei2Java.put(86, "Cp420");
        s_mapCei2Java.put(87, "Cp424");
        s_mapCei2Java.put(88, "Cp500");
        s_mapCei2Java.put(89, "Cp838");
        s_mapCei2Java.put(90, "Cp870");
        s_mapCei2Java.put(91, "Cp875");
        s_mapCei2Java.put(95, "Cp1025");
        s_mapCei2Java.put(96, "Cp1026");
        s_mapCei2Java.put(97, "Cp1047");
        s_mapCei2Java.put(98, "Cp1112");
        s_mapCei2Java.put(99, "Cp1122");
        s_mapCei2Java.put(101, "Cp420");
        s_mapCei2Java.put(102, "Cp424");
        s_mapCei2Java.put(103, "Cp838");
        s_mapCei2Java.put(104, "Cp870");
        s_mapCei2Java.put(105, "Cp875");
        s_mapCei2Java.put(108, "Cp1025");
        s_mapCei2Java.put(109, "Cp1026");
        s_mapCei2Java.put(110, "Cp1047");
        s_mapCei2Java.put(111, "Cp1112");
        s_mapCei2Java.put(112, "Cp1122");
        s_mapCei2Java.put(117, "Cp937");
        s_mapCei2Java.put(118, "MS950_HKSCS");
        s_mapCei2Java.put(119, "EUC_TW");
        s_mapCei2Java.put(121, "MS950_HKSCS");
        s_mapCei2Java.put(122, "Big5_HKSCS");
        s_mapCei2Java.put(123, "Big5_HKSCS");
        s_mapCei2Java.put(124, "Cp935");
        s_mapCei2Java.put(125, "GBK");
        s_mapCei2Java.put(126, "GBK");
        s_mapCei2Java.put(127, "GBK");
        s_mapCei2Java.put(128, "Cp1381");
        s_mapCei2Java.put(129, "Cp939");
        s_mapCei2Java.put(130, "Cp930");
        s_mapCei2Java.put(133, "EUC_JP");
        s_mapCei2Java.put(134, "EUC_JP_Solaris");
        s_mapCei2Java.put(135, "SJIS");
        s_mapCei2Java.put(136, "MS932");
        s_mapCei2Java.put(137, "Cp942");
        s_mapCei2Java.put(138, "MS932");
        s_mapCei2Java.put(139, "Cp933");
        s_mapCei2Java.put(140, "EUC_KR");
        s_mapCei2Java.put(141, "MS949");
        s_mapCei2Java.put(142, "Cp949");
        s_mapCei2Java.put(143, "EUC_KR");
        s_mapCei2Java.put(159, "EUC_TW");
        s_mapCei2Java.put(160, "GBK");
        s_mapCei2Java.put(163, "MacIceland");
        s_mapCei2Java.put(167, "ISO2022JP");
        s_mapCei2Java.put(168, "ISO2022KR");
        s_mapCei2Java.put(169, "ISO2022CN_GB");
        s_mapCei2Java.put(172, "ISO2022CN_CNS");
        s_mapCei2Java.put(173, "Cp037");
        s_mapCei2Java.put(174, "Cp273");
        s_mapCei2Java.put(176, "Cp277");
        s_mapCei2Java.put(177, "Cp278");
        s_mapCei2Java.put(178, "Cp280");
        s_mapCei2Java.put(179, "Cp284");
        s_mapCei2Java.put(180, "Cp285");
        s_mapCei2Java.put(181, "Cp297");
        s_mapCei2Java.put(182, "Cp500");
        s_mapCei2Java.put(183, "Cp1140");
        s_mapCei2Java.put(184, "Cp1141");
        s_mapCei2Java.put(185, "Cp1142");
        s_mapCei2Java.put(186, "Cp1143");
        s_mapCei2Java.put(187, "Cp1144");
        s_mapCei2Java.put(188, "Cp1145");
        s_mapCei2Java.put(189, "Cp1146");
        s_mapCei2Java.put(190, "Cp1147");
        s_mapCei2Java.put(191, "Cp1148");
        s_mapCei2Java.put(192, "Cp1140");
        s_mapCei2Java.put(193, "Cp1141");
        s_mapCei2Java.put(194, "Cp1142");
        s_mapCei2Java.put(195, "Cp1143");
        s_mapCei2Java.put(196, "Cp1144");
        s_mapCei2Java.put(197, "Cp1145");
        s_mapCei2Java.put(198, "Cp1146");
        s_mapCei2Java.put(199, "Cp1147");
        s_mapCei2Java.put(200, "Cp1148");
        s_mapCei2Java.put(205, "GB18030");
        s_mapCei2Java.put(206, "Cp939");
        s_mapCei2Java.put(207, "Cp1097");
        s_mapCei2Java.put(208, "Cp1097");
        s_mapCei2Java.put(211, "Cp1149");
        s_mapCei2Java.put(212, "Cp1149");
        s_mapCei2Java.put(228, "ISCII91");
        s_mapCei2Java.put(229, "Cp1098");
        s_mapCei2Java.put(234, "Cp930");
        s_mapCei2Java.put(235, "Cp933");
        s_mapCei2Java.put(236, "Cp935");
        s_mapCei2Java.put(237, "Cp937");
        s_mapCei2Java.put(238, "Cp939");
        s_mapCei2Java.put(239, "Cp939");
        s_mapCei2Java.put(240, "Cp930");
        s_mapCei2Java.put(241, "Cp930");
        s_mapCei2Java.put(242, "ISO8859_13");
        s_mapCei2Java.put(245, "MacCroatian");
        s_mapCei2Java.put(246, "MacCyrillic");
        s_mapCei2Java.put(247, "MacRomania");
        s_mapCei2Flex = new HashMap<Integer, String>();
        s_mapCei2Flex.put(19, "unicode");
        s_mapCei2Flex.put(20, "utf-8");
        s_mapCei2Flex.put(24, "unicodeFFFE");
        s_mapCei2Flex.put(25, "unicode");
        s_mapCei2Flex.put(28, "us-ascii");
        s_mapCei2Flex.put(29, "iso-8859-1");
        s_mapCei2Flex.put(30, "iso-8859-2");
        s_mapCei2Flex.put(31, "iso-8859-3");
        s_mapCei2Flex.put(32, "iso-8859-4");
        s_mapCei2Flex.put(33, "iso-8859-5");
        s_mapCei2Flex.put(34, "iso-8859-6");
        s_mapCei2Flex.put(35, "iso-8859-7");
        s_mapCei2Flex.put(36, "iso-8859-8");
        s_mapCei2Flex.put(37, "iso-8859-9");
        s_mapCei2Flex.put(39, "iso-8859-11");
        s_mapCei2Flex.put(40, "iso-8859-15");
        s_mapCei2Flex.put(41, "IBM437");
        s_mapCei2Flex.put(42, "ibm850");
        s_mapCei2Flex.put(43, "ibm852");
        s_mapCei2Flex.put(44, "ibm857");
        s_mapCei2Flex.put(46, "DOS-862");
        s_mapCei2Flex.put(49, "cp866");
        s_mapCei2Flex.put(50, "ibm869");
        s_mapCei2Flex.put(51, "windows-874");
        s_mapCei2Flex.put(55, "dos-720");
        s_mapCei2Flex.put(56, "ibm737");
        s_mapCei2Flex.put(57, "ibm775");
        s_mapCei2Flex.put(60, "windows-1250");
        s_mapCei2Flex.put(61, "windows-1251");
        s_mapCei2Flex.put(62, "Windows-1252");
        s_mapCei2Flex.put(63, "windows-1253");
        s_mapCei2Flex.put(64, "windows-1254");
        s_mapCei2Flex.put(65, "windows-1255");
        s_mapCei2Flex.put(66, "windows-1256");
        s_mapCei2Flex.put(67, "windows-1257");
        s_mapCei2Flex.put(68, "windows-1258");
        s_mapCei2Flex.put(69, "macintosh");
        s_mapCei2Flex.put(70, "x-mac-arabic");
        s_mapCei2Flex.put(71, "x-mac-hebrew");
        s_mapCei2Flex.put(72, "x-mac-greek");
        s_mapCei2Flex.put(74, "x-mac-ce");
        s_mapCei2Flex.put(75, "x-mac-turkish");
        s_mapCei2Flex.put(78, "ebcdic-cp-us");
        s_mapCei2Flex.put(79, "x-EBCDIC-Germany");
        s_mapCei2Flex.put(80, "x-EBCDIC-DenmarkNorway");
        s_mapCei2Flex.put(81, "x-EBCDIC-FinlandSweden");
        s_mapCei2Flex.put(82, "x-EBCDIC-Italy");
        s_mapCei2Flex.put(83, "X-EBCDIC-Spain");
        s_mapCei2Flex.put(84, "x-EBCDIC-UK");
        s_mapCei2Flex.put(85, "X-EBCDIC-France");
        s_mapCei2Flex.put(86, "x-EBCDIC-Arabic");
        s_mapCei2Flex.put(87, "x-EBCDIC-Hebrew");
        s_mapCei2Flex.put(89, "x-EBCDIC-Thai");
        s_mapCei2Flex.put(90, "CP870");
        s_mapCei2Flex.put(91, "x-EBCDIC-GreekModern");
        s_mapCei2Flex.put(92, "x-EBCDIC-CyrillicRussian");
        s_mapCei2Flex.put(95, "x-EBCDIC-CyrillicSerbianBulgarian");
        s_mapCei2Flex.put(96, "CP1026");
        s_mapCei2Flex.put(101, "x-EBCDIC-Arabic");
        s_mapCei2Flex.put(102, "x-EBCDIC-Hebrew");
        s_mapCei2Flex.put(103, "x-EBCDIC-Thai");
        s_mapCei2Flex.put(104, "CP870");
        s_mapCei2Flex.put(105, "x-EBCDIC-GreekModern");
        s_mapCei2Flex.put(108, "x-EBCDIC-CyrillicSerbianBulgarian");
        s_mapCei2Flex.put(109, "CP1026");
        s_mapCei2Flex.put(117, "x-EBCDIC-TraditionalChinese");
        s_mapCei2Flex.put(118, "big5");
        s_mapCei2Flex.put(119, "x-Chinese-CNS");
        s_mapCei2Flex.put(121, "x-mac-chinesesimp");
        s_mapCei2Flex.put(122, "big5");
        s_mapCei2Flex.put(123, "big5");
        s_mapCei2Flex.put(124, "x-EBCDIC-SimplifiedChinese");
        s_mapCei2Flex.put(125, "EUC-CN");
        s_mapCei2Flex.put(126, "gb2312");
        s_mapCei2Flex.put(127, "x-mac-chinesetrad");
        s_mapCei2Flex.put(128, "gb2312");
        s_mapCei2Flex.put(129, "x-EBCDIC-JapaneseAndJapaneseLatin");
        s_mapCei2Flex.put(130, "x-EBCDIC-JapaneseAndKana");
        s_mapCei2Flex.put(134, "euc-jp");
        s_mapCei2Flex.put(135, "x-mac-japanese");
        s_mapCei2Flex.put(136, "x-ms-cp932");
        s_mapCei2Flex.put(137, "shift_jis");
        s_mapCei2Flex.put(138, "shift_jis");
        s_mapCei2Flex.put(139, "x-EBCDIC-KoreanAndKoreanExtended");
        s_mapCei2Flex.put(140, "euc-kr");
        s_mapCei2Flex.put(141, "ks_c_5601-1987");
        s_mapCei2Flex.put(142, "ks_c_5601-1987");
        s_mapCei2Flex.put(143, "x-mac-korean");
        s_mapCei2Flex.put(163, "x-mac-icelandic");
        s_mapCei2Flex.put(167, "iso-2022-jp");
        s_mapCei2Flex.put(168, "iso-2022-kr");
        s_mapCei2Flex.put(173, "ebcdic-cp-us");
        s_mapCei2Flex.put(174, "x-EBCDIC-Germany");
        s_mapCei2Flex.put(176, "x-EBCDIC-DenmarkNorway");
        s_mapCei2Flex.put(177, "x-EBCDIC-FinlandSweden");
        s_mapCei2Flex.put(178, "x-EBCDIC-Italy");
        s_mapCei2Flex.put(179, "X-EBCDIC-Spain");
        s_mapCei2Flex.put(180, "x-EBCDIC-UK");
        s_mapCei2Flex.put(181, "X-EBCDIC-France");
        s_mapCei2Flex.put(183, "x-ebcdic-cp-us-euro");
        s_mapCei2Flex.put(184, "x-ebcdic-germany-euro");
        s_mapCei2Flex.put(185, "x-ebcdic-denmarknorway-euro");
        s_mapCei2Flex.put(186, "x-ebcdic-finlandsweden-euro");
        s_mapCei2Flex.put(187, "x-ebcdic-italy-euro");
        s_mapCei2Flex.put(188, "x-ebcdic-spain-euro");
        s_mapCei2Flex.put(189, "x-ebcdic-uk-euro");
        s_mapCei2Flex.put(190, "x-ebcdic-france-euro");
        s_mapCei2Flex.put(191, "x-ebcdic-international-euro");
        s_mapCei2Flex.put(192, "x-ebcdic-cp-us-euro");
        s_mapCei2Flex.put(193, "x-ebcdic-germany-euro");
        s_mapCei2Flex.put(194, "x-ebcdic-denmarknorway-euro");
        s_mapCei2Flex.put(195, "x-ebcdic-finlandsweden-euro");
        s_mapCei2Flex.put(196, "x-ebcdic-italy-euro");
        s_mapCei2Flex.put(197, "x-ebcdic-spain-euro");
        s_mapCei2Flex.put(198, "x-ebcdic-uk-euro");
        s_mapCei2Flex.put(199, "x-ebcdic-france-euro");
        s_mapCei2Flex.put(200, "x-ebcdic-international-euro");
        s_mapCei2Flex.put(205, "gb18030");
        s_mapCei2Flex.put(206, "x-EBCDIC-JapaneseAndJapaneseLatin");
        s_mapCei2Flex.put(211, "x-ebcdic-icelandic-euro");
        s_mapCei2Flex.put(212, "x-ebcdic-icelandic-euro");
        s_mapCei2Flex.put(225, "x-EBCDIC-Turkish");
        s_mapCei2Flex.put(226, "x-EBCDIC-Turkish");
        s_mapCei2Flex.put(234, "x-EBCDIC-JapaneseAndKana");
        s_mapCei2Flex.put(235, "x-EBCDIC-KoreanAndKoreanExtended");
        s_mapCei2Flex.put(236, "x-EBCDIC-SimplifiedChinese");
        s_mapCei2Flex.put(237, "x-EBCDIC-TraditionalChinese");
        s_mapCei2Flex.put(238, "x-EBCDIC-JapaneseAndJapaneseLatin");
        s_mapCei2Flex.put(239, "x-EBCDIC-JapaneseAndJapaneseLatin");
        s_mapCei2Flex.put(240, "x-EBCDIC-JapaneseAndKana");
        s_mapCei2Flex.put(241, "x-EBCDIC-JapaneseAndKana");
        s_mapCei2Flex.put(246, "x-mac-cyrillic");
        s_mapJava2Flex = new HashMap<String, String>();
        s_mapJava2Flex.put("euc_tw", "x-Chinese-CNS");
        s_mapJava2Flex.put("ascii", "us-ascii");
        s_mapJava2Flex.put("big5", "big5");
        s_mapJava2Flex.put("big5_hkscs", "big5");
        s_mapJava2Flex.put("cp037", "ebcdic-cp-us");
        s_mapJava2Flex.put("cp1025", "x-EBCDIC-CyrillicSerbianBulgarian");
        s_mapJava2Flex.put("cp1026", "CP1026");
        s_mapJava2Flex.put("cp1140", "x-ebcdic-cp-us-euro");
        s_mapJava2Flex.put("cp1141", "x-ebcdic-germany-euro");
        s_mapJava2Flex.put("cp1142", "x-ebcdic-denmarknorway-euro");
        s_mapJava2Flex.put("cp1143", "x-ebcdic-finlandsweden-euro");
        s_mapJava2Flex.put("cp1144", "x-ebcdic-italy-euro");
        s_mapJava2Flex.put("cp1145", "x-ebcdic-spain-euro");
        s_mapJava2Flex.put("cp1146", "x-ebcdic-uk-euro");
        s_mapJava2Flex.put("cp1147", "x-ebcdic-france-euro");
        s_mapJava2Flex.put("cp1148", "x-ebcdic-international-euro");
        s_mapJava2Flex.put("cp1149", "x-ebcdic-icelandic-euro");
        s_mapJava2Flex.put("cp1250", "windows-1250");
        s_mapJava2Flex.put("cp1251", "windows-1251");
        s_mapJava2Flex.put("cp1252", "Windows-1252");
        s_mapJava2Flex.put("cp1253", "windows-1253");
        s_mapJava2Flex.put("cp1254", "windows-1254");
        s_mapJava2Flex.put("cp1255", "windows-1255");
        s_mapJava2Flex.put("cp1256", "windows-1256");
        s_mapJava2Flex.put("cp1257", "windows-1257");
        s_mapJava2Flex.put("cp1258", "windows-1258");
        s_mapJava2Flex.put("cp1381", "gb2312");
        s_mapJava2Flex.put("cp273", "x-EBCDIC-Germany");
        s_mapJava2Flex.put("cp277", "x-EBCDIC-DenmarkNorway");
        s_mapJava2Flex.put("cp278", "x-EBCDIC-FinlandSweden");
        s_mapJava2Flex.put("cp280", "x-EBCDIC-Italy");
        s_mapJava2Flex.put("cp284", "X-EBCDIC-Spain");
        s_mapJava2Flex.put("cp285", "x-EBCDIC-UK");
        s_mapJava2Flex.put("cp297", "X-EBCDIC-France");
        s_mapJava2Flex.put("cp420", "x-EBCDIC-Arabic");
        s_mapJava2Flex.put("cp424", "x-EBCDIC-Hebrew");
        s_mapJava2Flex.put("cp437", "IBM437");
        s_mapJava2Flex.put("cp737", "ibm737");
        s_mapJava2Flex.put("cp775", "ibm775");
        s_mapJava2Flex.put("cp838", "x-EBCDIC-Thai");
        s_mapJava2Flex.put("cp850", "ibm850");
        s_mapJava2Flex.put("cp852", "ibm852");
        s_mapJava2Flex.put("cp857", "ibm857");
        s_mapJava2Flex.put("cp861", "ibm861");
        s_mapJava2Flex.put("cp862", "DOS-862");
        s_mapJava2Flex.put("cp866", "cp866");
        s_mapJava2Flex.put("cp869", "ibm869");
        s_mapJava2Flex.put("cp870", "CP870");
        s_mapJava2Flex.put("cp871", "x-EBCDIC-Icelandic");
        s_mapJava2Flex.put("cp874", "windows-874");
        s_mapJava2Flex.put("cp875", "x-EBCDIC-GreekModern");
        s_mapJava2Flex.put("cp930", "x-EBCDIC-JapaneseAndKana");
        s_mapJava2Flex.put("cp933", "x-EBCDIC-KoreanAndKoreanExtended");
        s_mapJava2Flex.put("cp935", "x-EBCDIC-SimplifiedChinese");
        s_mapJava2Flex.put("cp937", "x-EBCDIC-TraditionalChinese");
        s_mapJava2Flex.put("cp939", "x-EBCDIC-JapaneseAndJapaneseLatin");
        s_mapJava2Flex.put("cp942", "shift_jis");
        s_mapJava2Flex.put("cp949", "ks_c_5601-1987");
        s_mapJava2Flex.put("euc_cn", "EUC-CN");
        s_mapJava2Flex.put("euc_jp", "euc-jp");
        s_mapJava2Flex.put("euc_jp_solaris", "euc-jp");
        s_mapJava2Flex.put("euc_kr", "euc-kr");
        s_mapJava2Flex.put("gb18030", "gb18030");
        s_mapJava2Flex.put("gbk", "GBK");
        s_mapJava2Flex.put("iso2022jp", "iso-2022-jp");
        s_mapJava2Flex.put("iso2022kr", "iso-2022-kr");
        s_mapJava2Flex.put("iso8859_1", "iso-8859-1");
        s_mapJava2Flex.put("iso8859_15", "iso-8859-15");
        s_mapJava2Flex.put("iso8859_2", "iso-8859-2");
        s_mapJava2Flex.put("iso8859_3", "iso-8859-3");
        s_mapJava2Flex.put("iso8859_4", "iso-8859-4");
        s_mapJava2Flex.put("iso8859_5", "iso-8859-5");
        s_mapJava2Flex.put("iso8859_6", "iso-8859-6");
        s_mapJava2Flex.put("iso8859_7", "iso-8859-7");
        s_mapJava2Flex.put("iso8859_8", "iso-8859-8");
        s_mapJava2Flex.put("iso8859_9", "iso-8859-9");
        s_mapJava2Flex.put("koi8_r", "koi8-r");
        s_mapJava2Flex.put("koi8_u", "koi8-u");
        s_mapJava2Flex.put("ms874", "windows-874");
        s_mapJava2Flex.put("ms932", "x-ms-cp932");
        s_mapJava2Flex.put("ms936", "gb2312");
        s_mapJava2Flex.put("ms949", "ks_c_5601-1987");
        s_mapJava2Flex.put("ms950_hkscs", "big5");
        s_mapJava2Flex.put("macarabic", "x-mac-arabic");
        s_mapJava2Flex.put("maccentraleurope", "x-mac-ce");
        s_mapJava2Flex.put("maccyrillic", "x-mac-cyrillic");
        s_mapJava2Flex.put("macgreek", "x-mac-greek");
        s_mapJava2Flex.put("machebrew", "x-mac-hebrew");
        s_mapJava2Flex.put("maciceland", "x-mac-icelandic");
        s_mapJava2Flex.put("macroman", "macintosh");
        s_mapJava2Flex.put("macturkish", "x-mac-turkish");
        s_mapJava2Flex.put("sjis", "shift_jis");
        s_mapJava2Flex.put("tis620", "iso-8859-11");
        s_mapJava2Flex.put("utf-16", "unicode");
        s_mapJava2Flex.put("utf8", "utf-8");
        s_mapJava2Flex.put("unicodebig", "unicodeFFFE");
        s_mapJava2Flex.put("unicodebigunmarked", "unicodeFFFE");
        s_mapJava2Flex.put("unicodelittleunmarked", "unicode");
        s_mapJava2Flex.put("x-johab", "Johab");
        s_maxCharLen = new HashMap<String, Integer>();
        s_maxCharLen.put("EUC-JP", 2);
        s_maxCharLen.put("UTF-8", 4);
        s_maxCharLen.put("GBK", 2);
        s_maxCharLen.put("ISO-2022-KR", 4);
        s_maxCharLen.put("x-EUC-TW", 2);
        s_maxCharLen.put("x-eucJP-Open", 2);
        s_maxCharLen.put("x-ISCII91", 1);
        s_maxCharLen.put("x-ISO-2022-CN-CNS", 4);
        s_maxCharLen.put("x-ISO-2022-CN-GB", 4);
        s_maxCharLen.put("x-IBM930", 4);
        s_maxCharLen.put("x-IBM933", 4);
        s_maxCharLen.put("x-IBM935", 4);
        s_maxCharLen.put("x-IBM937", 4);
        s_maxCharLen.put("x-IBM939", 4);
        s_maxCharLen.put("X-UTF-32BE-BOM", 4);
        s_maxCharLen.put("X-UTF-32LE-BOM", 4);
        s_EncodingFamily = new HashMap<String, String[]>();
        s_EncodingFamily.put("ar", ar);
        s_EncodingFamily.put("be", be);
        s_EncodingFamily.put("bg", be);
        s_EncodingFamily.put("ca", ca);
        s_EncodingFamily.put("cs", cs);
        s_EncodingFamily.put("da", da);
        s_EncodingFamily.put("de", de);
        s_EncodingFamily.put("el", el);
        s_EncodingFamily.put("en", en);
        s_EncodingFamily.put("es", es);
        s_EncodingFamily.put("et", et);
        s_EncodingFamily.put("fi", fi);
        s_EncodingFamily.put("fo", fo);
        s_EncodingFamily.put("fr", fr);
        s_EncodingFamily.put("ga", ga);
        s_EncodingFamily.put("hi", hi);
        s_EncodingFamily.put("hr", hr);
        s_EncodingFamily.put("hu", hu);
        s_EncodingFamily.put("in", en);
        s_EncodingFamily.put("is", fo);
        s_EncodingFamily.put("it", it);
        s_EncodingFamily.put("iw", iw);
        s_EncodingFamily.put("ja", ja);
        s_EncodingFamily.put("ko", ko);
        s_EncodingFamily.put("lt", lt);
        s_EncodingFamily.put("lv", lt);
        s_EncodingFamily.put("mk", be);
        s_EncodingFamily.put("ms", en);
        s_EncodingFamily.put("mt", mt);
        s_EncodingFamily.put("nl", nl);
        s_EncodingFamily.put("no", no);
        s_EncodingFamily.put("pl", pl);
        s_EncodingFamily.put("pt", pt);
        s_EncodingFamily.put("ro", ro);
        s_EncodingFamily.put("ru", be);
        s_EncodingFamily.put("sk", cs);
        s_EncodingFamily.put("sl", sl);
        s_EncodingFamily.put("sq", sq);
        s_EncodingFamily.put("sr", hr);
        s_EncodingFamily.put("sv", sv);
        s_EncodingFamily.put("th", th);
        s_EncodingFamily.put("tr", tr);
        s_EncodingFamily.put("uk", be);
        s_EncodingFamily.put("vi", vi);
        s_EncodingFamily.put("zh", zh);
        s_EncodingFamily.put("zt", zt);
    }
}

