/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.text.QuarterDateTime;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormatEntry;
import com.sas.text.SASFormatInfo;
import com.sas.text.SingleEntry;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

class DateTimeValue
extends SASDateTimeFormat {
    private static Object[] dateTimeValueFormats;

    protected DateTimeValue() {
    }

    @Override
    public StringBuffer format(Date value) {
        return this.format(this.javaDateToSASDateTime(value.getTime(), this.getTimeZone()));
    }

    @Override
    public StringBuffer format(double date) {
        StringBuffer result = null;
        result = this.checkSASDateLimits(date);
        if (null != result) {
            return result;
        }
        double rdate = this.round(date, this.info.isDecimalWidthSupported() ? this.info.getDValue() : 0);
        result = this.info.baseFormat.equals("NLDATMWN") || this.info.baseFormat.equals("NLDATMMN") || this.info.baseFormat.equals("NLDATMAP") || this.info.baseFormat.equals("NLDATMW") || this.info.baseFormat.equals("NLDATMYM") || this.info.baseFormat.equals("NLDATMMD") || this.info.baseFormat.equals("NLDATML") || this.info.baseFormat.equals("NLDATMM") || this.info.baseFormat.equals("NLDATMS") ? this.formatbest(this.SASDateTimeToJavaDate(rdate, this.getTimeZone())) : (this.info.baseFormat.equals("NLDATMYQ") || this.info.baseFormat.equals("NLDATMYQL") || this.info.baseFormat.equals("NLDATMYQM") ? this.formatValueWithQuarter(this.SASDateTimeToJavaDate(date, this.getTimeZone()), false) : (this.info.baseFormat.equals("NLDATMYQS") ? this.qtr_order(this.SASDateTimeToJavaDate(date, this.getTimeZone()), false) : (this.info.baseFormat.equals("NLDATMYW") ? this.formatValueWithWeek(this.SASDateTimeToJavaDate(date, this.getTimeZone())) : this.formatValue(this.SASDateTimeToJavaDate(rdate, this.getTimeZone()), false))));
        if (this.info.isDecimalWidthSupported()) {
            int width = this.info.getWidth();
            if (!this.info.getEntry().isUniform() && width > this.info.getDefaultWidth() || this.info.getEntry().isUniform() && width > result.length() + this.info.getDValue()) {
                int dvalue = this.info.getDValue();
                if (result.length() + dvalue + 1 > width) {
                    dvalue = width - (result.length() + 1);
                    rdate = this.round(date, dvalue);
                    result = this.formatValue(this.SASDateTimeToJavaDate(rdate, this.getTimeZone()), false);
                }
                if (dvalue > 0) {
                    double v2 = Math.floor(rdate);
                    String decimal = String.valueOf(v2 = this.round(rdate - v2, dvalue));
                    int startAt = decimal.indexOf(46);
                    if (startAt != -1) {
                        int insertIndex;
                        if (dvalue < (decimal = decimal.substring(startAt + 1, decimal.length())).length()) {
                            decimal = decimal.substring(0, dvalue);
                        }
                        for (insertIndex = result.length() - 1; insertIndex > -1 && !Character.isDigit(result.charAt(insertIndex)); --insertIndex) {
                        }
                        if (insertIndex > -1) {
                            result.insert(insertIndex + 1, "." + decimal);
                        }
                        this.insertTrailingZeros(result, dvalue - decimal.length());
                    }
                }
            }
        }
        if (result.length() > this.info.getWidth() && this.info.baseFormat.startsWith("NLDATM")) {
            result.setLength(this.info.getWidth());
        }
        if (this.info.baseFormat.equals("NLDATMYW")) {
            this.insertTrailingWhitespaces(result);
        } else {
            this.insertLeadingBlanks(result);
        }
        return result;
    }

    @Override
    protected void init() {
        this.info = (SASFormatInfo)this.formatInfo;
        this.formatter = this.info.isPattern() ? ((this.info.getBaseFormat().equals("DATETIME") || this.info.getBaseFormat().endsWith("DFDT")) && this.info.getWidth() - 16 - (this.info.getDValue() + 1) >= 2 ? new SimpleDateFormat("ddMMMyyyy:HH:mm:ss", new DateFormatSymbols(this.info.getFormatLocale())) : (this.info.getBaseFormat().equals("DATEAMPM") && this.info.getWidth() - 19 - (this.info.isDecimalWidthSupported() ? this.info.getDValue() + 1 : 0) >= 2 ? new SimpleDateFormat("ddMMMyyyy:hh:mm:ss a", new DateFormatSymbols(this.info.getFormatLocale())) : (this.info.getBaseFormat().startsWith("EUR") && !this.isEURformatLocale() ? new SimpleDateFormat(this.info.getPattern(), new DateFormatSymbols(Locale.US)) : (this.info.getBaseFormat().startsWith("NLDATMYQ") ? new SimpleDateFormat() : (this.info.getBaseFormat().equals("NLDATMYW") ? new SimpleDateFormat(this.info.getPattern(), this.info.getFormatLocale()) : new SimpleDateFormat(this.info.getPattern(), new DateFormatSymbols(this.info.getFormatLocale()))))))) : new SimpleDateFormat("M/d/yy h:mm a", new DateFormatSymbols(this.locale));
        this.formatter.setLenient(false);
        this.setTimeZone(timezone);
        this.initCalendar();
    }

    @Override
    public boolean isDateTimeFormat() {
        return true;
    }

    @Override
    public double convertFromJavaDate(long javaDate) {
        return this.javaDateToSASDateTime(javaDate, this.getTimeZone());
    }

    @Override
    public long convertToJavaDate(double sasDateTime) {
        return this.SASDateTimeToJavaDate(sasDateTime, this.getTimeZone());
    }

    static Object[] getDefinedFormats(Locale locale) {
        Vector<SingleEntry> temp = new Vector<SingleEntry>(5, 1);
        String className = DateTimeValue.class.getName();
        SingleEntry shortEntry = new SingleEntry("UNIFORMw", "");
        shortEntry.setFormatLocale(locale);
        Map shortUniformEntryMap = shortEntry.genNLdatesEntry(1);
        Map shortDateUniformEntryMap = shortEntry.genNLdatesEntry(0, "d_fmt_m.w");
        Map shortDateUniformEntryMap1 = shortEntry.genNLdatesEntry(0);
        SingleEntry entry = new SingleEntry("DATETIMEw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("DATEAMPMw.d", className);
        ((SASFormatEntry)entry).addPattern(19, 40, "ddMMMyy:hh:mm:ss a", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:hh a");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:hh a");
        ((SASFormatEntry)entry).addPattern(16, 17, "ddMMMyy:hh:mm a");
        ((SASFormatEntry)entry).addPattern(18, 18, "ddMMMyyyy:hh:mm a");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("TODw.d", className);
        ((SASFormatEntry)entry).addPattern(8, 8, "HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(2, 4, "HH");
        ((SASFormatEntry)entry).addPattern(5, 7, "HH:mm");
        ((SASFormatEntry)entry).addPattern(9, 20, "HH:mm:ss");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("DTDATEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("DTMONYYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("DTWKDATXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("DTYEARw", className);
        ((SASFormatEntry)entry).addPattern(4, 4, "yyyy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "yy");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMw.d", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addResourceString(10, 200, 30, new String[]{"d_t", "d_t_s"});
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMLw.d", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        entry.addAllPaterns(((SingleEntry)shortUniformEntryMap.get((Object)new Integer((int)1))).patterns, 0, 0);
        ((SASFormatEntry)entry).addDatetimeResourceString("d_t_fmt_s.w", "d_t_fmt_m.w", "d_t_fmt_s", 3, true);
        ((SASFormatEntry)entry).addDatetimeResourceString("d_t_fmt_m.w", "d_t_fmt_l.w", "d_t_fmt_m", 2, true);
        ((SASFormatEntry)entry).addDatetimeResourceString("d_t_fmt_l.w", 200, "d_t_fmt_l", true);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMMw.d", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        entry.addAllPaterns(((SingleEntry)shortUniformEntryMap.get((Object)new Integer((int)1))).patterns, 0, 0);
        ((SASFormatEntry)entry).addDatetimeResourceString("d_t_fmt_s.w", "d_t_fmt_m.w", "d_t_fmt_s", 3, true);
        ((SASFormatEntry)entry).addDatetimeResourceString("d_t_fmt_m.w", 200, "d_t_fmt_m", true);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMSw.d", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        entry.addAllPaterns(((SingleEntry)shortUniformEntryMap.get((Object)new Integer((int)1))).patterns, 19, 200);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMAPw.d", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addResourceString(16, 200, 32, new String[]{"d_t_ap", "d_t_ap_s"});
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMWw.d", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        int maxDayWidth = DateTimeValue.checkWidth(locale, "EEEE", 7);
        String max = entry.getDatetimeString("d_fmt_week_s.w");
        int maxWidth = Integer.parseInt(max) - 1;
        if (maxWidth >= 16) {
            if (maxDayWidth > 16) {
                ((SASFormatEntry)entry).addPattern(16, maxDayWidth - 1, "EEE");
                ((SASFormatEntry)entry).addPattern(maxDayWidth, maxWidth, "EEEE");
            } else {
                ((SASFormatEntry)entry).addPattern(16, maxWidth, "EEEE");
            }
        }
        ((SASFormatEntry)entry).addDatetimeResourceString("d_fmt_week_s.w", "d_fmt_week.w", "d_fmt_week_s", -1, false);
        ((SASFormatEntry)entry).addDatetimeResourceString("d_fmt_week.w", "d_t_fmt_week_s.w", "d_fmt_week", -1, false);
        ((SASFormatEntry)entry).addDatetimeResourceString("d_t_fmt_week_s.w", "d_t_fmt_week.w", "d_t_fmt_week_s", -1, true);
        ((SASFormatEntry)entry).addDatetimeResourceString("d_t_fmt_week.w", 200, "d_t_fmt_week", true);
        entry.setMinWidth(16);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMTMw.d", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addResourceString(16, 200, "t", true);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMYMw.d", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addResourceString(6, 200, 16, new String[]{"d_ym", "d_ym_s"});
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMYMLw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        entry.addAllPaterns(((SingleEntry)shortDateUniformEntryMap1.get((Object)new Integer((int)2))).patterns, 0, 0);
        ((SASFormatEntry)entry).addDatetimeResourceString(200, 16, new String[]{"d_fmt_yymm", "d_fmt_yymm_s"});
        entry.setMinWidth(5);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMYMMw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        entry.addAllPaterns(((SingleEntry)shortDateUniformEntryMap1.get((Object)new Integer((int)2))).patterns, 0, 0);
        ((SASFormatEntry)entry).addDatetimeResourceString(5, 200, "d_fmt_yymm_s", true);
        entry.setMinWidth(5);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMYMSw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        entry.addAllPaterns(((SingleEntry)shortDateUniformEntryMap1.get((Object)new Integer((int)2))).patterns, 7, 200);
        entry.setMinWidth(5);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMMDw.d", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addResourceString(6, 200, 16, new String[]{"d_md", "d_md_s"});
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMMDLw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        entry.addAllPaterns(((SingleEntry)shortDateUniformEntryMap1.get((Object)new Integer((int)3))).patterns, 0, 0);
        ((SASFormatEntry)entry).addDatetimeResourceString(200, 16, new String[]{"d_md", "d_fmt_mmdd_s"});
        entry.setMinWidth(5);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMMDMw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        entry.addAllPaterns(((SingleEntry)shortDateUniformEntryMap1.get((Object)new Integer((int)3))).patterns, 0, 0);
        ((SASFormatEntry)entry).addDatetimeResourceString("d_fmt_mmdd_s.w", 200, "d_fmt_mmdd_s", true);
        entry.setMinWidth(5);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMMDSw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        entry.addAllPaterns(((SingleEntry)shortDateUniformEntryMap1.get((Object)new Integer((int)3))).patterns, 5, 200);
        entry.setMinWidth(5);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMDTw.d", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        entry.addAllPaterns(((SingleEntry)shortDateUniformEntryMap.get((Object)new Integer((int)1))).patterns, 0, 0);
        ((SASFormatEntry)entry).addDatetimeResourceString("d_fmt_m.w", "d_fmt_l.w", "d_fmt_m", 2, false);
        ((SASFormatEntry)entry).addDatetimeResourceString("d_fmt_l.w", 200, "d_fmt_l", true);
        entry.setMinWidth(10);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMMNw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        int maxAbMonthWidth = DateTimeValue.checkWidth(locale, "MMM", 2);
        int maxMonthWidth = DateTimeValue.checkWidth(locale, "MMMM", 2);
        if (maxAbMonthWidth == maxMonthWidth) {
            if (maxAbMonthWidth > 4) {
                ((SASFormatEntry)entry).addPattern(4, maxMonthWidth - 1, "MM");
            }
        } else if (maxAbMonthWidth > 4) {
            ((SASFormatEntry)entry).addPattern(4, maxAbMonthWidth - 1, "MM");
            ((SASFormatEntry)entry).addPattern(maxAbMonthWidth, maxMonthWidth - 1, "MMM");
        } else if (maxAbMonthWidth == 4) {
            ((SASFormatEntry)entry).addPattern(maxAbMonthWidth, maxMonthWidth - 1, "MMM");
        } else if (4 < maxMonthWidth) {
            ((SASFormatEntry)entry).addPattern(4, maxMonthWidth - 1, "MMM");
        } else {
            maxMonthWidth = 4;
        }
        ((SASFormatEntry)entry).addPattern(maxMonthWidth, 200, "MMMM");
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMWNw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        int maxAbDayWidth = DateTimeValue.checkWidth(locale, "EEE", 7);
        maxDayWidth = DateTimeValue.checkWidth(locale, "EEEE", 7);
        if (maxAbDayWidth == maxDayWidth) {
            if (maxAbDayWidth > 4) {
                ((SASFormatEntry)entry).addPattern(4, maxDayWidth - 1, "E");
            }
        } else if (maxAbDayWidth > 4) {
            ((SASFormatEntry)entry).addPattern(4, maxAbDayWidth - 1, "E");
            ((SASFormatEntry)entry).addPattern(maxAbDayWidth, maxDayWidth - 1, "EEE");
        } else if (maxAbDayWidth == 4) {
            ((SASFormatEntry)entry).addPattern(maxAbDayWidth, maxDayWidth - 1, "EEE");
        } else if (4 < maxDayWidth) {
            ((SASFormatEntry)entry).addPattern(4, maxDayWidth - 1, "EEE");
        } else {
            maxDayWidth = 4;
        }
        ((SASFormatEntry)entry).addPattern(maxDayWidth, 200, "EEEE");
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMYRw", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addResourceString(2, 200, 16, new String[]{"d_y", "d_y_s"});
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMYQw", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addResourceString(4, 200, 16, new String[]{"d_yq", "d_yq_s"});
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMYQLw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        ((SASFormatEntry)entry).addDatetimeResourceString(4, 200, 16, new String[]{"d_fmt_yyqq", "d_fmt_yyqq_s"});
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMYQMw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        ((SASFormatEntry)entry).addDatetimeResourceString(4, 200, "d_fmt_yyqq_s", true);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMYQSw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        entry.addAllPaterns(((SingleEntry)shortDateUniformEntryMap1.get((Object)new Integer((int)4))).patterns, 6, 200);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMYWw", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addResourceString(5, 200, 16, new String[]{"d_yw", "d_yw_s"});
        temp.addElement(entry);
        entry = new SingleEntry("AFRDFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(AFRIKAANS);
        temp.addElement(entry);
        entry = new SingleEntry("CATDFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(CATALAN);
        temp.addElement(entry);
        entry = new SingleEntry("CRODFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(CROATIAN);
        temp.addElement(entry);
        entry = new SingleEntry("CSYDFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(CZECH);
        temp.addElement(entry);
        entry = new SingleEntry("DANDFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(DANISH);
        temp.addElement(entry);
        entry = new SingleEntry("DESDFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(GERMAN_SWITZERLAND);
        temp.addElement(entry);
        entry = new SingleEntry("DEUDFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(Locale.GERMAN);
        temp.addElement(entry);
        entry = new SingleEntry("ENGDFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(Locale.ENGLISH);
        temp.addElement(entry);
        entry = new SingleEntry("ESPDFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(SPANISH);
        temp.addElement(entry);
        entry = new SingleEntry("EURDFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        temp.addElement(entry);
        entry = new SingleEntry("FINDFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(FINNISH);
        temp.addElement(entry);
        entry = new SingleEntry("FRADFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(Locale.FRENCH);
        temp.addElement(entry);
        entry = new SingleEntry("FRSDFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(FRENCH_SWITZERLAND);
        temp.addElement(entry);
        entry = new SingleEntry("HUNDFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(HUNGARIAN);
        temp.addElement(entry);
        entry = new SingleEntry("ITADFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(Locale.ITALIAN);
        temp.addElement(entry);
        entry = new SingleEntry("MACDFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(MACEDONIAN);
        temp.addElement(entry);
        entry = new SingleEntry("NLDDFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(DUTCH);
        temp.addElement(entry);
        entry = new SingleEntry("NORDFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(NORWEGIAN);
        temp.addElement(entry);
        entry = new SingleEntry("POLDFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(POLISH);
        temp.addElement(entry);
        entry = new SingleEntry("PTGDFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(PORTUGUESE);
        temp.addElement(entry);
        entry = new SingleEntry("RUSDFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(RUSSIAN);
        temp.addElement(entry);
        entry = new SingleEntry("SLODFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(SLOVENIAN);
        temp.addElement(entry);
        entry = new SingleEntry("SVEDFDTw.d", className);
        ((SASFormatEntry)entry).addPattern(16, 40, "ddMMMyy:HH:mm:ss", true);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(10, 11, "ddMMMyy:HH");
        ((SASFormatEntry)entry).addPattern(12, 12, "ddMMMyyyy:HH");
        ((SASFormatEntry)entry).addPattern(13, 14, "ddMMMyy:HH:mm");
        ((SASFormatEntry)entry).addPattern(15, 15, "ddMMMyyyy:HH:mm");
        entry.setFormatLocale(SWEDISH);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMZw", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addResourceString(16, 200, 40, new String[]{"d_t_z"});
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMTZw", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addResourceString(16, 200, 32, new String[]{"t_z"});
        temp.addElement(entry);
        entry = new SingleEntry("NLDATMWZw", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addResourceString(16, 200, 40, new String[]{"d_t_wkz"});
        temp.addElement(entry);
        Object[] q = QuarterDateTime.getDefinedFormats();
        dateTimeValueFormats = new Object[temp.size() + q.length];
        temp.copyInto(dateTimeValueFormats);
        System.arraycopy(q, 0, dateTimeValueFormats, temp.size(), q.length);
        return dateTimeValueFormats;
    }
}

