/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.codepolicy.SASScope;
import com.sas.net.crypto.CryptoException;
import com.sas.net.crypto.sas.SasCrypto;
import com.sas.util.BASE64;
import com.sas.util.SasPasswordEncodingException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SASScope(value="ALL")
public class SasPasswordString {
    public static final String BASE64_ENCODING = "base64";
    public static final String SASENC_ENCODING = "sasenc";
    public static final String SAS001_ENCODING = "sas001";
    public static final String SAS002_ENCODING = "sas002";
    private static final String _tagRegex = "\\{(sas\\d{3}+|base64|sasenc)\\}";
    private static final Pattern _tagPattern = Pattern.compile("\\{(sas\\d{3}+|base64|sasenc)\\}", 2);
    private static final Charset _utf8 = Charset.forName("utf8");
    private static SasCrypto _sasCrypto;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    public static boolean isEncoded(String instring) {
        if (instring == null) {
            throw new NullPointerException("instring cannot be null");
        }
        char[] inchars = instring.toCharArray();
        boolean result = false;
        try {
            result = SasPasswordString.isEncodedChars(inchars);
        }
        finally {
            Arrays.fill(inchars, '\u0000');
        }
        return result;
    }

    public static boolean isEncodedChars(char[] inchars) {
        if (inchars == null) {
            throw new NullPointerException("inchars cannot be null");
        }
        SplitResult splitResult = SasPasswordString.split(inchars);
        if (splitResult == null) {
            return false;
        }
        char[] data = splitResult.getData();
        Arrays.fill(data, '\u0000');
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    public static boolean isEncodedAndSupported(String instring) {
        if (instring == null) {
            throw new NullPointerException("instring cannot be null");
        }
        char[] inchars = instring.toCharArray();
        boolean result = false;
        try {
            result = SasPasswordString.isEncodedAndSupportedChars(inchars);
        }
        finally {
            Arrays.fill(inchars, '\u0000');
        }
        return result;
    }

    public static boolean isEncodedAndSupportedChars(char[] inchars) {
        SplitResult splitResult = SasPasswordString.split(inchars);
        if (splitResult == null) {
            return false;
        }
        String tag = splitResult.getTag().toLowerCase();
        boolean result = BASE64_ENCODING.equals(tag) || SASENC_ENCODING.equals(tag) || SAS001_ENCODING.equals(tag) || SAS002_ENCODING.equals(tag);
        char[] data = splitResult.getData();
        Arrays.fill(data, '\u0000');
        return result;
    }

    @SASScope
    public static DecodeResult decodeWithResult(String instring) throws SasPasswordEncodingException {
        if (instring == null) {
            throw new NullPointerException("instring cannot be null");
        }
        char[] tagAndEncodedDataCopy = instring.toCharArray();
        return SasPasswordString.decodeInternal(tagAndEncodedDataCopy);
    }

    public static DecodeResult decodeCharsWithResult(char[] tagAndEncodedData) throws SasPasswordEncodingException {
        if (tagAndEncodedData == null) {
            throw new NullPointerException("tagAndEncodedData cannot be null");
        }
        int tagAndEncodedDataL = tagAndEncodedData.length;
        char[] tagAndEncodedDataCopy = new char[tagAndEncodedDataL];
        System.arraycopy(tagAndEncodedData, 0, tagAndEncodedDataCopy, 0, tagAndEncodedDataL);
        return SasPasswordString.decodeInternal(tagAndEncodedDataCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DecodeResult decodeInternal(char[] tagAndEncodedDataCopy) throws SasPasswordEncodingException {
        SplitResult splitResult = SasPasswordString.split(tagAndEncodedDataCopy);
        if (splitResult == null) {
            return new DecodeResult(tagAndEncodedDataCopy, 1);
        }
        byte[][] intermediateArrays = new byte[2][];
        DecodeResult result = null;
        try {
            String tag = splitResult.getTag();
            String tagLC = tag.toLowerCase();
            char[] data = splitResult.getData();
            if (SAS001_ENCODING.equals(tagLC) || BASE64_ENCODING.equals(tagLC)) {
                byte[] utf8 = SasPasswordString.base64Decode(data);
                if (utf8 == null) {
                    int tagAndEncodedDataL = tagAndEncodedDataCopy.length;
                    char[] resultCopy = Arrays.copyOf(tagAndEncodedDataCopy, tagAndEncodedDataL);
                    result = new DecodeResult(resultCopy, 3);
                } else {
                    intermediateArrays[0] = utf8;
                    char[] plaintext = SasPasswordString.utf8Decode(utf8);
                    result = new DecodeResult(plaintext, 0);
                }
            } else if (SAS002_ENCODING.equals(tagLC) || SASENC_ENCODING.equals(tagLC)) {
                byte[] sas002 = SasPasswordString.hexDecode(data);
                if (sas002 == null) {
                    int tagAndEncodedDataL = tagAndEncodedDataCopy.length;
                    char[] resultCopy = Arrays.copyOf(tagAndEncodedDataCopy, tagAndEncodedDataL);
                    result = new DecodeResult(resultCopy, 3);
                } else {
                    intermediateArrays[0] = sas002;
                    byte[] utf8 = SasPasswordString.sas002Decode(sas002);
                    if (utf8 == null) {
                        int tagAndEncodedDataL = tagAndEncodedDataCopy.length;
                        char[] resultCopy = Arrays.copyOf(tagAndEncodedDataCopy, tagAndEncodedDataL);
                        result = new DecodeResult(resultCopy, 3);
                    } else {
                        intermediateArrays[1] = utf8;
                        char[] plaintext = SasPasswordString.utf8Decode(utf8);
                        result = new DecodeResult(plaintext, 0);
                    }
                }
            } else {
                int tagAndEncodedDataL = tagAndEncodedDataCopy.length;
                char[] resultCopy = Arrays.copyOf(tagAndEncodedDataCopy, tagAndEncodedDataL);
                result = new DecodeResult(resultCopy, 2);
            }
        }
        finally {
            Arrays.fill(tagAndEncodedDataCopy, '\u0000');
            for (byte[] arr : intermediateArrays) {
                if (arr == null) continue;
                Arrays.fill(arr, (byte)0);
            }
        }
        return result;
    }

    public static String decode(String instring) throws SasPasswordEncodingException {
        DecodeResult result = SasPasswordString.decodeWithResult(instring);
        String plaintext = result.getValue();
        result.clearSensitiveData();
        return plaintext;
    }

    public static char[] decodeChars(char[] tagAndEncodedData) throws SasPasswordEncodingException {
        DecodeResult decodeResult = SasPasswordString.decodeCharsWithResult(tagAndEncodedData);
        char[] result = decodeResult.getValueChars();
        return result;
    }

    public static String encode(String encoding, String instring) throws SasPasswordEncodingException {
        if (instring == null) {
            throw new NullPointerException("instring cannot be null");
        }
        char[] plaintextCopy = instring.toCharArray();
        char[] tagAndEncodedData = SasPasswordString.encodeInternal(encoding, plaintextCopy);
        String result = new String(tagAndEncodedData);
        Arrays.fill(tagAndEncodedData, '\u0000');
        return result;
    }

    public static char[] encodeChars(String encoding, char[] plaintext) throws SasPasswordEncodingException {
        if (plaintext == null) {
            throw new NullPointerException("plaintext cannot be null");
        }
        int plaintextL = plaintext.length;
        char[] plaintextCopy = new char[plaintextL];
        System.arraycopy(plaintext, 0, plaintextCopy, 0, plaintextL);
        return SasPasswordString.encodeInternal(encoding, plaintextCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char[] encodeInternal(String encoding, char[] plaintextCopy) throws SasPasswordEncodingException {
        if (plaintextCopy.length == 0 || SasPasswordString.isEncodedChars(plaintextCopy)) {
            return plaintextCopy;
        }
        byte[][] intermediateArrays = new byte[2][];
        char[] encodedData = null;
        char[] tagAndEncodedData = null;
        try {
            byte[] utf8;
            if (encoding == null) {
                throw new SasPasswordEncodingException();
            }
            String encodingLC = encoding.toLowerCase();
            if (SAS001_ENCODING.equals(encodingLC) || BASE64_ENCODING.equals(encodingLC)) {
                utf8 = SasPasswordString.utf8Encode(plaintextCopy);
                intermediateArrays[0] = utf8;
                encodedData = SasPasswordString.base64Encode(utf8);
            } else if (SAS002_ENCODING.equals(encodingLC) || SASENC_ENCODING.equals(encodingLC)) {
                utf8 = SasPasswordString.utf8Encode(plaintextCopy);
                intermediateArrays[0] = utf8;
                byte[] sas002 = SasPasswordString.sas002Encode(utf8);
                intermediateArrays[1] = sas002;
                encodedData = SasPasswordString.hexEncode(sas002);
            } else {
                throw new SasPasswordEncodingException(encoding);
            }
            int encodingL = encoding.length();
            int encodedDataL = encodedData.length;
            int bufferL = 2 + encodingL + encodedDataL;
            tagAndEncodedData = new char[bufferL];
            int n = 0;
            tagAndEncodedData[n++] = 123;
            char[] encodingChars = encoding.toCharArray();
            System.arraycopy(encodingChars, 0, tagAndEncodedData, n, encodingL);
            n += encodingL;
            tagAndEncodedData[n++] = 125;
            System.arraycopy(encodedData, 0, tagAndEncodedData, n, encodedDataL);
        }
        catch (Throwable throwable) {
            Arrays.fill(plaintextCopy, '\u0000');
            if (encodedData != null) {
                Arrays.fill(encodedData, '\u0000');
            }
            for (byte[] arr : intermediateArrays) {
                if (arr == null) continue;
                Arrays.fill(arr, (byte)0);
            }
            throw throwable;
        }
        Arrays.fill(plaintextCopy, '\u0000');
        if (encodedData != null) {
            Arrays.fill(encodedData, '\u0000');
        }
        for (byte[] arr : intermediateArrays) {
            if (arr == null) continue;
            Arrays.fill(arr, (byte)0);
        }
        return tagAndEncodedData;
    }

    @SASScope
    public static String encode(String instring) throws SasPasswordEncodingException {
        return SasPasswordString.encode(SAS002_ENCODING, instring);
    }

    public static char[] encodeChars(char[] plaintext) throws SasPasswordEncodingException {
        return SasPasswordString.encodeChars(SAS002_ENCODING, plaintext);
    }

    private static SplitResult split(char[] tagAndData) {
        int tagAndDataBufL;
        CharBuffer tagAndDataBuf = CharBuffer.wrap(tagAndData);
        Matcher tagMatcher = _tagPattern.matcher(tagAndDataBuf);
        boolean encoded = tagMatcher.lookingAt();
        if (!encoded) {
            return null;
        }
        String tag = tagMatcher.group(1);
        int dataIndex = tagMatcher.end();
        if (dataIndex >= (tagAndDataBufL = tagAndDataBuf.length())) {
            return null;
        }
        tagAndDataBuf.position(dataIndex);
        int dataL = tagAndDataBuf.remaining();
        char[] data = new char[dataL];
        tagAndDataBuf.get(data);
        return new SplitResult(tag, data);
    }

    private static char[] hexEncode(byte[] data) {
        int dataL = data.length;
        int bufL = dataL * 2;
        StringBuffer buf = new StringBuffer(bufL);
        for (int i = 0; i < dataL; ++i) {
            int b = data[i] & 0xFF;
            if (b < 16) {
                buf.append("0");
            }
            String h = Integer.toHexString(b);
            buf.append(h);
        }
        String hex = buf.toString().toUpperCase();
        return hex.toCharArray();
    }

    private static byte[] hexDecode(char[] hex) {
        int hexL = hex.length;
        if (hexL % 2 != 0) {
            return null;
        }
        int dataL = hexL / 2;
        byte[] data = new byte[dataL];
        for (int i = 0; i < dataL; ++i) {
            int strt = i * 2;
            String h = new String(hex, strt, 2);
            try {
                data[i] = (byte)Integer.parseInt(h, 16);
                continue;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return data;
    }

    private static byte[] sas002Encode(byte[] data) throws SasPasswordEncodingException {
        int dataL = data.length;
        if (dataL == 0) {
            return data;
        }
        SasCrypto sasCrypto = SasPasswordString.getSasCrypto();
        int bufL = sasCrypto.getCipherTextLength(dataL);
        ByteArrayOutputStream cStream = new ByteArrayOutputStream(bufL);
        try {
            sasCrypto.encrypt(data, 0, dataL, cStream);
        }
        catch (IOException ioe) {
            SasPasswordEncodingException spee = new SasPasswordEncodingException(ioe);
            try {
                spee.initCause(ioe);
            }
            catch (IllegalStateException ise) {
                // empty catch block
            }
            throw spee;
        }
        catch (CryptoException ce) {
            SasPasswordEncodingException spee = new SasPasswordEncodingException(ce);
            try {
                spee.initCause(ce);
            }
            catch (IllegalStateException ise) {
                // empty catch block
            }
            throw spee;
        }
        byte[] sas002 = cStream.toByteArray();
        return sas002;
    }

    private static byte[] sas002Decode(byte[] sas002) throws SasPasswordEncodingException {
        SasCrypto sasCrypto = SasPasswordString.getSasCrypto();
        int sas002L = sas002.length;
        int bufL = sasCrypto.getMaxPlainTextLength(sas002L);
        byte[] buf = new byte[bufL];
        ByteArrayInputStream sas002Stream = new ByteArrayInputStream(sas002);
        try {
            int dataL = sasCrypto.decrypt(sas002Stream, sas002L, buf, 0);
            if (dataL == 0 || dataL > bufL) {
                return null;
            }
            if (dataL == bufL) {
                return buf;
            }
            byte[] data = new byte[dataL];
            System.arraycopy(buf, 0, data, 0, dataL);
            return data;
        }
        catch (IOException ioe) {
            SasPasswordEncodingException spee = new SasPasswordEncodingException(ioe);
            try {
                spee.initCause(ioe);
            }
            catch (IllegalStateException ise) {
                // empty catch block
            }
            throw spee;
        }
        catch (CryptoException ce) {
            return null;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return null;
        }
    }

    private static byte[] utf8Encode(char[] data) throws SasPasswordEncodingException {
        CharBuffer dataBuf = CharBuffer.wrap(data);
        ByteBuffer utf8Buf = _utf8.encode(dataBuf);
        return SasPasswordString.byteBufferToByteArray(utf8Buf);
    }

    private static char[] utf8Decode(byte[] utf8) throws SasPasswordEncodingException {
        ByteBuffer utf8Buf = ByteBuffer.wrap(utf8);
        CharBuffer charBuf = _utf8.decode(utf8Buf);
        return SasPasswordString.charBufferToCharArray(charBuf);
    }

    private static char[] base64Encode(byte[] data) {
        String base64 = data.length != 0 ? BASE64.encode(data) : "";
        return base64.toCharArray();
    }

    private static byte[] base64Decode(char[] base64) {
        byte[] data = BASE64.decode(new String(base64));
        return data;
    }

    private static byte[] byteBufferToByteArray(ByteBuffer buf) {
        int bufL = buf.remaining();
        byte[] arr = new byte[bufL];
        buf.get(arr);
        buf.clear();
        while (buf.hasRemaining()) {
            buf.put((byte)0);
        }
        return arr;
    }

    private static char[] charBufferToCharArray(CharBuffer buf) {
        int bufL = buf.remaining();
        char[] arr = new char[bufL];
        buf.get(arr);
        buf.clear();
        while (buf.hasRemaining()) {
            buf.put('\u0000');
        }
        return arr;
    }

    private static synchronized SasCrypto getSasCrypto() {
        if (_sasCrypto == null) {
            Properties properties = new Properties();
            properties.put(SasCrypto.PROPERTYNAME_RADIX, "16");
            properties.put(SasCrypto.PROPERTYNAME_KEY, "5CD8EE25");
            properties.put(SasCrypto.PROPERTYNAME_POWER, "3DE4FEAB");
            _sasCrypto = new SasCrypto(properties);
        }
        return _sasCrypto;
    }

    private static class SplitResult {
        private String _tag;
        private char[] _data;

        private SplitResult(String tag, char[] data) {
            this._tag = tag;
            this._data = data;
        }

        private String getTag() {
            return this._tag;
        }

        private char[] getData() {
            return this._data;
        }
    }

    @SASScope
    public static final class DecodeResult {
        public static final int REASON_OK = 0;
        public static final int REASON_NOT_ENCODED = 1;
        public static final int REASON_NOT_SUPPORTED = 2;
        public static final int REASON_NOT_DECODABLE = 3;
        private char[] _value;
        private int _reason;

        private DecodeResult(char[] value, int reason) {
            this._value = value;
            this._reason = reason;
        }

        public String getValue() {
            return new String(this._value);
        }

        public char[] getValueChars() {
            return this._value;
        }

        public void clearSensitiveData() {
            if (this._value != null) {
                Arrays.fill(this._value, '\u0000');
            }
        }

        public int getReason() {
            return this._reason;
        }
    }
}

