/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.log;

import com.sas.util.log.CommonLoggerInterface;
import java.text.MessageFormat;

public abstract class AbstractLoggerAdapter
implements CommonLoggerInterface {
    protected static final int _levelDebug = 100;
    protected static final int _levelInfo = 200;
    protected static final int _levelWarn = 300;
    protected static final int _levelError = 400;
    protected static final int _levelFatal = 500;

    @Override
    public void debug(String message) {
        this.log(100, message);
    }

    @Override
    public final void debug(String message1, String message2) {
        if (this.isDebugEnabled()) {
            String message = message1 + " " + message2;
            this.debug(message);
        }
    }

    @Override
    public void debug(String message, Throwable t) {
        this.log(100, message, t);
    }

    @Override
    public void error(String message) {
        this.log(400, message);
    }

    @Override
    public final void error(String pattern, String message) {
        if (this.isErrorEnabled()) {
            String formattedMessage = this.formatMessage(pattern, message);
            this.error(formattedMessage);
        }
    }

    @Override
    public final void error(String pattern, String message, Throwable t) {
        if (this.isErrorEnabled()) {
            String formattedMessage = this.formatMessage(pattern, message);
            this.error(formattedMessage, t);
        }
    }

    @Override
    public void error(String message, Throwable t) {
        this.log(400, message, t);
    }

    @Override
    public void fatal(String message) {
        this.log(500, message);
    }

    @Override
    public void fatal(String message, Throwable t) {
        this.log(500, message, t);
    }

    @Override
    public void info(String message) {
        this.log(200, message);
    }

    @Override
    public final void info(String pattern, String message) {
        if (this.isInfoEnabled()) {
            String formattedMessage = this.formatMessage(pattern, message);
            this.info(formattedMessage);
        }
    }

    @Override
    public void info(String message, Throwable t) {
        this.log(200, message, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabledFor(100);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isEnabledFor(400);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isEnabledFor(200);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isEnabledFor(300);
    }

    @Override
    public void warn(String message) {
        this.log(300, message);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.log(300, message, t);
    }

    @Override
    public final void warn(String pattern, String message) {
        if (this.isWarnEnabled()) {
            String formattedMessage = this.formatMessage(pattern, message);
            this.warn(formattedMessage);
        }
    }

    @Override
    public final void warn(String pattern, String message, Throwable t) {
        if (this.isWarnEnabled()) {
            String formattedMessage = this.formatMessage(pattern, message);
            this.warn(formattedMessage, t);
        }
    }

    protected void log(int level, String message) {
        this.log(level, message, null);
    }

    protected abstract void log(int var1, String var2, Throwable var3);

    protected abstract boolean isEnabledFor(int var1);

    private String formatMessage(String pattern, String message) {
        return pattern != null ? MessageFormat.format(pattern, message) : null;
    }
}

