/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.log;

import com.sas.util.log.AbstractLoggerAdapter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class Log4jReflectionLoggerAdapter
extends AbstractLoggerAdapter {
    private Class<?> _levelClass;
    private Method _isEnabledForMethod;
    private Method _logMethod;
    private Object _logger;
    private Object _lDebug;
    private Object _lInfo;
    private Object _lWarn;
    private Object _lError;
    private Object _lFatal;

    Log4jReflectionLoggerAdapter(Class<?> loggerClass, String context) {
        try {
            Method m = loggerClass.getMethod("getLogger", String.class);
            this._logger = m.invoke(null, context);
            this._levelClass = Class.forName("org.apache.log4j.Level");
            this._lDebug = this._levelClass.getField("DEBUG").get(null);
            this._lInfo = this._levelClass.getField("INFO").get(null);
            this._lWarn = this._levelClass.getField("WARN").get(null);
            this._lError = this._levelClass.getField("ERROR").get(null);
            this._lFatal = this._levelClass.getField("FATAL").get(null);
            Class<?> priorityClass = Class.forName("org.apache.log4j.Priority");
            this._isEnabledForMethod = loggerClass.getMethod("isEnabledFor", priorityClass);
            this._logMethod = loggerClass.getMethod("log", priorityClass, Object.class, Throwable.class);
        }
        catch (Exception e) {
            throw this.handleReflectionException(e);
        }
    }

    private RuntimeException handleReflectionException(Exception e) {
        Throwable t = e;
        while (true) {
            if (t instanceof RuntimeException) {
                return (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (!(t instanceof InvocationTargetException)) break;
            t = ((InvocationTargetException)t).getCause();
        }
        return new RuntimeException(t);
    }

    @Override
    protected void log(int level, String message, Throwable t) {
        try {
            Object l = this.getLevel(level);
            this._logMethod.invoke(this._logger, l, message, t);
        }
        catch (Exception e) {
            throw this.handleReflectionException(e);
        }
    }

    @Override
    protected boolean isEnabledFor(int level) {
        try {
            Object l = this.getLevel(level);
            return (Boolean)this._isEnabledForMethod.invoke(this._logger, l);
        }
        catch (Exception e) {
            throw this.handleReflectionException(e);
        }
    }

    private Object getLevel(int level) {
        switch (level) {
            case 100: {
                return this._lDebug;
            }
            case 200: {
                return this._lInfo;
            }
            case 300: {
                return this._lWarn;
            }
            case 400: {
                return this._lError;
            }
            case 500: {
                return this._lFatal;
            }
        }
        throw new IllegalArgumentException("unknown level " + level);
    }
}

