# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = ['ServerClaim']


class ServerClaim(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 always_include_in_token: Optional[pulumi.Input[bool]] = None,
                 auth_server_id: Optional[pulumi.Input[str]] = None,
                 claim_type: Optional[pulumi.Input[str]] = None,
                 group_filter_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 value_type: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates an Authorization Server Claim.

        This resource allows you to create and configure an Authorization Server Claim.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.auth.ServerClaim("example",
            auth_server_id="<auth server id>",
            claim_type="IDENTITY",
            scopes=[okta_auth_server_scope["example"]["name"]],
            value="String.substringAfter(user.email, \"@\") == \"example.com\"")
        ```

        ## Import

        Authorization Server Claim can be imported via the Auth Server ID and Claim ID.

        ```sh
         $ pulumi import okta:auth/serverClaim:ServerClaim example <auth server id>/<claim id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] always_include_in_token: Specifies whether to include claims in token, by default is is set to `true`.
        :param pulumi.Input[str] auth_server_id: The Application's display name.
        :param pulumi.Input[str] claim_type: Specifies whether the claim is for an access token `"RESOURCE"` or ID token `"IDENTITY"`.
        :param pulumi.Input[str] group_filter_type: Specifies the type of group filter if `value_type` is `"GROUPS"`. Can be set to one of the following `"STARTS_WITH"`, `"EQUALS"`, `"CONTAINS"`, `"REGEX"`.
        :param pulumi.Input[str] name: The name of the claim.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: The list of scopes the auth server claim is tied to.
        :param pulumi.Input[str] status: The status of the application. It defaults to `"ACTIVE"`.
        :param pulumi.Input[str] value: The value of the claim.
        :param pulumi.Input[str] value_type: The type of value of the claim. It can be set to `"EXPRESSION"` or `"GROUPS"`. It defaults to `"EXPRESSION"`.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['always_include_in_token'] = always_include_in_token
            if auth_server_id is None and not opts.urn:
                raise TypeError("Missing required property 'auth_server_id'")
            __props__['auth_server_id'] = auth_server_id
            if claim_type is None and not opts.urn:
                raise TypeError("Missing required property 'claim_type'")
            __props__['claim_type'] = claim_type
            __props__['group_filter_type'] = group_filter_type
            __props__['name'] = name
            __props__['scopes'] = scopes
            __props__['status'] = status
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__['value'] = value
            __props__['value_type'] = value_type
        super(ServerClaim, __self__).__init__(
            'okta:auth/serverClaim:ServerClaim',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            always_include_in_token: Optional[pulumi.Input[bool]] = None,
            auth_server_id: Optional[pulumi.Input[str]] = None,
            claim_type: Optional[pulumi.Input[str]] = None,
            group_filter_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            value: Optional[pulumi.Input[str]] = None,
            value_type: Optional[pulumi.Input[str]] = None) -> 'ServerClaim':
        """
        Get an existing ServerClaim resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] always_include_in_token: Specifies whether to include claims in token, by default is is set to `true`.
        :param pulumi.Input[str] auth_server_id: The Application's display name.
        :param pulumi.Input[str] claim_type: Specifies whether the claim is for an access token `"RESOURCE"` or ID token `"IDENTITY"`.
        :param pulumi.Input[str] group_filter_type: Specifies the type of group filter if `value_type` is `"GROUPS"`. Can be set to one of the following `"STARTS_WITH"`, `"EQUALS"`, `"CONTAINS"`, `"REGEX"`.
        :param pulumi.Input[str] name: The name of the claim.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: The list of scopes the auth server claim is tied to.
        :param pulumi.Input[str] status: The status of the application. It defaults to `"ACTIVE"`.
        :param pulumi.Input[str] value: The value of the claim.
        :param pulumi.Input[str] value_type: The type of value of the claim. It can be set to `"EXPRESSION"` or `"GROUPS"`. It defaults to `"EXPRESSION"`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["always_include_in_token"] = always_include_in_token
        __props__["auth_server_id"] = auth_server_id
        __props__["claim_type"] = claim_type
        __props__["group_filter_type"] = group_filter_type
        __props__["name"] = name
        __props__["scopes"] = scopes
        __props__["status"] = status
        __props__["value"] = value
        __props__["value_type"] = value_type
        return ServerClaim(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alwaysIncludeInToken")
    def always_include_in_token(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to include claims in token, by default is is set to `true`.
        """
        return pulumi.get(self, "always_include_in_token")

    @property
    @pulumi.getter(name="authServerId")
    def auth_server_id(self) -> pulumi.Output[str]:
        """
        The Application's display name.
        """
        return pulumi.get(self, "auth_server_id")

    @property
    @pulumi.getter(name="claimType")
    def claim_type(self) -> pulumi.Output[str]:
        """
        Specifies whether the claim is for an access token `"RESOURCE"` or ID token `"IDENTITY"`.
        """
        return pulumi.get(self, "claim_type")

    @property
    @pulumi.getter(name="groupFilterType")
    def group_filter_type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the type of group filter if `value_type` is `"GROUPS"`. Can be set to one of the following `"STARTS_WITH"`, `"EQUALS"`, `"CONTAINS"`, `"REGEX"`.
        """
        return pulumi.get(self, "group_filter_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the claim.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of scopes the auth server claim is tied to.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        """
        The status of the application. It defaults to `"ACTIVE"`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[str]:
        """
        The value of the claim.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of value of the claim. It can be set to `"EXPRESSION"` or `"GROUPS"`. It defaults to `"EXPRESSION"`.
        """
        return pulumi.get(self, "value_type")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

