# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = ['SamlKey']


class SamlKey(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 x5cs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a SAML Identity Provider Signing Key.

        This resource allows you to create and configure a SAML Identity Provider Signing Key.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.idp.SamlKey("example", x5cs=[okta_app_saml["example"]["certificate"]])
        ```

        ## Import

        A SAML IdP Signing Key can be imported via the key id.

        ```sh
         $ pulumi import okta:idp/samlKey:SamlKey example <key id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] x5cs: base64-encoded X.509 certificate chain with DER encoding.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if x5cs is None and not opts.urn:
                raise TypeError("Missing required property 'x5cs'")
            __props__['x5cs'] = x5cs
            __props__['created'] = None
            __props__['expires_at'] = None
            __props__['kid'] = None
            __props__['kty'] = None
            __props__['use'] = None
            __props__['x5t_s256'] = None
        super(SamlKey, __self__).__init__(
            'okta:idp/samlKey:SamlKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created: Optional[pulumi.Input[str]] = None,
            expires_at: Optional[pulumi.Input[str]] = None,
            kid: Optional[pulumi.Input[str]] = None,
            kty: Optional[pulumi.Input[str]] = None,
            use: Optional[pulumi.Input[str]] = None,
            x5cs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            x5t_s256: Optional[pulumi.Input[str]] = None) -> 'SamlKey':
        """
        Get an existing SamlKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created: Date created.
        :param pulumi.Input[str] expires_at: Date the cert expires.
        :param pulumi.Input[str] kid: Key ID.
        :param pulumi.Input[str] kty: Identifies the cryptographic algorithm family used with the key.
        :param pulumi.Input[str] use: Intended use of the public key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] x5cs: base64-encoded X.509 certificate chain with DER encoding.
        :param pulumi.Input[str] x5t_s256: base64url-encoded SHA-256 thumbprint of the DER encoding of an X.509 certificate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["created"] = created
        __props__["expires_at"] = expires_at
        __props__["kid"] = kid
        __props__["kty"] = kty
        __props__["use"] = use
        __props__["x5cs"] = x5cs
        __props__["x5t_s256"] = x5t_s256
        return SamlKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[str]:
        """
        Date created.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> pulumi.Output[str]:
        """
        Date the cert expires.
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter
    def kid(self) -> pulumi.Output[str]:
        """
        Key ID.
        """
        return pulumi.get(self, "kid")

    @property
    @pulumi.getter
    def kty(self) -> pulumi.Output[str]:
        """
        Identifies the cryptographic algorithm family used with the key.
        """
        return pulumi.get(self, "kty")

    @property
    @pulumi.getter
    def use(self) -> pulumi.Output[str]:
        """
        Intended use of the public key.
        """
        return pulumi.get(self, "use")

    @property
    @pulumi.getter
    def x5cs(self) -> pulumi.Output[Sequence[str]]:
        """
        base64-encoded X.509 certificate chain with DER encoding.
        """
        return pulumi.get(self, "x5cs")

    @property
    @pulumi.getter(name="x5tS256")
    def x5t_s256(self) -> pulumi.Output[str]:
        """
        base64url-encoded SHA-256 thumbprint of the DER encoding of an X.509 certificate.
        """
        return pulumi.get(self, "x5t_s256")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

