# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = [
    'EventHookHeader',
    'TemplateSmsTranslation',
]

@pulumi.output_type
class EventHookHeader(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: Key to use for authentication, usually the header name, for example `"Authorization"`.
        :param str value: Authentication secret.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        Key to use for authentication, usually the header name, for example `"Authorization"`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Authentication secret.
        """
        return pulumi.get(self, "value")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TemplateSmsTranslation(dict):
    def __init__(__self__, *,
                 language: str,
                 template: str):
        """
        :param str language: The language to map the template to.
        :param str template: The SMS message.
        """
        pulumi.set(__self__, "language", language)
        pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def language(self) -> str:
        """
        The language to map the template to.
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter
    def template(self) -> str:
        """
        The SMS message.
        """
        return pulumi.get(self, "template")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


