# hbutils

[![PyPI](https://img.shields.io/pypi/v/hbutils)](https://pypi.org/project/hbutils/)
![PyPI - Python Version](https://img.shields.io/pypi/pyversions/hbutils)
![PyPI - Implementation](https://img.shields.io/pypi/implementation/hbutils)
![PyPI - Downloads](https://img.shields.io/pypi/dm/hbutils)
![Loc](https://img.shields.io/endpoint?url=https://gist.githubusercontent.com/HansBug/1ffdd46a0c79027a7776b262143b20a4/raw/loc.json)
![Comments](https://img.shields.io/endpoint?url=https://gist.githubusercontent.com/HansBug/1ffdd46a0c79027a7776b262143b20a4/raw/comments.json)

[![Docs Deploy](https://github.com/hansbug/hbutils/workflows/Docs%20Deploy/badge.svg)](https://github.com/hansbug/hbutils/actions?query=workflow%3A%22Docs+Deploy%22)
[![Code Test](https://github.com/hansbug/hbutils/workflows/Code%20Test/badge.svg)](https://github.com/hansbug/hbutils/actions?query=workflow%3A%22Code+Test%22)
[![Badge Creation](https://github.com/hansbug/hbutils/workflows/Badge%20Creation/badge.svg)](https://github.com/hansbug/hbutils/actions?query=workflow%3A%22Badge+Creation%22)
[![Package Release](https://github.com/hansbug/hbutils/workflows/Package%20Release/badge.svg)](https://github.com/hansbug/hbutils/actions?query=workflow%3A%22Package+Release%22)
[![codecov](https://codecov.io/gh/hansbug/hbutils/branch/main/graph/badge.svg?token=XJVDP4EFAT)](https://codecov.io/gh/hansbug/hbutils)

[![GitHub stars](https://img.shields.io/github/stars/hansbug/hbutils)](https://github.com/hansbug/hbutils/stargazers)
[![GitHub forks](https://img.shields.io/github/forks/hansbug/hbutils)](https://github.com/hansbug/hbutils/network)
![GitHub commit activity](https://img.shields.io/github/commit-activity/m/hansbug/hbutils)
[![GitHub issues](https://img.shields.io/github/issues/hansbug/hbutils)](https://github.com/hansbug/hbutils/issues)
[![GitHub pulls](https://img.shields.io/github/issues-pr/hansbug/hbutils)](https://github.com/hansbug/hbutils/pulls)
[![Contributors](https://img.shields.io/github/contributors/hansbug/hbutils)](https://github.com/hansbug/hbutils/graphs/contributors)
[![GitHub license](https://img.shields.io/github/license/hansbug/hbutils)](https://github.com/hansbug/hbutils/blob/master/LICENSE)

Some useful functions and classes in Python infrastructure development.

## Installation

You can simply install it with `pip` command line from the official PyPI site.

```shell
package install hbutils
```

For more information about installation, you can refer
to [Installation](http://open-xlab.pages.gitlab.bj.sensetime.com/cell/hbutils/main/tutorials/installation/index.html).

## Features

The features currently supported by `hbutils` including:

* [hbutils.algorithm](https://hansbug.github.io/hbutils/main/api_doc/algorithm/index.html) - Some useful classic algorithms.
* [hbutils.binary](https://hansbug.github.io/hbutils/main/api_doc/binary/index.html) - Utilities for loading and saving values from binary data. (Still under development)
* [hbutils.collections](https://hansbug.github.io/hbutils/main/api_doc/collections/index.html) - Data structures and containers, as well as the tools that go with them
* [hbutils.color](https://hansbug.github.io/hbutils/main/api_doc/color/index.html) - Color model, spaces (RGB, HSV, HLS are supported) and their calculations.
* [hbutils.design](https://hansbug.github.io/hbutils/main/api_doc/design/index.html) - Extendable implements for some useful design patterns in Python.
* [hbutils.encoding](https://hansbug.github.io/hbutils/main/api_doc/encoding/index.html) - Common encoding, decoding and hash calculations for binary data.
* [hbutils.file](https://hansbug.github.io/hbutils/main/api_doc/file/index.html) - Useful utilities for reading and writing files or streams.
* [hbutils.random](https://hansbug.github.io/hbutils/main/api_doc/random/index.html) - Quickly generate various kinds of random value.
* [hbutils.reflection](https://hansbug.github.io/hbutils/main/api_doc/reflection/index.html) - Magical utilities based on Python imports/object/function/class/module reflections.
* [hbutils.scale](https://hansbug.github.io/hbutils/main/api_doc/scale/index.html) - Calculation and parsing of scaled values, such as memory size and timespan.
* [hbutils.string](https://hansbug.github.io/hbutils/main/api_doc/string/index.html) - Simple but useful string processing utilities, such as pluralization and omission.
* [hbutils.system](https://hansbug.github.io/hbutils/main/api_doc/system/index.html) - Operations on current running environment.
* [hbutils.testing](https://hansbug.github.io/hbutils/main/api_doc/testing/index.html) - Useful utilities for building unit test.

For further information, take a look at [HBUtils’s Documentation](https://hansbug.github.io/hbutils/main/index.html),
the API Documentation part is just the function and classes included now.

This utility set is still under development, more utilities will be added soon afterwards. You
can [share good ideas or suggestions in the issue area](https://github.com/HansBug/hbutils/issues), where we can discuss
and develop them further.
