"""
Interacts with the mmpos api
"""
import os
from setuptools import find_packages, setup

# with open("./requirements.txt", "r", encoding="utf-8") as fh:
#     requirements = fh.readlines()
def read(fname):
    return open(os.path.join(os.path.dirname(__file__), fname)).read()

requirements = ['click', 'prettytable', 'requests_cache', 'platformdirs']


setup(
    name='mmpos',
    version='0.2.2',
    url='https://gitlab.com/blockops/python-mmpos',
    license='BSD',
    author='Opselite',
    author_email='opselite@blockops.party',
    description='CLI tool and API for the MMPOS REST API crypto mining platform',
    long_description=read('README.md'),
    packages=find_packages(exclude=['tests', '.tox']),
    include_package_data=True,
    keywords="mmpos mining gpus crypto blockchain platform rest",
    zip_safe=False,
    platforms="any",
    long_description_content_type="text/markdown",
    install_requires=requirements,
    entry_points={
        "console_scripts": [
            "mmpos = mmpos.cli.cli:main",
        ],
    },
    classifiers=[
        # As from http://pypi.python.org/pypi?%3Aaction=list_classifiers
        # 'Development Status :: 1 - Planning',
        # 'Development Status :: 2 - Pre-Alpha',
        "Development Status :: 3 - Alpha",
        #'Development Status :: 4 - Beta',
        # 'Development Status :: 5 - Production/Stable',
        # 'Development Status :: 6 - Mature',
        # 'Development Status :: 7 - Inactive',
        "Environment :: Console",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: BSD License",
        "Operating System :: POSIX",
        "Operating System :: MacOS",
        "Operating System :: Unix",
        "Operating System :: Microsoft :: Windows",
        "Programming Language :: Python",
        #'Programming Language :: Python :: 2',
        "Programming Language :: Python :: 3",
        "Topic :: Software Development :: Libraries :: Python Modules",
    ],
)
