# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['PluginArgs', 'Plugin']

@pulumi.input_type
class PluginArgs:
    def __init__(__self__, *,
                 config_json: Optional[pulumi.Input[str]] = None,
                 consumer_id: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 route_id: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 strict_match: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Plugin resource.
        :param pulumi.Input[str] config_json: plugin configuration in JSON format, configuration must be a valid JSON object.
        """
        if config_json is not None:
            pulumi.set(__self__, "config_json", config_json)
        if consumer_id is not None:
            pulumi.set(__self__, "consumer_id", consumer_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if route_id is not None:
            pulumi.set(__self__, "route_id", route_id)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)
        if strict_match is not None:
            pulumi.set(__self__, "strict_match", strict_match)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="configJson")
    def config_json(self) -> Optional[pulumi.Input[str]]:
        """
        plugin configuration in JSON format, configuration must be a valid JSON object.
        """
        return pulumi.get(self, "config_json")

    @config_json.setter
    def config_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_json", value)

    @property
    @pulumi.getter(name="consumerId")
    def consumer_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "consumer_id")

    @consumer_id.setter
    def consumer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="routeId")
    def route_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "route_id")

    @route_id.setter
    def route_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route_id", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter(name="strictMatch")
    def strict_match(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "strict_match")

    @strict_match.setter
    def strict_match(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "strict_match", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _PluginState:
    def __init__(__self__, *,
                 computed_config: Optional[pulumi.Input[str]] = None,
                 config_json: Optional[pulumi.Input[str]] = None,
                 consumer_id: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 route_id: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 strict_match: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Plugin resources.
        :param pulumi.Input[str] config_json: plugin configuration in JSON format, configuration must be a valid JSON object.
        """
        if computed_config is not None:
            pulumi.set(__self__, "computed_config", computed_config)
        if config_json is not None:
            pulumi.set(__self__, "config_json", config_json)
        if consumer_id is not None:
            pulumi.set(__self__, "consumer_id", consumer_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if route_id is not None:
            pulumi.set(__self__, "route_id", route_id)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)
        if strict_match is not None:
            pulumi.set(__self__, "strict_match", strict_match)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="computedConfig")
    def computed_config(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "computed_config")

    @computed_config.setter
    def computed_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "computed_config", value)

    @property
    @pulumi.getter(name="configJson")
    def config_json(self) -> Optional[pulumi.Input[str]]:
        """
        plugin configuration in JSON format, configuration must be a valid JSON object.
        """
        return pulumi.get(self, "config_json")

    @config_json.setter
    def config_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_json", value)

    @property
    @pulumi.getter(name="consumerId")
    def consumer_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "consumer_id")

    @consumer_id.setter
    def consumer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="routeId")
    def route_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "route_id")

    @route_id.setter
    def route_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route_id", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter(name="strictMatch")
    def strict_match(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "strict_match")

    @strict_match.setter
    def strict_match(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "strict_match", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class Plugin(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_json: Optional[pulumi.Input[str]] = None,
                 consumer_id: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 route_id: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 strict_match: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        ## # Plugin

        The plugin resource maps directly onto the json for the API endpoint in Kong.  For more information on the parameters [see the Kong Api create documentation](https://docs.konghq.com/gateway-oss/2.5.x/admin-api/#plugin-object).
        The `config_json` is passed through to the plugin to configure it as is.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_kong as kong

        rate_limit = kong.Plugin("rateLimit", config_json=\"\"\"	{
        		"second": 5,
        		"hour" : 1000
        	}

        \"\"\")
        ```
        To apply a plugin to a consumer use the `consumer_id` property, for example:

        ```python
        import pulumi
        import pulumi_kong as kong

        plugin_consumer = kong.Consumer("pluginConsumer",
            custom_id="567",
            username="PluginUser")
        rate_limit = kong.Plugin("rateLimit",
            config_json=\"\"\"	{
        		"second": 5,
        		"hour" : 1000
        	}

        \"\"\",
            consumer_id=plugin_consumer.id)
        ```

        To apply a plugin to a service use the `service_id` property, for example:

        ```python
        import pulumi
        import pulumi_kong as kong

        service = kong.Service("service",
            host="test.org",
            protocol="http")
        rate_limit = kong.Plugin("rateLimit",
            config_json=\"\"\"	{
        		"second": 10,
        		"hour" : 2000
        	}

        \"\"\",
            service_id=service.id)
        ```

        To apply a plugin to a route use the `route_id` property, for example:

        ```python
        import pulumi
        import pulumi_kong as kong

        service = kong.Service("service",
            host="test.org",
            protocol="http")
        rate_limit = kong.Plugin("rateLimit",
            config_json=\"\"\"	{
        		"second": 11,
        		"hour" : 4000
        	}

        \"\"\",
            enabled=True,
            service_id=service.id)
        ```
        ## Argument reference

        * `plugin_name` - (Required) the name of the plugin you want to configure
        * `consumer_id` - (Optional) the consumer id you want to configure the plugin for
        * `service_id`  - (Optional) the service id that you want to configure the plugin for
        * `route_id` - (Optional) the route id that you want to configure the plugin for
        * `enabled` - (Optional) whether the plugin is enabled or not, use if you want to keep the plugin installed but disable it
        * `config_json` - (Optional) this is the configuration json for how you want to configure the plugin.  The json is passed straight through to kong as is.  You can get the json config from the Kong documentation
          page of the plugin you are configuring
        * `tags` - (Optional) A list of strings associated with the Plugin for grouping and filtering

        ## Import

        To import a plugin

        ```sh
         $ pulumi import kong:index/plugin:Plugin <plugin_identifier> <plugin_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] config_json: plugin configuration in JSON format, configuration must be a valid JSON object.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PluginArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Plugin

        The plugin resource maps directly onto the json for the API endpoint in Kong.  For more information on the parameters [see the Kong Api create documentation](https://docs.konghq.com/gateway-oss/2.5.x/admin-api/#plugin-object).
        The `config_json` is passed through to the plugin to configure it as is.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_kong as kong

        rate_limit = kong.Plugin("rateLimit", config_json=\"\"\"	{
        		"second": 5,
        		"hour" : 1000
        	}

        \"\"\")
        ```
        To apply a plugin to a consumer use the `consumer_id` property, for example:

        ```python
        import pulumi
        import pulumi_kong as kong

        plugin_consumer = kong.Consumer("pluginConsumer",
            custom_id="567",
            username="PluginUser")
        rate_limit = kong.Plugin("rateLimit",
            config_json=\"\"\"	{
        		"second": 5,
        		"hour" : 1000
        	}

        \"\"\",
            consumer_id=plugin_consumer.id)
        ```

        To apply a plugin to a service use the `service_id` property, for example:

        ```python
        import pulumi
        import pulumi_kong as kong

        service = kong.Service("service",
            host="test.org",
            protocol="http")
        rate_limit = kong.Plugin("rateLimit",
            config_json=\"\"\"	{
        		"second": 10,
        		"hour" : 2000
        	}

        \"\"\",
            service_id=service.id)
        ```

        To apply a plugin to a route use the `route_id` property, for example:

        ```python
        import pulumi
        import pulumi_kong as kong

        service = kong.Service("service",
            host="test.org",
            protocol="http")
        rate_limit = kong.Plugin("rateLimit",
            config_json=\"\"\"	{
        		"second": 11,
        		"hour" : 4000
        	}

        \"\"\",
            enabled=True,
            service_id=service.id)
        ```
        ## Argument reference

        * `plugin_name` - (Required) the name of the plugin you want to configure
        * `consumer_id` - (Optional) the consumer id you want to configure the plugin for
        * `service_id`  - (Optional) the service id that you want to configure the plugin for
        * `route_id` - (Optional) the route id that you want to configure the plugin for
        * `enabled` - (Optional) whether the plugin is enabled or not, use if you want to keep the plugin installed but disable it
        * `config_json` - (Optional) this is the configuration json for how you want to configure the plugin.  The json is passed straight through to kong as is.  You can get the json config from the Kong documentation
          page of the plugin you are configuring
        * `tags` - (Optional) A list of strings associated with the Plugin for grouping and filtering

        ## Import

        To import a plugin

        ```sh
         $ pulumi import kong:index/plugin:Plugin <plugin_identifier> <plugin_id>
        ```

        :param str resource_name: The name of the resource.
        :param PluginArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PluginArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_json: Optional[pulumi.Input[str]] = None,
                 consumer_id: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 route_id: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 strict_match: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PluginArgs.__new__(PluginArgs)

            __props__.__dict__["config_json"] = config_json
            __props__.__dict__["consumer_id"] = consumer_id
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["route_id"] = route_id
            __props__.__dict__["service_id"] = service_id
            __props__.__dict__["strict_match"] = strict_match
            __props__.__dict__["tags"] = tags
            __props__.__dict__["computed_config"] = None
        super(Plugin, __self__).__init__(
            'kong:index/plugin:Plugin',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            computed_config: Optional[pulumi.Input[str]] = None,
            config_json: Optional[pulumi.Input[str]] = None,
            consumer_id: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            route_id: Optional[pulumi.Input[str]] = None,
            service_id: Optional[pulumi.Input[str]] = None,
            strict_match: Optional[pulumi.Input[bool]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Plugin':
        """
        Get an existing Plugin resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] config_json: plugin configuration in JSON format, configuration must be a valid JSON object.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PluginState.__new__(_PluginState)

        __props__.__dict__["computed_config"] = computed_config
        __props__.__dict__["config_json"] = config_json
        __props__.__dict__["consumer_id"] = consumer_id
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["route_id"] = route_id
        __props__.__dict__["service_id"] = service_id
        __props__.__dict__["strict_match"] = strict_match
        __props__.__dict__["tags"] = tags
        return Plugin(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="computedConfig")
    def computed_config(self) -> pulumi.Output[str]:
        return pulumi.get(self, "computed_config")

    @property
    @pulumi.getter(name="configJson")
    def config_json(self) -> pulumi.Output[Optional[str]]:
        """
        plugin configuration in JSON format, configuration must be a valid JSON object.
        """
        return pulumi.get(self, "config_json")

    @property
    @pulumi.getter(name="consumerId")
    def consumer_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "consumer_id")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="routeId")
    def route_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "route_id")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter(name="strictMatch")
    def strict_match(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "strict_match")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "tags")

