
from pyxcp.transport.can import padFrame

def test_frame_padding_no_padding_length():
    EXPECTED = (
        (0,  8),  ( 1,  8), ( 2,  8), ( 3,  8), ( 4,  8), ( 5,  8), (6,  8),  (7,   8), (8, 8),
        (9, 12),  (10, 12), (11, 12), (12, 12), (13, 16), (14, 16), (15, 16), (16, 16),
        (17, 20), (18, 20), (19, 20), (20, 20), (21, 24), (22, 24), (23, 24), (24, 24),
        (25, 32), (26, 32), (27, 32), (28, 32), (29, 32), (30, 32), (31, 32), (32, 32),
        (33, 48), (34, 48), (35, 48), (36, 48), (37, 48), (38, 48), (39, 48), (40, 48),
        (41, 48), (42, 48), (43, 48), (44, 48), (45, 48), (46, 48), (47, 48), (48, 48),
        (49, 64), (50, 64), (51, 64), (52, 64), (53, 64), (54, 64), (55, 64), (56, 64),
        (57, 64), (58, 64), (59, 64), (60, 64), (61, 64), (62, 64), (63, 64), (64, 64)
    )
    for frame_len in range(65):
        frame = bytes(frame_len)
        padded_frame = padFrame(frame, padding_value = 0, padding_len = 0)
        frame_len = len(padded_frame)
        _, expected_len = EXPECTED[frame_len]
        assert frame_len == expected_len

def test_frame_padding_padding_length32():
    EXPECTED = (
        (0,  32), ( 1, 32), ( 2, 32), ( 3, 32), ( 4, 32), ( 5, 32), (6,  32),  (7, 32), (8, 32),
        (9,  32), (10, 32), (11, 32), (12, 32), (13, 32), (14, 32), (15, 32), (16, 32),
        (17, 32), (18, 32), (19, 32), (20, 32), (21, 32), (22, 32), (23, 32), (24, 32),
        (25, 32), (26, 32), (27, 32), (28, 32), (29, 32), (30, 32), (31, 32), (32, 32),
        (33, 48), (34, 48), (35, 48), (36, 48), (37, 48), (38, 48), (39, 48), (40, 48),
        (41, 48), (42, 48), (43, 48), (44, 48), (45, 48), (46, 48), (47, 48), (48, 48),
        (49, 64), (50, 64), (51, 64), (52, 64), (53, 64), (54, 64), (55, 64), (56, 64),
        (57, 64), (58, 64), (59, 64), (60, 64), (61, 64), (62, 64), (63, 64), (64, 64)
    )
    for frame_len in range(65):
        frame = bytes(frame_len)
        padded_frame = padFrame(frame, padding_value = 0, padding_len = 32)
        frame_len = len(padded_frame)
        _, expected_len = EXPECTED[frame_len]
        assert frame_len == expected_len

