# mypy-boto3-networkmanager

[![PyPI - mypy-boto3-networkmanager](https://img.shields.io/pypi/v/mypy-boto3-networkmanager.svg?color=blue)](https://pypi.org/project/mypy-boto3-networkmanager)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-networkmanager.svg?color=blue)](https://pypi.org/project/mypy-boto3-networkmanager)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.NetworkManager 1.14.23](https://boto3.amazonaws.com/v1/documentation/api/1.14.23/reference/services/networkmanager.html#NetworkManager) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `NetworkManager` service.

```bash
python -m pip install boto3-stubs[networkmanager]
```

## How to use

### Client annotations

`NetworkManagerClient` provides annotations for `boto3.client("networkmanager")`.

```python
import boto3

from mypy_boto3_networkmanager import NetworkManagerClient
from mypy_boto3_networkmanager.paginator import (
    DescribeGlobalNetworksPaginator,
    GetCustomerGatewayAssociationsPaginator,
    GetDevicesPaginator,
    GetLinkAssociationsPaginator,
    GetLinksPaginator,
    GetSitesPaginator,
    GetTransitGatewayRegistrationsPaginator,
)
from mypy_boto3_networkmanager.type_defs import BandwidthTypeDef, ...

client: NetworkManagerClient = boto3.client("networkmanager")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: NetworkManagerClient = session.client("networkmanager")
```

### Paginators annotations

`mypy_boto3_networkmanager.paginator` module contains type annotations for all paginators.

```python

client: NetworkManagerClient = boto3.client("networkmanager")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_global_networks_paginator: DescribeGlobalNetworksPaginator = client.get_paginator("describe_global_networks")
get_customer_gateway_associations_paginator: GetCustomerGatewayAssociationsPaginator = client.get_paginator("get_customer_gateway_associations")
get_devices_paginator: GetDevicesPaginator = client.get_paginator("get_devices")
get_link_associations_paginator: GetLinkAssociationsPaginator = client.get_paginator("get_link_associations")
get_links_paginator: GetLinksPaginator = client.get_paginator("get_links")
get_sites_paginator: GetSitesPaginator = client.get_paginator("get_sites")
get_transit_gateway_registrations_paginator: GetTransitGatewayRegistrationsPaginator = client.get_paginator("get_transit_gateway_registrations")
```







### Typed dictionations

`mypy_boto3_networkmanager.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> BandwidthTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_networkmanager` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("networkmanager")

session_client = boto3.Session().client("networkmanager")
```
