"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(require("react"));
const markdown_1 = __importDefault(require("@boyuai/markdown"));
const CheckCircleFilled_1 = __importDefault(require("@ant-design/icons/CheckCircleFilled"));
const CloseCircleFilled_1 = __importDefault(require("@ant-design/icons/CloseCircleFilled"));
const input_1 = __importDefault(require("antd/lib/input"));
require("./fill.css");
function QuesFill({ question, onChange, value = [], lock }) {
    const { number, title, answer = [] } = question;
    const texts = react_1.useMemo(() => {
        const result = title.split('%%');
        if (result.length <= 1) {
            // 没有%%的默认空在最后
            result.push('');
        }
        return result;
    }, [title]);
    const handleChange = (e, index) => {
        const inputValue = e.target.value;
        if (lock) {
            return;
        }
        const newValue = [...value];
        newValue[index] = inputValue;
        onChange && onChange(question.id, newValue);
    };
    return react_1.default.createElement("div", { className: "ui-quiz-question-fill" },
        react_1.default.createElement("div", null,
            react_1.default.createElement("p", { className: "ui-quiz-question-title" },
                number,
                "."),
            texts.map((item, index) => {
                if (index === texts.length - 1) { // 最后一组text了，没有“空”
                    return react_1.default.createElement(markdown_1.default, { key: index, content: item });
                }
                const itemAnswer = answer && answer[index].replace(/\\n/g, '\n').trim();
                const itemValue = value && value[index] || '';
                const result = itemAnswer === itemValue;
                if (index < texts.length - 1) {
                    return (react_1.default.createElement("div", { key: index },
                        react_1.default.createElement(markdown_1.default, { content: item }),
                        react_1.default.createElement("div", { style: { position: 'relative' } },
                            react_1.default.createElement(input_1.default.TextArea, { value: itemValue, onChange: e => handleChange(e, index), className: `${lock &&
                                    (result
                                        ? 'right-answer'
                                        : 'wrong-answer')}` }),
                            lock && result && (react_1.default.createElement(CheckCircleFilled_1.default, null)),
                            lock && !result && (react_1.default.createElement(CloseCircleFilled_1.default, null)),
                            lock && !result && (react_1.default.createElement("pre", { style: {
                                    marginTop: '10px',
                                    width: '100%',
                                }, className: "right-answer" },
                                "\u6B63\u786E\u7B54\u6848\uFF1A",
                                react_1.default.createElement("br", null),
                                answer[index].replace(/\\n/g, '\n'))))));
                }
            })));
}
exports.default = QuesFill;
//# sourceMappingURL=fill.js.map