"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(require("react"));
const button_1 = __importDefault(require("antd/lib/button"));
const message_1 = __importDefault(require("antd/lib/message"));
const question_1 = __importDefault(require("./question"));
const util_1 = require("./util");
require("./style.css");
function Quiz({ questions: originalQuestions, lock, onSubmit }) {
    const [values, setValues] = react_1.useState({});
    const [showValidation, setShowValidation] = react_1.useState(false);
    const [submitted, setSubmitted] = react_1.useState(false);
    const questions = react_1.useMemo(() => {
        return originalQuestions;
    }, [values, originalQuestions]);
    const selectQuestions = react_1.useMemo(() => {
        if (!questions) {
            return [];
        }
        return questions.filter(o => o.type === 'SELECT');
    }, [questions]);
    const fillQuestions = react_1.useMemo(() => {
        if (!questions) {
            return [];
        }
        return questions.filter(o => o.type === 'FILL');
    }, [questions]);
    const onChange = (key, value) => {
        setValues(prev => (Object.assign(Object.assign({}, prev), { [key]: value })));
    };
    const handleSubmit = () => {
        let completed = true;
        const answers = questions.map(item => {
            const answer = values[item.id];
            if (answer === undefined || answer === null) {
                completed = false;
            }
            return {
                id: item.id,
                answer,
            };
        });
        if (!completed) {
            setShowValidation(true);
            return message_1.default.error('有题目未作答');
        }
        setSubmitted(true);
        onSubmit(answers);
    };
    return (react_1.default.createElement("div", { className: "ui-quiz" },
        selectQuestions.length && react_1.default.createElement("h3", null, "\u9009\u62E9\u9898"),
        selectQuestions.map((question, index) => react_1.default.createElement(question_1.default, { question: util_1.getQuestionProps(question, index), key: question.id, value: values[question.id], onChange: onChange, showValidation: showValidation, lock: lock || submitted })),
        fillQuestions.length && react_1.default.createElement("h3", null, "\u586B\u7A7A\u9898"),
        fillQuestions.map((question, index) => react_1.default.createElement(question_1.default, { question: util_1.getQuestionProps(question, index), key: question.id, value: values[question.id], onChange: onChange, showValidation: showValidation, lock: lock || submitted })),
        react_1.default.createElement("div", { className: "space" }),
        !(lock || submitted) && (react_1.default.createElement(button_1.default, { type: "primary", onClick: handleSubmit }, "\u63D0\u4EA4"))));
}
exports.default = Quiz;
//# sourceMappingURL=index.js.map