"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(require("react"));
const CheckCircleFilled_1 = __importDefault(require("@ant-design/icons/CheckCircleFilled"));
const CloseCircleFilled_1 = __importDefault(require("@ant-design/icons/CloseCircleFilled"));
const radio_1 = __importDefault(require("antd/lib/radio"));
const markdown_1 = __importDefault(require("@boyuai/markdown"));
require("./select.css");
function renderOption(value) {
    // 历史问题，有些只有一个\n
    const doubleN = value.replace(/\n+/g, '\n\n');
    return react_1.default.createElement(markdown_1.default, { content: doubleN });
}
function QuesSelect({ question, onChange, value, lock }) {
    const { number, answer, title, options = [], id } = question;
    const handleChange = (e) => {
        if (!lock && onChange) {
            onChange(id, e.target.value);
        }
    };
    return react_1.default.createElement("div", { className: "ui-quiz-question-select" },
        react_1.default.createElement("div", null,
            react_1.default.createElement("p", { className: "question-header" },
                number,
                ".",
                lock &&
                    (answer === value ? (react_1.default.createElement(CheckCircleFilled_1.default, { className: "right" })) : (react_1.default.createElement(CloseCircleFilled_1.default, { className: "wrong" })))),
            react_1.default.createElement(markdown_1.default, { content: title })),
        react_1.default.createElement("div", { className: "radio-box" },
            react_1.default.createElement(radio_1.default.Group, { onChange: handleChange, value: value }, options.map(item => (react_1.default.createElement(radio_1.default, { key: item.value, value: item.value, className: `option ${lock && item.value === answer ? 'right-answer' : ''} ${lock &&
                    item.value !== answer &&
                    item.value === value
                    ? 'wrong-answer'
                    : ''}` }, renderOption(item.text)))))));
}
exports.default = QuesSelect;
//# sourceMappingURL=select.js.map