# mypy-boto3-workmail

[![PyPI - mypy-boto3-workmail](https://img.shields.io/pypi/v/mypy-boto3-workmail.svg?color=blue)](https://pypi.org/project/mypy-boto3-workmail)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-workmail.svg?color=blue)](https://pypi.org/project/mypy-boto3-workmail)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.WorkMail 1.13.13](https://boto3.amazonaws.com/v1/documentation/api/1.13.13/reference/services/workmail.html#WorkMail) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.9](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-workmail](#mypy-boto3-workmail)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `WorkMail` service.

```bash
python -m pip install boto3-stubs[workmail]

# update installed packages index
mypy_boto3
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import workmail
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_workmail as workmail

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("workmail")
client: workmail.WorkMailClient = boto3.client("workmail")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: workmail.WorkMailClient = session.client("workmail")


# Paginators need type annotation on creation
list_aliases_paginator: workmail.ListAliasesPaginator = client.get_paginator("list_aliases")
list_group_members_paginator: workmail.ListGroupMembersPaginator = client.get_paginator("list_group_members")
list_groups_paginator: workmail.ListGroupsPaginator = client.get_paginator("list_groups")
list_mailbox_permissions_paginator: workmail.ListMailboxPermissionsPaginator = client.get_paginator("list_mailbox_permissions")
list_organizations_paginator: workmail.ListOrganizationsPaginator = client.get_paginator("list_organizations")
list_resource_delegates_paginator: workmail.ListResourceDelegatesPaginator = client.get_paginator("list_resource_delegates")
list_resources_paginator: workmail.ListResourcesPaginator = client.get_paginator("list_resources")
list_users_paginator: workmail.ListUsersPaginator = client.get_paginator("list_users")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.