"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateAMI = exports.ResourceType = exports.VolumeType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const customResource_1 = require("./customResource");
var VolumeType;
(function (VolumeType) {
    VolumeType["STANDARD"] = "standard";
    VolumeType["IO1"] = "io1";
    VolumeType["IO2"] = "io2";
    VolumeType["GP2"] = "gp2";
    VolumeType["SC1"] = "sc1";
    VolumeType["ST1"] = "st1";
    VolumeType["GP3"] = "gp3";
})(VolumeType = exports.VolumeType || (exports.VolumeType = {}));
var ResourceType;
(function (ResourceType) {
    ResourceType["IMAGE"] = "image";
    ResourceType["SNAPSHOT"] = "snapshot";
})(ResourceType = exports.ResourceType || (exports.ResourceType = {}));
class CreateAMI extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { description, instanceId, name, blockDeviceMappings, tagSpecifications, deleteInstance, deleteAmi, } = props;
        const createAMIRequest = new customResource_1.CreateAMICustomResource(this, 'createAMIRequest', {
            uid: uid,
            properties: {
                description: description,
                instanceId: instanceId,
                dryRun: false,
                name: name ?? uid,
                noReboot: false,
                blockDeviceMappings: blockDeviceMappings,
                tagSpecifications: tagSpecifications,
                deleteInstance: deleteInstance ?? false,
                deleteAmi: deleteAmi ?? false,
            },
        });
        this.imageId =
            createAMIRequest.createAMICustomResource.getAttString('imageId');
        this.imageName =
            createAMIRequest.createAMICustomResource.getAttString('imageName');
    }
}
exports.CreateAMI = CreateAMI;
_a = JSII_RTTI_SYMBOL_1;
CreateAMI[_a] = { fqn: "cdk-create-ami.CreateAMI", version: "0.0.138" };
//# sourceMappingURL=data:application/json;base64,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