/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphAdd;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.FragmentTripleIterator;
import com.hp.hpl.jena.graph.impl.GraphAddList;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.impl.ReifierTripleMap;
import com.hp.hpl.jena.graph.impl.SimpleReifier;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SimpleReifierTripleMap
implements ReifierTripleMap {
    protected Map<Triple, Set<Node>> inverseMap = CollectionFactory.createHashedMap();
    protected Map<Node, Triple> forwardMap = CollectionFactory.createHashedMap();

    @Override
    public Triple getTriple(Node tag) {
        return this.forwardMap.get(tag);
    }

    @Override
    public void clear() {
        this.forwardMap.clear();
        this.inverseMap.clear();
    }

    @Override
    public boolean hasTriple(Triple t) {
        return this.inverseMap.containsKey(t);
    }

    @Override
    public Triple putTriple(Node key, Triple value) {
        this.forwardMap.put(key, value);
        this.inversePut(value, key);
        return value;
    }

    @Override
    public void removeTriple(Node key) {
        Triple t = this.forwardMap.get(key);
        this.forwardMap.remove(key);
        if (t instanceof Triple) {
            this.inverseRemove(t, key);
        }
    }

    @Override
    public void removeTriple(Node key, Triple value) {
        this.forwardMap.remove(key);
        this.inverseRemove(value, key);
    }

    @Override
    public void removeTriple(Triple t) {
        ExtendedIterator<Node> it = this.tagIterator(t);
        Set nodes = CollectionFactory.createHashedSet();
        while (it.hasNext()) {
            nodes.add(it.next());
        }
        Iterator them = nodes.iterator();
        while (them.hasNext()) {
            this.removeTriple((Node)them.next());
        }
    }

    protected void inverseRemove(Triple value, Node key) {
        Set<Node> s2 = this.inverseMap.get(value);
        if (s2 != null) {
            s2.remove(key);
            if (s2.isEmpty()) {
                this.inverseMap.remove(value);
            }
        }
    }

    protected void inversePut(Triple value, Node key) {
        Set<Node> s2 = this.inverseMap.get(value);
        if (s2 == null) {
            s2 = new HashSet<Node>();
            this.inverseMap.put(value, s2);
        }
        s2.add(key);
    }

    @Override
    public ExtendedIterator<Node> tagIterator(Triple t) {
        Set<Node> s2 = this.inverseMap.get(t);
        return s2 == null ? NullIterator.instance() : WrappedIterator.create(s2.iterator());
    }

    protected ExtendedIterator<Triple> allTriples(TripleMatch tm) {
        if (this.forwardMap.isEmpty()) {
            return NullIterator.instance();
        }
        Triple pattern = tm.asTriple();
        Node tag = pattern.getSubject();
        if (tag.isConcrete()) {
            Triple x = this.getTriple(tag);
            return x == null ? NullIterator.instance() : SimpleReifierTripleMap.explodeTriple(pattern, tag, x);
        }
        Iterator<Map.Entry<Node, Triple>> it = this.forwardMap.entrySet().iterator();
        return new FragmentTripleIterator<Triple>(pattern, it){

            @Override
            public void fill(GraphAdd ga, Node n, Triple t) {
                SimpleReifier.graphAddQuad(ga, n, t);
            }
        };
    }

    public static ExtendedIterator<Triple> explodeTriple(Triple pattern, Node tag, Triple toExplode) {
        GraphAddList L = new GraphAddList(pattern);
        SimpleReifier.graphAddQuad(L, tag, toExplode);
        return WrappedIterator.create(L.iterator());
    }

    public Graph asGraph() {
        return new GraphBase(){

            @Override
            public ExtendedIterator<Triple> graphBaseFind(TripleMatch tm) {
                return SimpleReifierTripleMap.this.allTriples(tm);
            }
        };
    }

    @Override
    public ExtendedIterator<Triple> find(TripleMatch m3) {
        return this.allTriples(m3);
    }

    @Override
    public int size() {
        return this.forwardMap.size() * 4;
    }

    @Override
    public ExtendedIterator<Node> tagIterator() {
        return WrappedIterator.create(this.forwardMap.keySet().iterator());
    }
}

