/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.JenaRuntime;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Applyer;
import com.hp.hpl.jena.graph.query.BufferPipe;
import com.hp.hpl.jena.graph.query.ExpressionSet;
import com.hp.hpl.jena.graph.query.GuardArranger;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Matcher;
import com.hp.hpl.jena.graph.query.Pipe;
import com.hp.hpl.jena.graph.query.QueryNodeFactory;
import com.hp.hpl.jena.graph.query.QueryTriple;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.graph.query.StageElement;
import com.hp.hpl.jena.graph.query.ValuatorSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PatternStageBase
extends Stage {
    protected static int count = 0;
    protected final ValuatorSet[] guards;
    protected final QueryTriple[] classified;
    protected final Graph graph;
    protected final QueryNodeFactory factory;
    static Logger log = LoggerFactory.getLogger(PatternStageBase.class);
    public static boolean reuseThreads = JenaRuntime.getSystemProperty("jena.reusepatternstage.threads", "yes").equals("yes");
    private static final List<PatternStageThread> threads = new ArrayList<PatternStageThread>();

    public PatternStageBase(QueryNodeFactory factory, Graph graph, Mapping map, ExpressionSet constraints, Triple[] triples) {
        this.graph = graph;
        this.factory = factory;
        this.classified = QueryTriple.classify(factory, map, triples);
        this.guards = new GuardArranger(triples).makeGuards(map, constraints);
    }

    protected void run(Pipe source, Pipe sink, StageElement se) {
        try {
            while (this.stillOpen && source.hasNext()) {
                se.run(source.get());
            }
        }
        catch (Exception e) {
            log.debug("PatternStageBase has caught and forwarded an exception", e);
            sink.close(e);
            return;
        }
        sink.close();
    }

    @Override
    public synchronized Pipe deliver(final Pipe sink) {
        final Pipe source = this.previous.deliver(new BufferPipe());
        final StageElement s2 = this.makeStageElementChain(sink, 0);
        if (reuseThreads) {
            this.getAvailableThread().put(new Work(source, sink, s2));
        } else {
            new Thread("PatternStage-" + ++count){

                @Override
                public void run() {
                    PatternStageBase.this.run(source, sink, s2);
                }
            }.start();
        }
        return sink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToAvailableThreads(PatternStageThread thread) {
        List<PatternStageThread> list = threads;
        synchronized (list) {
            threads.add(thread);
            log.debug("caching thread " + this + " [currently " + threads.size() + " cached threads]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PatternStageThread getAvailableThread() {
        List<PatternStageThread> list = threads;
        synchronized (list) {
            int size = threads.size();
            if (size > 0) {
                PatternStageThread x = threads.remove(size - 1);
                log.debug("reusing thread " + x);
                return x;
            }
        }
        PatternStageThread f = new PatternStageThread("PatternStage-" + ++count);
        log.debug("created new thread " + f);
        f.setDaemon(true);
        f.start();
        return f;
    }

    protected StageElement makeStageElementChain(Pipe sink, int index) {
        return index < this.classified.length ? this.makeIntermediateStageElement(sink, index) : this.makeFinalStageElement(sink);
    }

    protected StageElement.PutBindings makeFinalStageElement(Pipe sink) {
        return new StageElement.PutBindings(sink);
    }

    protected StageElement makeIntermediateStageElement(Pipe sink, int index) {
        StageElement next = this.makeNextStageElement(sink, index);
        return this.makeFindStageElement(index, next);
    }

    protected StageElement makeNextStageElement(Pipe sink, int index) {
        ValuatorSet s2 = this.guards[index];
        StageElement rest = this.makeStageElementChain(sink, index + 1);
        return s2.isNonTrivial() ? new StageElement.RunValuatorSet(s2, rest) : rest;
    }

    protected StageElement makeFindStageElement(int index, StageElement next) {
        Applyer f = this.classified[index].createApplyer(this.graph);
        Matcher m3 = this.classified[index].createMatcher();
        return new StageElement.FindTriples(this, m3, f, next);
    }

    public class Work {
        protected final Pipe source;
        protected final Pipe sink;
        protected final StageElement e;

        public Work(Pipe source, Pipe sink, StageElement e) {
            this.source = source;
            this.sink = sink;
            this.e = e;
        }

        public void run() {
            PatternStageBase.this.run(this.source, this.sink, this.e);
        }
    }

    private final class PatternStageThread
    extends Thread {
        private BlockingQueue<Work> buffer;

        public PatternStageThread(String name) {
            super(name);
            this.buffer = new ArrayBlockingQueue<Work>(1);
        }

        public void put(Work w) {
            try {
                this.buffer.put(w);
            }
            catch (InterruptedException e) {
                throw new BufferPipe.BoundedBufferPutException(e);
            }
        }

        protected Work get() {
            try {
                return this.buffer.take();
            }
            catch (InterruptedException e) {
                throw new BufferPipe.BoundedBufferTakeException(e);
            }
        }

        @Override
        public void run() {
            while (true) {
                this.get().run();
                PatternStageBase.this.addToAvailableThreads(this);
            }
        }
    }
}

