/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.query.Applyer;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Matcher;
import com.hp.hpl.jena.graph.query.Pipe;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.graph.query.ValuatorSet;

public abstract class StageElement {
    public abstract void run(Domain var1);

    public static final class RunValuatorSet
    extends StageElement {
        protected final ValuatorSet s;
        protected final StageElement next;

        public RunValuatorSet(ValuatorSet s2, StageElement next) {
            this.s = s2;
            this.next = next;
        }

        @Override
        public final void run(Domain current) {
            if (this.s.evalBool(current)) {
                this.next.run(current);
            }
        }
    }

    public static final class FindTriples
    extends StageElement {
        protected final Matcher matcher;
        protected final Applyer finder;
        protected final StageElement next;
        protected final Stage stage;

        public FindTriples(Stage stage, Matcher matcher, Applyer finder, StageElement next) {
            this.stage = stage;
            this.matcher = matcher;
            this.finder = finder;
            this.next = next;
        }

        @Override
        public final void run(Domain current) {
            if (this.stage.stillOpen) {
                this.finder.applyToTriples(current, this.matcher, this.next);
            }
        }
    }

    public static final class PutBindings
    extends StageElement {
        protected final Pipe sink;

        public PutBindings(Pipe sink) {
            this.sink = sink;
        }

        @Override
        public final void run(Domain current) {
            this.sink.put(current.copy());
        }
    }
}

