/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.regexptrees;

import com.hp.hpl.jena.graph.query.regexptrees.RegexpTree;

public abstract class Text
extends RegexpTree {
    public static Text create(String s2) {
        return s2.length() == 1 ? new TextChar(s2.charAt(0)) : new TextString(s2);
    }

    public static Text create(char ch) {
        return new TextChar(ch);
    }

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public abstract int hashCode();

    public abstract String getString();

    static class TextChar
    extends Text {
        protected char ch;

        TextChar(char ch) {
            this.ch = ch;
        }

        @Override
        public String getString() {
            return "" + this.ch;
        }

        @Override
        public String toString() {
            return "<text.ch '" + this.ch + "'>";
        }

        @Override
        public boolean equals(Object x) {
            return x instanceof TextChar && this.ch == ((TextChar)x).ch;
        }

        @Override
        public int hashCode() {
            return this.ch;
        }
    }

    static class TextString
    extends Text {
        protected String literal;

        TextString(String s2) {
            this.literal = s2;
        }

        @Override
        public String getString() {
            return this.literal;
        }

        @Override
        public String toString() {
            return "<text.s '" + this.literal + "'>";
        }

        @Override
        public boolean equals(Object x) {
            return x instanceof TextString && this.literal.equals(((TextString)x).literal);
        }

        @Override
        public int hashCode() {
            return this.literal.hashCode();
        }
    }
}

