/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.StageElement;
import com.hp.hpl.jena.mem.HashCommon;
import com.hp.hpl.jena.mem.MatchOrBind;
import com.hp.hpl.jena.mem.TripleBunch;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SetBunch
implements TripleBunch {
    protected Set<Triple> elements = new HashSet<Triple>(20);

    public SetBunch(TripleBunch b) {
        ExtendedIterator<Triple> it = b.iterator();
        while (it.hasNext()) {
            this.elements.add((Triple)it.next());
        }
    }

    protected static boolean equalsObjectOK(Triple t) {
        Node o = t.getObject();
        return o.isLiteral() ? o.getLiteralDatatype() == null : true;
    }

    @Override
    public boolean contains(Triple t) {
        return this.elements.contains(t);
    }

    @Override
    public boolean containsBySameValueAs(Triple t) {
        return SetBunch.equalsObjectOK(t) ? this.elements.contains(t) : this.slowContains(t);
    }

    protected boolean slowContains(Triple t) {
        Iterator<Triple> it = this.elements.iterator();
        while (it.hasNext()) {
            if (!t.matches(it.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public void add(Triple t) {
        this.elements.add(t);
    }

    @Override
    public void remove(Triple t) {
        this.elements.remove(t);
    }

    @Override
    public ExtendedIterator<Triple> iterator(HashCommon.NotifyEmpty container) {
        return this.iterator();
    }

    @Override
    public ExtendedIterator<Triple> iterator() {
        return WrappedIterator.create(this.elements.iterator());
    }

    @Override
    public void app(Domain d, StageElement next, MatchOrBind s2) {
        ExtendedIterator<Triple> it = this.iterator();
        while (it.hasNext()) {
            if (!s2.matches((Triple)it.next())) continue;
            next.run(d);
        }
    }
}

