/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.OntClassImpl;
import com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;

public class EnumeratedClassImpl
extends OntClassImpl
implements EnumeratedClass {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new EnumeratedClassImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to EnumeratedClass");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile != null && profile.isSupported(node, eg, OntClass.class) && eg.asGraph().contains(node, profile.ONE_OF().asNode(), Node.ANY);
        }
    };

    public EnumeratedClassImpl(Node n, EnhGraph g2) {
        super(n, g2);
    }

    @Override
    public void setOneOf(RDFList en) {
        this.setPropertyValue(this.getProfile().ONE_OF(), "ONE_OF", en);
    }

    @Override
    public void addOneOf(Resource res) {
        this.addListPropertyValue(this.getProfile().ONE_OF(), "ONE_OF", res);
    }

    @Override
    public void addOneOf(Iterator<? extends Resource> individuals) {
        while (individuals.hasNext()) {
            this.addOneOf(individuals.next());
        }
    }

    @Override
    public RDFList getOneOf() {
        return this.objectAs(this.getProfile().ONE_OF(), "ONE_OF", RDFList.class);
    }

    @Override
    public ExtendedIterator<? extends OntResource> listOneOf() {
        return this.getOneOf().iterator().mapWith(new OntResourceImpl.AsMapper<OntResource>(OntResource.class));
    }

    @Override
    public boolean hasOneOf(Resource res) {
        return this.getOneOf().contains(res);
    }

    @Override
    public void removeOneOf(Resource res) {
        this.setOneOf(this.getOneOf().remove(res));
    }
}

