/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.MaxCardinalityQRestriction;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.QualifiedRestrictionImpl;

public class MaxCardinalityQRestrictionImpl
extends QualifiedRestrictionImpl
implements MaxCardinalityQRestriction {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new MaxCardinalityQRestrictionImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to MaxCardinalityQRestriction");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            return MaxCardinalityQRestrictionImpl.isMaxCardinalityQRestriction(node, eg);
        }
    };

    public static boolean isMaxCardinalityQRestriction(Node node, EnhGraph eg) {
        Profile profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
        return profile != null && profile.isSupported(node, eg, MaxCardinalityQRestriction.class);
    }

    @Override
    public boolean isValid() {
        return super.isValid() && MaxCardinalityQRestrictionImpl.isMaxCardinalityQRestriction(this.asNode(), this.getGraph());
    }

    public MaxCardinalityQRestrictionImpl(Node n, EnhGraph g2) {
        super(n, g2);
    }

    @Override
    public void setMaxCardinalityQ(int cardinality) {
        this.setPropertyValue(this.getProfile().MAX_CARDINALITY_Q(), "MAX_CARDINALITY_Q", this.getModel().createTypedLiteral(cardinality));
    }

    @Override
    public int getMaxCardinalityQ() {
        return this.objectAsInt(this.getProfile().MAX_CARDINALITY_Q(), "MAX_CARDINALITY_Q");
    }

    @Override
    public boolean hasMaxCardinalityQ(int cardinality) {
        return this.hasPropertyValue(this.getProfile().MAX_CARDINALITY_Q(), "MAX_CARDINALITY_Q", this.getModel().createTypedLiteral(cardinality));
    }

    @Override
    public void removeMaxCardinalityQ(int cardinality) {
        this.removePropertyValue(this.getProfile().MAX_CARDINALITY_Q(), "MAX_CARDINALITY_Q", this.getModel().createTypedLiteral(cardinality));
    }
}

