/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.lang;

import com.hp.hpl.jena.rdf.arp.lang.LanguageTag;
import com.hp.hpl.jena.rdf.arp.lang.LanguageTagSyntaxException;
import java.util.HashMap;
import java.util.Map;

public class IanaLanguageTag
extends LanguageTag {
    static final Map<String, IanaLanguageTag[]> all = new HashMap<String, IanaLanguageTag[]>();
    public final int classification;

    private IanaLanguageTag(String s2, int classification) throws LanguageTagSyntaxException {
        super(s2);
        this.classification = 0x1024 | classification;
    }

    private IanaLanguageTag(String s2) throws LanguageTagSyntaxException {
        this(s2, 0);
    }

    public static IanaLanguageTag find(LanguageTag t) {
        if (t.tags.length < 2) {
            return null;
        }
        IanaLanguageTag[] matches = all.get(t.tags[1]);
        if (matches == null) {
            return null;
        }
        block0: for (int i = 0; i < matches.length; ++i) {
            if (t.tags.length < matches[i].tags.length) continue;
            for (int j = 0; j < matches[i].tags.length; ++j) {
                if (!t.tags[j].equals(matches[i].tags[j])) continue block0;
            }
            return matches[i];
        }
        return null;
    }

    static {
        try {
            all.put("lojban", new IanaLanguageTag[]{new IanaLanguageTag("art-lojban")});
            all.put("gaulish", new IanaLanguageTag[]{new IanaLanguageTag("cel-gaulish")});
            all.put("scouse", new IanaLanguageTag[]{new IanaLanguageTag("en-scouse")});
            all.put("ami", new IanaLanguageTag[]{new IanaLanguageTag("i-ami")});
            all.put("bnn", new IanaLanguageTag[]{new IanaLanguageTag("i-bnn")});
            all.put("default", new IanaLanguageTag[]{new IanaLanguageTag("i-default", 256)});
            all.put("enochian", new IanaLanguageTag[]{new IanaLanguageTag("i-enochian")});
            all.put("hak", new IanaLanguageTag[]{new IanaLanguageTag("i-hak", 8192)});
            all.put("klingon", new IanaLanguageTag[]{new IanaLanguageTag("i-klingon")});
            all.put("lux", new IanaLanguageTag[]{new IanaLanguageTag("i-lux", 8192)});
            all.put("mingo", new IanaLanguageTag[]{new IanaLanguageTag("i-mingo")});
            all.put("navajo", new IanaLanguageTag[]{new IanaLanguageTag("i-navajo", 8192)});
            all.put("pwn", new IanaLanguageTag[]{new IanaLanguageTag("i-pwn")});
            all.put("tao", new IanaLanguageTag[]{new IanaLanguageTag("i-tao")});
            all.put("tay", new IanaLanguageTag[]{new IanaLanguageTag("i-tay")});
            all.put("tsu", new IanaLanguageTag[]{new IanaLanguageTag("i-tsu")});
            all.put("bok", new IanaLanguageTag[]{new IanaLanguageTag("no-bok", 8192)});
            all.put("nyn", new IanaLanguageTag[]{new IanaLanguageTag("no-nyn", 8192)});
            all.put("be", new IanaLanguageTag[]{new IanaLanguageTag("sgn-BE-fr"), new IanaLanguageTag("sgn-BE-nl")});
            all.put("br", new IanaLanguageTag[]{new IanaLanguageTag("sgn-BR")});
            all.put("ch", new IanaLanguageTag[]{new IanaLanguageTag("sgn-CH-de")});
            all.put("co", new IanaLanguageTag[]{new IanaLanguageTag("sgn-CO")});
            all.put("de", new IanaLanguageTag[]{new IanaLanguageTag("sgn-DE")});
            all.put("dk", new IanaLanguageTag[]{new IanaLanguageTag("sgn-DK")});
            all.put("es", new IanaLanguageTag[]{new IanaLanguageTag("sgn-ES")});
            all.put("fr", new IanaLanguageTag[]{new IanaLanguageTag("sgn-FR")});
            all.put("gb", new IanaLanguageTag[]{new IanaLanguageTag("sgn-GB")});
            all.put("gr", new IanaLanguageTag[]{new IanaLanguageTag("sgn-GR")});
            all.put("ie", new IanaLanguageTag[]{new IanaLanguageTag("sgn-IE")});
            all.put("it", new IanaLanguageTag[]{new IanaLanguageTag("sgn-IT")});
            all.put("jp", new IanaLanguageTag[]{new IanaLanguageTag("sgn-JP")});
            all.put("mx", new IanaLanguageTag[]{new IanaLanguageTag("sgn-MX")});
            all.put("ni", new IanaLanguageTag[]{new IanaLanguageTag("sgn-NI")});
            all.put("nl", new IanaLanguageTag[]{new IanaLanguageTag("sgn-NL")});
            all.put("no", new IanaLanguageTag[]{new IanaLanguageTag("sgn-NO")});
            all.put("pt", new IanaLanguageTag[]{new IanaLanguageTag("sgn-PT")});
            all.put("se", new IanaLanguageTag[]{new IanaLanguageTag("sgn-SE")});
            all.put("us", new IanaLanguageTag[]{new IanaLanguageTag("sgn-US")});
            all.put("za", new IanaLanguageTag[]{new IanaLanguageTag("sgn-ZA")});
            all.put("gan", new IanaLanguageTag[]{new IanaLanguageTag("zh-gan")});
            all.put("guoyu", new IanaLanguageTag[]{new IanaLanguageTag("zh-guoyu")});
            all.put("hakka", new IanaLanguageTag[]{new IanaLanguageTag("zh-hakka")});
            all.put("min", new IanaLanguageTag[]{new IanaLanguageTag("zh-min"), new IanaLanguageTag("zh-min-nan")});
            all.put("wuu", new IanaLanguageTag[]{new IanaLanguageTag("zh-wuu")});
            all.put("xiang", new IanaLanguageTag[]{new IanaLanguageTag("zh-xiang")});
            all.put("yue", new IanaLanguageTag[]{new IanaLanguageTag("zh-yue")});
        }
        catch (LanguageTagSyntaxException ee) {
            System.err.println("Internal Error in static initializer of IanaLnaguageTag.");
        }
    }
}

