/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.LiteralRequiredException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFVisitor;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceRequiredException;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.shared.BadBooleanException;
import com.hp.hpl.jena.shared.BadCharLiteralException;
import com.hp.hpl.jena.shared.PrefixMapping;

public class LiteralImpl
extends EnhNode
implements Literal {
    public static final Implementation factory = new Implementation(){

        @Override
        public boolean canWrap(Node n, EnhGraph eg) {
            return n.isLiteral();
        }

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (!n.isLiteral()) {
                throw new LiteralRequiredException(n);
            }
            return new LiteralImpl(n, eg);
        }
    };

    public LiteralImpl(Node n, ModelCom m3) {
        super(n, m3);
    }

    public LiteralImpl(Node n, EnhGraph m3) {
        super(n, m3);
    }

    @Override
    public Object visitWith(RDFVisitor rv) {
        return rv.visitLiteral(this);
    }

    @Override
    public Literal inModel(Model m3) {
        return this.getModel() == m3 ? this : (Literal)((ModelCom)m3).getRDFNode(this.asNode());
    }

    @Override
    public Literal asLiteral() {
        return this;
    }

    @Override
    public Resource asResource() {
        throw new ResourceRequiredException(this.asNode());
    }

    @Override
    public Model getModel() {
        return (ModelCom)this.getGraph();
    }

    @Override
    public String toString() {
        return this.asNode().toString(PrefixMapping.Standard, false);
    }

    @Override
    public Object getValue() {
        return this.asNode().getLiteralValue();
    }

    @Override
    public RDFDatatype getDatatype() {
        return this.asNode().getLiteralDatatype();
    }

    @Override
    public String getDatatypeURI() {
        return this.asNode().getLiteralDatatypeURI();
    }

    public boolean isPlainLiteral() {
        return this.asNode().getLiteralDatatype() == null;
    }

    @Override
    public String getLexicalForm() {
        return this.asNode().getLiteralLexicalForm();
    }

    @Override
    public boolean getBoolean() {
        Object value = this.asNode().getLiteralValue();
        if (this.isPlainLiteral()) {
            if (value.equals("true")) {
                return true;
            }
            if (value.equals("false")) {
                return false;
            }
            throw new BadBooleanException(value.toString());
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new DatatypeFormatException(this.toString() + " is not a Boolean");
    }

    @Override
    public byte getByte() {
        if (this.isPlainLiteral()) {
            return Byte.parseByte(this.getLexicalForm());
        }
        return this.byteValue(this.asNumber(this.getValue()));
    }

    @Override
    public short getShort() {
        if (this.isPlainLiteral()) {
            return Short.parseShort(this.getLexicalForm());
        }
        return this.shortValue(this.asNumber(this.getValue()));
    }

    @Override
    public int getInt() {
        if (this.isPlainLiteral()) {
            return Integer.parseInt(this.getLexicalForm());
        }
        return this.intValue(this.asNumber(this.getValue()));
    }

    @Override
    public long getLong() {
        if (this.isPlainLiteral()) {
            return Long.parseLong(this.getLexicalForm());
        }
        return this.asNumber(this.getValue()).longValue();
    }

    @Override
    public char getChar() {
        if (this.isPlainLiteral()) {
            if (this.getString().length() == 1) {
                return this.getString().charAt(0);
            }
            throw new BadCharLiteralException(this.getString());
        }
        Object value = this.getValue();
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        throw new DatatypeFormatException(value.toString() + " is not a Character");
    }

    @Override
    public float getFloat() {
        if (this.isPlainLiteral()) {
            return Float.parseFloat(this.getLexicalForm());
        }
        return this.asNumber(this.getValue()).floatValue();
    }

    @Override
    public double getDouble() {
        if (this.isPlainLiteral()) {
            return Double.parseDouble(this.getLexicalForm());
        }
        return this.asNumber(this.getValue()).doubleValue();
    }

    @Override
    public String getString() {
        return this.asNode().getLiteralLexicalForm();
    }

    @Override
    public String getLanguage() {
        return this.asNode().getLiteralLanguage();
    }

    @Override
    public boolean isWellFormedXML() {
        return this.asNode().getLiteralIsXML();
    }

    @Override
    public boolean sameValueAs(Literal other) {
        return this.asNode().sameValueAs(other.asNode());
    }

    private Number asNumber(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        String message = "Error converting typed value to a number. \n";
        message = message + "Datatype is: " + this.getDatatypeURI();
        if (this.getDatatypeURI() == null || !this.getDatatypeURI().startsWith("http://www.w3.org/2001/XMLSchema")) {
            message = message + " which is not an xsd type.";
        }
        message = message + " \n";
        String type = message = message + "Java representation type is " + (value == null ? "null" : value.getClass().toString());
        throw new DatatypeFormatException(message);
    }

    private byte byteValue(Number n) {
        return (byte)this.getIntegralValueInRange(-128L, n, 127L);
    }

    private short shortValue(Number n) {
        return (short)this.getIntegralValueInRange(-32768L, n, 32767L);
    }

    private int intValue(Number n) {
        return (int)this.getIntegralValueInRange(Integer.MIN_VALUE, n, Integer.MAX_VALUE);
    }

    private long getIntegralValueInRange(long min2, Number n, long max) {
        long result = n.longValue();
        if (min2 <= result && result <= max) {
            return result;
        }
        throw new IllegalArgumentException("byte value required: " + result);
    }
}

