/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.uuid;

public final class Bits {
    public static final boolean CHECK = false;
    private static int LongLen = 64;

    public static final long unpack(long bits, int start, int finish) {
        if (finish == 0) {
            return 0L;
        }
        return bits << LongLen - finish >>> LongLen - finish + start;
    }

    public static final long pack(long bits, long value, int start, int finish) {
        bits = Bits.clear$(bits, start, finish);
        return bits |= value << start;
    }

    public static final long unpack(String str, int startChar, int finishChar) {
        String s2 = str.substring(startChar, finishChar);
        return Long.parseLong(s2, 16);
    }

    public static final long set(long bits, int bitIndex) {
        return Bits.set$(bits, bitIndex);
    }

    public static final long set(long bits, int start, int finish) {
        return Bits.set$(bits, start, finish);
    }

    public static final boolean test(long bits, boolean isSet, int bitIndex) {
        return Bits.test$(bits, isSet, bitIndex);
    }

    public static final boolean test(long bits, long value, int start, int finish) {
        return Bits.test$(bits, value, start, finish);
    }

    public static final long access(long bits, int start, int finish) {
        return Bits.access$(bits, start, finish);
    }

    public static final long clear(long bits, int start, int finish) {
        return Bits.clear$(bits, start, finish);
    }

    public static final long mask(int start, int finish) {
        return Bits.mask$(start, finish);
    }

    public static final long maskZero(int start, int finish) {
        return Bits.maskZero$(start, finish);
    }

    private static final long clear$(long bits, int start, int finish) {
        long mask = Bits.maskZero$(start, finish);
        return bits &= mask;
    }

    private static final long set$(long bits, int bitIndex) {
        long mask = Bits.mask$(bitIndex);
        return bits | mask;
    }

    private static final long set$(long bits, int start, int finish) {
        long mask = Bits.mask$(start, finish);
        return bits | mask;
    }

    private static boolean test$(long bits, boolean isSet, int bitIndex) {
        return isSet == Bits.access$(bits, bitIndex);
    }

    private static boolean test$(long bits, long value, int start, int finish) {
        long v = Bits.access$(bits, start, finish);
        return v == value;
    }

    private static final boolean access$(long bits, int bitIndex) {
        long mask = Bits.mask$(bitIndex);
        return (bits & mask) != 0L;
    }

    private static final long access$(long bits, int start, int finish) {
        return bits << LongLen - finish >>> LongLen - finish + start << start;
    }

    private static final long mask$(int bitIndex) {
        return 1L << bitIndex;
    }

    private static final long mask$(int start, int finish) {
        if (finish == 0) {
            return 0L;
        }
        long mask = -1L;
        return mask << LongLen - finish >>> LongLen - finish + start << start;
    }

    private static final long maskZero$(int start, int finish) {
        return Bits.mask$(start, finish) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    private static final void check(long bitIndex) {
        if (bitIndex < 0L || bitIndex >= (long)LongLen) {
            throw new IllegalArgumentException("Illegal bit index: " + bitIndex);
        }
    }

    private static final void check(long start, long finish) {
        if (start < 0L || start >= (long)LongLen) {
            throw new IllegalArgumentException("Illegal start: " + start);
        }
        if (finish < 0L || finish > (long)LongLen) {
            throw new IllegalArgumentException("Illegal finish: " + finish);
        }
        if (start > finish) {
            throw new IllegalArgumentException("Illegal range: (" + start + ", " + finish + ")");
        }
    }
}

