/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.uuid;

import com.hp.hpl.jena.shared.uuid.Bits;
import com.hp.hpl.jena.shared.uuid.JenaUUID;
import com.hp.hpl.jena.shared.uuid.LibUUID;
import com.hp.hpl.jena.shared.uuid.UUIDFactory;
import com.hp.hpl.jena.shared.uuid.UUID_V4;
import java.util.Random;

public class UUID_V4_Gen
implements UUIDFactory {
    static final int versionHere = 4;
    static final int variantHere = 2;
    Random random = null;

    @Override
    public JenaUUID generate() {
        return this.generateV4();
    }

    public UUID_V4 generateV4() {
        this.init();
        long mostSigBits = this.random.nextLong();
        long leastSigBits = this.random.nextLong();
        mostSigBits = Bits.pack(mostSigBits, 4L, 12, 16);
        leastSigBits = Bits.pack(leastSigBits, 2L, 62, 64);
        return new UUID_V4(mostSigBits, leastSigBits);
    }

    @Override
    public JenaUUID parse(String s2) {
        return this.parseV4(s2);
    }

    public UUID_V4 parseV4(String s2) {
        if ((s2 = s2.toLowerCase()).length() != 36) {
            throw new JenaUUID.FormatException("UUID string is not 36 chars long: it's " + s2.length() + " [" + s2 + "]");
        }
        if (s2.charAt(8) != '-' && s2.charAt(13) != '-' && s2.charAt(18) != '-' && s2.charAt(23) != '-') {
            throw new JenaUUID.FormatException("String does not have dashes in the right places: " + s2);
        }
        UUID_V4 u = UUID_V4_Gen.parse$(s2);
        if (u.getVersion() != 4) {
            throw new JenaUUID.FormatException("Wrong version (Expected: 4Got: " + u.getVersion() + "): " + s2);
        }
        if (u.getVariant() != 2) {
            throw new JenaUUID.FormatException("Wrong version (Expected: 2Got: " + u.getVariant() + "): " + s2);
        }
        return u;
    }

    static UUID_V4 parse$(String s2) {
        long mostSigBits = Bits.unpack(s2, 0, 8);
        mostSigBits = mostSigBits << 16 | Bits.unpack(s2, 9, 13);
        mostSigBits = mostSigBits << 16 | Bits.unpack(s2, 14, 18);
        long leastSigBits = Bits.unpack(s2, 19, 23);
        leastSigBits = leastSigBits << 48 | Bits.unpack(s2, 24, 36);
        return new UUID_V4(mostSigBits, leastSigBits);
    }

    public static String unparse(UUID_V4 uuid) {
        StringBuffer sb = new StringBuffer(36);
        JenaUUID.toHex(sb, Bits.unpack(uuid.bitsMostSignificant, 32, 64), 4);
        sb.append('-');
        JenaUUID.toHex(sb, Bits.unpack(uuid.bitsMostSignificant, 16, 32), 2);
        sb.append('-');
        JenaUUID.toHex(sb, Bits.unpack(uuid.bitsMostSignificant, 0, 16), 2);
        sb.append('-');
        JenaUUID.toHex(sb, Bits.unpack(uuid.bitsLeastSignificant, 48, 64), 2);
        sb.append('-');
        JenaUUID.toHex(sb, Bits.unpack(uuid.bitsLeastSignificant, 0, 48), 6);
        return sb.toString();
    }

    private void init() {
        if (this.random == null) {
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.random = LibUUID.makeRandom();
    }
}

