/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.test.TestingPanel;

public class TestFontDerivation
extends TestingPanel {
    public TestFontDerivation(String[] args) throws Exception {
        super(args);
        this.setName("Font Derivation");
    }

    @Override
    public void paintComponent(Graphics g2) {
        if (g2 == null) {
            return;
        }
        VectorGraphics vg = VectorGraphics.create(g2.create());
        Dimension dim = this.getSize();
        Insets insets = this.getInsets();
        int w = dim.width;
        int h2 = dim.height;
        vg.translate(w / 2, h2 / 2);
        vg.setColor(Color.white);
        vg.fillRect(insets.left - w / 2, insets.top - h2 / 2, w - insets.left - insets.right, h2 - insets.top - insets.bottom);
        String text = "FreeHEP";
        Font font = vg.getFont();
        double fw = (double)w / 120.0;
        double fh = (double)h2 / 120.0;
        vg.setColor(Color.BLACK);
        for (int i = 1; i < 36; ++i) {
            AffineTransform t = AffineTransform.getRotateInstance(Math.toRadians(10 * i));
            double s2 = 1.0 + (double)i / 20.0;
            t.scale(fw / s2, fh / s2);
            vg.setFont(font.deriveFont(t));
            vg.drawString(text, 0, 0);
        }
        vg.setColor(Color.BLUE);
        vg.setFont(font.deriveFont(AffineTransform.getScaleInstance(fw, fh)));
        vg.drawString(text, 0, 0);
        vg.dispose();
    }

    public static void main(String[] args) throws Exception {
        new TestFontDerivation(args).runTest();
    }
}

