/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StandardFileFilter
implements FileFilter {
    private Pattern pattern;

    public StandardFileFilter(String template) {
        if (template.indexOf("/") < 0) {
            template = "*/" + template;
        }
        StringBuffer s2 = new StringBuffer();
        int i = 0;
        while (i < template.length()) {
            char ch = template.charAt(i);
            switch (ch) {
                case '?': {
                    s2.append(".");
                    break;
                }
                case '*': {
                    s2.append(".*");
                    break;
                }
                case '\\': {
                    s2.append("\\");
                    s2.append(template.charAt(++i));
                    break;
                }
                case '.': {
                    s2.append("\\.");
                    break;
                }
                case '^': {
                    s2.append("\\^");
                    break;
                }
                case '+': {
                    s2.append("\\+");
                    break;
                }
                case '$': {
                    s2.append("\\$");
                    break;
                }
                case '{': {
                    s2.append("\\{");
                    break;
                }
                case '(': {
                    s2.append("\\(");
                    break;
                }
                case '[': {
                    s2.append("\\[");
                    break;
                }
                case '|': {
                    s2.append("\\|");
                    break;
                }
                default: {
                    s2.append(ch);
                }
            }
            ++i;
        }
        this.pattern = Pattern.compile(s2.toString());
    }

    public boolean accept(File pathname) {
        String name = pathname.getPath().replaceAll("\\" + File.separator, "/");
        Matcher matcher = this.pattern.matcher(name);
        return matcher.matches();
    }
}

