/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.AbstractFingerprinter;
import org.openscience.cdk.fingerprint.BitSetFingerprint;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.graph.AllCycles;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.Pattern;
import org.openscience.cdk.smarts.SmartsPattern;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class MACCSFingerprinter
extends AbstractFingerprinter
implements IFingerprinter {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MACCSFingerprinter.class);
    private static final String KEY_DEFINITIONS = "data/maccs.txt";
    private volatile MaccsKey[] keys = null;
    private final Object lock = new Object();

    public MACCSFingerprinter() {
    }

    public MACCSFingerprinter(IChemObjectBuilder builder) {
        try {
            this.keys = this.readKeyDef(builder);
        }
        catch (IOException e) {
            logger.debug(e);
        }
        catch (CDKException e) {
            logger.debug(e);
        }
    }

    @Override
    public IBitFingerprint getBitFingerprint(IAtomContainer container) throws CDKException {
        MaccsKey[] keys = this.keys(container.getBuilder());
        BitSet fp = new BitSet(keys.length);
        SmartsPattern.prepare(container);
        int numAtoms = container.getAtomCount();
        GraphUtil.EdgeToBondMap bmap = GraphUtil.EdgeToBondMap.withSpaceFor(container);
        int[][] adjlist = GraphUtil.toAdjList(container, bmap);
        block25: for (int i = 0; i < keys.length; ++i) {
            MaccsKey key = keys[i];
            Pattern pattern = key.pattern;
            switch (key.smarts) {
                case "[!*]": {
                    continue block25;
                }
                case "[!0]": {
                    for (IAtom atom : container.atoms()) {
                        if (atom.getMassNumber() == null) continue;
                        fp.set(i);
                        continue block25;
                    }
                    continue block25;
                }
                case "[R]1@*@*@1": 
                case "[R]1@*@*@*@1": 
                case "[R]1@*@*@*@*@1": 
                case "[R]1@*@*@*@*@*@1": 
                case "[R]1@*@*@*@*@*@*@1": 
                case "[R]1@*@*@*@*@*@*@*@1": {
                    continue block25;
                }
                case "(*).(*)": {
                    boolean[] visit = new boolean[numAtoms];
                    if (numAtoms <= 1 || MACCSFingerprinter.visitPart(visit, adjlist, 0, -1) >= numAtoms) continue block25;
                    fp.set(165);
                    continue block25;
                }
                default: {
                    if (key.count == 0) {
                        if (!pattern.matches(container)) continue block25;
                        fp.set(i);
                        continue block25;
                    }
                    if (!pattern.matchAll(container).uniqueAtoms().atLeast(key.count + 1)) continue block25;
                    fp.set(i);
                }
            }
        }
        if (numAtoms > 2) {
            AllCycles allcycles = new AllCycles(adjlist, Math.min(8, numAtoms), 126);
            int numArom = 0;
            block27: for (int[] path : allcycles.paths()) {
                switch (path.length) {
                    case 4: {
                        fp.set(21);
                        continue block27;
                    }
                    case 5: {
                        fp.set(10);
                        continue block27;
                    }
                    case 6: {
                        fp.set(95);
                        continue block27;
                    }
                    case 7: {
                        if (numArom < 2 && MACCSFingerprinter.isAromPath(path, bmap) && ++numArom == 2) {
                            fp.set(124);
                        }
                        if (fp.get(162)) {
                            fp.set(144);
                            continue block27;
                        }
                        fp.set(162);
                        continue block27;
                    }
                    case 8: {
                        fp.set(18);
                        continue block27;
                    }
                    case 9: {
                        fp.set(100);
                    }
                }
            }
        }
        return new BitSetFingerprint(fp);
    }

    private static int visitPart(boolean[] visit, int[][] g2, int beg, int prev) {
        visit[beg] = true;
        int visited = 1;
        for (int end : g2[beg]) {
            if (end == prev || visit[end]) continue;
            visited += MACCSFingerprinter.visitPart(visit, g2, end, beg);
        }
        return visited;
    }

    private static boolean isAromPath(int[] path, GraphUtil.EdgeToBondMap bmap) {
        int end = path.length - 1;
        for (int i = 0; i < end; ++i) {
            if (bmap.get(path[i], path[i + 1]).isAromatic()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Integer> getRawFingerprint(IAtomContainer iAtomContainer) throws CDKException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSize() {
        return 166;
    }

    private MaccsKey[] readKeyDef(IChemObjectBuilder builder) throws IOException, CDKException {
        String line;
        ArrayList<MaccsKey> keys = new ArrayList<MaccsKey>(166);
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(KEY_DEFINITIONS)));
        while ((line = reader.readLine()) != null) {
            if (line.charAt(0) == '#') continue;
            String data = line.substring(0, line.indexOf(124)).trim();
            String[] toks = data.split("\\s");
            keys.add(new MaccsKey(toks[1], this.createPattern(toks[1], builder), Integer.parseInt(toks[2])));
        }
        if (keys.size() != 166) {
            throw new CDKException("Found " + keys.size() + " keys during setup. Should be 166");
        }
        return keys.toArray(new MaccsKey[166]);
    }

    @Override
    public ICountFingerprint getCountFingerprint(IAtomContainer container) throws CDKException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MaccsKey[] keys(IChemObjectBuilder builder) throws CDKException {
        MaccsKey[] result = this.keys;
        if (result == null) {
            Object object = this.lock;
            synchronized (object) {
                result = this.keys;
                if (result == null) {
                    try {
                        result = this.readKeyDef(builder);
                        this.keys = result;
                    }
                    catch (IOException e) {
                        throw new CDKException("could not read MACCS definitions", e);
                    }
                }
            }
        }
        return result;
    }

    private Pattern createPattern(String smarts, IChemObjectBuilder builder) throws IOException {
        SmartsPattern ptrn = SmartsPattern.create(smarts, builder);
        ptrn.setPrepare(false);
        return ptrn;
    }

    private class MaccsKey {
        private String smarts;
        private int count;
        private Pattern pattern;

        private MaccsKey(String smarts, Pattern pattern, int count) {
            this.smarts = smarts;
            this.pattern = pattern;
            this.count = count;
        }

        public String getSmarts() {
            return this.smarts;
        }

        public int getCount() {
            return this.count;
        }
    }
}

