/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.Arrays;

public final class ConnectedComponents {
    private final int[][] g;
    private final int[] component;
    private int components;
    private int remaining;

    public ConnectedComponents(int[][] g2) {
        this.g = g2;
        this.component = new int[g2.length];
        this.remaining = g2.length;
        for (int i = 0; this.remaining > 0 && i < g2.length; ++i) {
            if (this.component[i] != 0) continue;
            this.visit(i, ++this.components);
        }
    }

    private void visit(int v, int c) {
        --this.remaining;
        this.component[v] = c;
        for (int w : this.g[v]) {
            if (this.component[w] != 0) continue;
            this.visit(w, c);
        }
    }

    public int[] components() {
        return Arrays.copyOf(this.component, this.component.length);
    }

    public int nComponents() {
        return this.components;
    }
}

