/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.graph.ConnectedComponents;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupKey;

public class ConnectivityChecker {
    public static boolean isConnected(IAtomContainer atomContainer) {
        if (atomContainer.getAtomCount() < 2) {
            return true;
        }
        ConnectedComponents cc = new ConnectedComponents(GraphUtil.toAdjList(atomContainer));
        return cc.nComponents() == 1;
    }

    public static IAtomContainerSet partitionIntoMolecules(IAtomContainer container) {
        ConnectedComponents cc = new ConnectedComponents(GraphUtil.toAdjList(container));
        return ConnectivityChecker.partitionIntoMolecules(container, cc.components());
    }

    public static IAtomContainerSet partitionIntoMolecules(IAtomContainer container, int[] components) {
        int maxComponentIndex = 0;
        for (int component : components) {
            if (component <= maxComponentIndex) continue;
            maxComponentIndex = component;
        }
        IAtomContainer[] containers = new IAtomContainer[maxComponentIndex + 1];
        HashMap<IAtom, IAtomContainer> componentsMap = new HashMap<IAtom, IAtomContainer>(2 * container.getAtomCount());
        HashMap<IAtom, IAtom> componentAtomMap = new HashMap<IAtom, IAtom>(2 * container.getAtomCount());
        HashMap<IBond, IBond> componentBondMap = new HashMap<IBond, IBond>(2 * container.getBondCount());
        for (int i = 1; i < containers.length; ++i) {
            containers[i] = container.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        }
        IAtomContainerSet containerSet = container.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        for (int i = 0; i < container.getAtomCount(); ++i) {
            IAtom origAtom = container.getAtom(i);
            IAtomContainer newContainer = containers[components[i]];
            componentsMap.put(origAtom, newContainer);
            newContainer.addAtom(origAtom);
            componentAtomMap.put(origAtom, newContainer.getAtom(newContainer.getAtomCount() - 1));
        }
        for (IBond bond : container.bonds()) {
            Iterator endComp;
            IAtomContainer begComp = (IAtomContainer)componentsMap.get(bond.getBegin());
            if (begComp != (endComp = (IAtomContainer)componentsMap.get(bond.getEnd()))) continue;
            begComp.addBond(bond);
            componentBondMap.put(bond, begComp.getBond(begComp.getBondCount() - 1));
        }
        for (ISingleElectron electron : container.singleElectrons()) {
            ((IAtomContainer)componentsMap.get(electron.getAtom())).addSingleElectron(electron);
        }
        for (ILonePair lonePair : container.lonePairs()) {
            ((IAtomContainer)componentsMap.get(lonePair.getAtom())).addLonePair(lonePair);
        }
        for (IStereoElement stereo : container.stereoElements()) {
            Object focus = stereo.getFocus();
            if (focus instanceof IAtom) {
                if (!componentsMap.containsKey(focus)) continue;
                ((IAtomContainer)componentsMap.get(focus)).addStereoElement(stereo);
                continue;
            }
            if (focus instanceof IBond) {
                if (!componentsMap.containsKey(((IBond)focus).getBegin())) continue;
                ((IAtomContainer)componentsMap.get(((IBond)focus).getBegin())).addStereoElement(stereo);
                continue;
            }
            throw new IllegalStateException("New stereo element not using an atom/bond for focus?");
        }
        List sgroups = (List)container.getProperty("cdk:CtabSgroups");
        if (sgroups != null) {
            HashMap<Sgroup, Sgroup> old2NewSgroupMap = new HashMap<Sgroup, Sgroup>();
            List[] newSgroups = new List[containers.length];
            for (Sgroup sgroup : sgroups) {
                boolean allMatch;
                Iterator<IAtom> iter = sgroup.getAtoms().iterator();
                if (!iter.hasNext()) continue;
                int componentIndex = ConnectivityChecker.getComponentIndexFor(components, containers, iter.next());
                boolean bl = allMatch = componentIndex >= 0;
                while (allMatch && iter.hasNext()) {
                    allMatch = componentIndex == ConnectivityChecker.getComponentIndexFor(components, containers, iter.next());
                }
                if (!allMatch || componentIndex < 0) continue;
                Sgroup cpy = new Sgroup();
                ArrayList<Sgroup> newComponentSgroups = newSgroups[componentIndex];
                if (newComponentSgroups == null) {
                    newComponentSgroups = newSgroups[componentIndex] = new ArrayList<Sgroup>();
                }
                newComponentSgroups.add(cpy);
                old2NewSgroupMap.put(sgroup, cpy);
                for (IAtom atom : sgroup.getAtoms()) {
                    cpy.addAtom((IAtom)componentAtomMap.get(atom));
                }
                for (IBond bond : sgroup.getBonds()) {
                    IBond newBond = (IBond)componentBondMap.get(bond);
                    if (newBond == null) continue;
                    cpy.addBond(newBond);
                }
                for (SgroupKey key : sgroup.getAttributeKeys()) {
                    cpy.putValue(key, sgroup.getValue(key));
                }
            }
            for (Sgroup sgroup : sgroups) {
                Sgroup newSgroup = (Sgroup)old2NewSgroupMap.get(sgroup);
                if (newSgroup == null) continue;
                for (Sgroup parent : sgroup.getParents()) {
                    Sgroup newParent = (Sgroup)old2NewSgroupMap.get(parent);
                    if (newParent == null) continue;
                    newSgroup.addParent(newParent);
                }
            }
            for (int i = 1; i < containers.length; ++i) {
                List sg = newSgroups[i];
                if (sg == null) continue;
                containers[i].setProperty("cdk:CtabSgroups", sg);
            }
        }
        for (int i = 1; i < containers.length; ++i) {
            containerSet.addAtomContainer(containers[i]);
        }
        return containerSet;
    }

    private static int getComponentIndexFor(int[] components, IAtomContainer[] containers, IAtom atom) {
        int aIndex = atom.getIndex();
        if (aIndex >= 0) {
            return components[aIndex];
        }
        for (int i = 1; i < containers.length; ++i) {
            if (!containers[i].contains(atom)) continue;
            return i;
        }
        return -1;
    }
}

