/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.inchi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point2d;
import net.sf.jniinchi.INCHI_BOND_STEREO;
import net.sf.jniinchi.INCHI_BOND_TYPE;
import net.sf.jniinchi.INCHI_KEY;
import net.sf.jniinchi.INCHI_OPTION;
import net.sf.jniinchi.INCHI_PARITY;
import net.sf.jniinchi.INCHI_RADICAL;
import net.sf.jniinchi.INCHI_RET;
import net.sf.jniinchi.INCHI_STEREOTYPE;
import net.sf.jniinchi.JniInchiAtom;
import net.sf.jniinchi.JniInchiBond;
import net.sf.jniinchi.JniInchiException;
import net.sf.jniinchi.JniInchiInput;
import net.sf.jniinchi.JniInchiOutput;
import net.sf.jniinchi.JniInchiOutputKey;
import net.sf.jniinchi.JniInchiStereo0D;
import net.sf.jniinchi.JniInchiWrapper;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.inchi.JniInChIInputAdapter;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.stereo.ExtendedTetrahedral;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class InChIGenerator {
    protected JniInchiInput input;
    protected JniInchiOutput output;
    private final boolean auxNone;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(InChIGenerator.class);
    protected IAtomContainer atomContainer;

    protected InChIGenerator(IAtomContainer atomContainer, boolean ignoreAromaticBonds) throws CDKException {
        this(atomContainer, Collections.singletonList(INCHI_OPTION.AuxNone), ignoreAromaticBonds);
    }

    protected InChIGenerator(IAtomContainer atomContainer, String options, boolean ignoreAromaticBonds) throws CDKException {
        try {
            this.input = new JniInChIInputAdapter(options);
            this.generateInchiFromCDKAtomContainer(atomContainer, ignoreAromaticBonds);
            this.auxNone = this.input.getOptions() != null && this.input.getOptions().contains("AuxNone");
        }
        catch (JniInchiException jie) {
            throw new CDKException("InChI generation failed: " + jie.getMessage(), jie);
        }
    }

    protected InChIGenerator(IAtomContainer atomContainer, List<INCHI_OPTION> options, boolean ignoreAromaticBonds) throws CDKException {
        try {
            this.input = new JniInChIInputAdapter(options);
            this.generateInchiFromCDKAtomContainer(atomContainer, ignoreAromaticBonds);
            this.auxNone = this.input.getOptions() != null && this.input.getOptions().contains("AuxNone");
        }
        catch (JniInchiException jie) {
            throw new CDKException("InChI generation failed: " + jie.getMessage(), jie);
        }
    }

    private void generateInchiFromCDKAtomContainer(IAtomContainer atomContainer, boolean ignore) throws CDKException {
        this.atomContainer = atomContainer;
        Iterator<IAtom> atoms = atomContainer.atoms().iterator();
        boolean all3d = true;
        boolean all2d = true;
        while (atoms.hasNext()) {
            IAtom atom = atoms.next();
            if (atom.getPoint3d() == null) {
                all3d = false;
            }
            if (atom.getPoint2d() != null) continue;
            all2d = false;
        }
        HashMap<IAtom, JniInchiAtom> atomMap = new HashMap<IAtom, JniInchiAtom>();
        for (IAtom iAtom : atomContainer.atoms()) {
            Integer implicitH;
            Integer isotopeNumber;
            double z;
            double y;
            double x;
            Cloneable p;
            if (all3d) {
                p = iAtom.getPoint3d();
                x = p.x;
                y = p.y;
                z = p.z;
            } else if (all2d) {
                p = iAtom.getPoint2d();
                x = ((Point2d)p).x;
                y = ((Point2d)p).y;
                z = 0.0;
            } else {
                x = 0.0;
                y = 0.0;
                z = 0.0;
            }
            String el = iAtom.getSymbol();
            JniInchiAtom iatom = this.input.addAtom(new JniInchiAtom(x, y, z, el));
            atomMap.put(iAtom, iatom);
            int charge = iAtom.getFormalCharge();
            if (charge != 0) {
                iatom.setCharge(charge);
            }
            if ((isotopeNumber = iAtom.getMassNumber()) != null) {
                iatom.setIsotopicMass(isotopeNumber);
            }
            iatom.setImplicitH((implicitH = iAtom.getImplicitHydrogenCount()) != null ? implicitH : -1);
            int count = atomContainer.getConnectedSingleElectronsCount(iAtom);
            if (count == 1) {
                iatom.setRadical(INCHI_RADICAL.DOUBLET);
                continue;
            }
            if (count == 2) {
                Enum spin = (Enum)iAtom.getProperty("cdk:SpinMultiplicity");
                if (spin != null) {
                    if (spin.name().equals("DivalentSinglet")) {
                        iatom.setRadical(INCHI_RADICAL.SINGLET);
                        continue;
                    }
                    iatom.setRadical(INCHI_RADICAL.TRIPLET);
                    continue;
                }
                iatom.setRadical(INCHI_RADICAL.TRIPLET);
                continue;
            }
            if (count == 0) continue;
            throw new CDKException("Unrecognised radical type");
        }
        for (IBond bond : atomContainer.bonds()) {
            INCHI_BOND_TYPE order;
            JniInchiAtom at0 = (JniInchiAtom)atomMap.get(bond.getBegin());
            JniInchiAtom at1 = (JniInchiAtom)atomMap.get(bond.getEnd());
            IBond.Order bo = bond.getOrder();
            if (!ignore && bond.getFlag(32)) {
                order = INCHI_BOND_TYPE.ALTERN;
            } else if (bo == IBond.Order.SINGLE) {
                order = INCHI_BOND_TYPE.SINGLE;
            } else if (bo == IBond.Order.DOUBLE) {
                order = INCHI_BOND_TYPE.DOUBLE;
            } else if (bo == IBond.Order.TRIPLE) {
                order = INCHI_BOND_TYPE.TRIPLE;
            } else {
                throw new CDKException("Failed to generate InChI: Unsupported bond type");
            }
            JniInchiBond ibond = new JniInchiBond(at0, at1, order);
            this.input.addBond(ibond);
            IBond.Stereo stereo = bond.getStereo();
            if (stereo == IBond.Stereo.NONE) {
                ibond.setStereoDefinition(INCHI_BOND_STEREO.NONE);
                continue;
            }
            if (stereo == IBond.Stereo.DOWN) {
                ibond.setStereoDefinition(INCHI_BOND_STEREO.SINGLE_1DOWN);
                continue;
            }
            if (stereo == IBond.Stereo.UP) {
                ibond.setStereoDefinition(INCHI_BOND_STEREO.SINGLE_1UP);
                continue;
            }
            if (stereo == IBond.Stereo.DOWN_INVERTED) {
                ibond.setStereoDefinition(INCHI_BOND_STEREO.SINGLE_2DOWN);
                continue;
            }
            if (stereo == IBond.Stereo.UP_INVERTED) {
                ibond.setStereoDefinition(INCHI_BOND_STEREO.SINGLE_2UP);
                continue;
            }
            if (stereo == IBond.Stereo.E_OR_Z) {
                ibond.setStereoDefinition(INCHI_BOND_STEREO.DOUBLE_EITHER);
                continue;
            }
            if (stereo == IBond.Stereo.UP_OR_DOWN) {
                ibond.setStereoDefinition(INCHI_BOND_STEREO.SINGLE_1EITHER);
                continue;
            }
            if (stereo == IBond.Stereo.UP_OR_DOWN_INVERTED) {
                ibond.setStereoDefinition(INCHI_BOND_STEREO.SINGLE_2EITHER);
                continue;
            }
            if (stereo != CDKConstants.UNSET) continue;
            if (order == INCHI_BOND_TYPE.SINGLE) {
                ibond.setStereoDefinition(INCHI_BOND_STEREO.SINGLE_1EITHER);
                continue;
            }
            if (order != INCHI_BOND_TYPE.DOUBLE) continue;
            ibond.setStereoDefinition(INCHI_BOND_STEREO.DOUBLE_EITHER);
        }
        for (IStereoElement stereoElem : atomContainer.stereoElements()) {
            IAtom replace;
            JniInchiStereo0D jniStereo;
            INCHI_PARITY p;
            JniInchiAtom at3;
            JniInchiAtom at2;
            JniInchiAtom at1;
            JniInchiAtom at0;
            Enum stereoType;
            if (stereoElem instanceof ITetrahedralChirality) {
                ITetrahedralChirality chirality = (ITetrahedralChirality)stereoElem;
                IAtom[] surroundingAtoms = chirality.getLigands();
                stereoType = chirality.getStereo();
                JniInchiAtom atC = (JniInchiAtom)atomMap.get(chirality.getChiralAtom());
                at0 = (JniInchiAtom)atomMap.get(surroundingAtoms[0]);
                at1 = (JniInchiAtom)atomMap.get(surroundingAtoms[1]);
                at2 = (JniInchiAtom)atomMap.get(surroundingAtoms[2]);
                at3 = (JniInchiAtom)atomMap.get(surroundingAtoms[3]);
                p = INCHI_PARITY.UNKNOWN;
                if (stereoType == ITetrahedralChirality.Stereo.ANTI_CLOCKWISE) {
                    p = INCHI_PARITY.ODD;
                } else if (stereoType == ITetrahedralChirality.Stereo.CLOCKWISE) {
                    p = INCHI_PARITY.EVEN;
                } else {
                    throw new CDKException("Unknown tetrahedral chirality");
                }
                jniStereo = new JniInchiStereo0D(atC, at0, at1, at2, at3, INCHI_STEREOTYPE.TETRAHEDRAL, p);
                this.input.addStereo0D(jniStereo);
                continue;
            }
            if (stereoElem instanceof IDoubleBondStereochemistry) {
                IDoubleBondStereochemistry dbStereo = (IDoubleBondStereochemistry)stereoElem;
                IBond[] surroundingBonds = dbStereo.getBonds();
                if (surroundingBonds[0] == null || surroundingBonds[1] == null) {
                    throw new CDKException("Cannot generate an InChI with incomplete double bond info");
                }
                stereoType = dbStereo.getStereo();
                IBond stereoBond = dbStereo.getStereoBond();
                at0 = null;
                at1 = null;
                at2 = null;
                at3 = null;
                if (stereoBond.contains(surroundingBonds[0].getBegin())) {
                    at1 = (JniInchiAtom)atomMap.get(surroundingBonds[0].getBegin());
                    at0 = (JniInchiAtom)atomMap.get(surroundingBonds[0].getEnd());
                } else {
                    at0 = (JniInchiAtom)atomMap.get(surroundingBonds[0].getBegin());
                    at1 = (JniInchiAtom)atomMap.get(surroundingBonds[0].getEnd());
                }
                if (stereoBond.contains(surroundingBonds[1].getBegin())) {
                    at2 = (JniInchiAtom)atomMap.get(surroundingBonds[1].getBegin());
                    at3 = (JniInchiAtom)atomMap.get(surroundingBonds[1].getEnd());
                } else {
                    at2 = (JniInchiAtom)atomMap.get(surroundingBonds[1].getEnd());
                    at3 = (JniInchiAtom)atomMap.get(surroundingBonds[1].getBegin());
                }
                p = INCHI_PARITY.UNKNOWN;
                if (stereoType == IDoubleBondStereochemistry.Conformation.TOGETHER) {
                    p = INCHI_PARITY.ODD;
                } else if (stereoType == IDoubleBondStereochemistry.Conformation.OPPOSITE) {
                    p = INCHI_PARITY.EVEN;
                } else {
                    throw new CDKException("Unknown double bond stereochemistry");
                }
                jniStereo = new JniInchiStereo0D(null, at0, at1, at2, at3, INCHI_STEREOTYPE.DOUBLEBOND, p);
                this.input.addStereo0D(jniStereo);
                continue;
            }
            if (!(stereoElem instanceof ExtendedTetrahedral)) continue;
            ExtendedTetrahedral extendedTetrahedral = (ExtendedTetrahedral)stereoElem;
            ITetrahedralChirality.Stereo winding = extendedTetrahedral.winding();
            IAtom[] terminals = extendedTetrahedral.findTerminalAtoms(atomContainer);
            Object[] peripherals = extendedTetrahedral.peripherals();
            List<IBond> t0Bonds = InChIGenerator.onlySingleBonded(atomContainer.getConnectedBondsList(terminals[0]));
            List<IBond> t1Bonds = InChIGenerator.onlySingleBonded(atomContainer.getConnectedBondsList(terminals[1]));
            if (t0Bonds.size() == 2) {
                replace = t0Bonds.remove(0).getOther(terminals[0]);
                for (int i = 0; i < peripherals.length; ++i) {
                    if (replace != peripherals[i]) continue;
                    peripherals[i] = terminals[0];
                }
            }
            if (t1Bonds.size() == 2) {
                replace = t1Bonds.remove(0).getOther(terminals[1]);
                for (int i = 0; i < peripherals.length; ++i) {
                    if (replace != peripherals[i]) continue;
                    peripherals[i] = terminals[1];
                }
            }
            IAtom t0Neighbor = t0Bonds.get(0).getOther(terminals[0]);
            IAtom t1Neighbor = t1Bonds.get(0).getOther(terminals[1]);
            for (int i = 0; i < peripherals.length; ++i) {
                if (i != 0 && t0Neighbor.equals(peripherals[i])) {
                    InChIGenerator.swap(peripherals, i, 0);
                    winding = winding.invert();
                    continue;
                }
                if (i != 1 && terminals[0].equals(peripherals[i])) {
                    InChIGenerator.swap(peripherals, i, 1);
                    winding = winding.invert();
                    continue;
                }
                if (i != 2 && terminals[1].equals(peripherals[i])) {
                    InChIGenerator.swap(peripherals, i, 2);
                    winding = winding.invert();
                    continue;
                }
                if (i == 3 || !t1Neighbor.equals(peripherals[i])) continue;
                InChIGenerator.swap(peripherals, i, 3);
                winding = winding.invert();
            }
            INCHI_PARITY parity = INCHI_PARITY.UNKNOWN;
            if (winding == ITetrahedralChirality.Stereo.ANTI_CLOCKWISE) {
                parity = INCHI_PARITY.ODD;
            } else if (winding == ITetrahedralChirality.Stereo.CLOCKWISE) {
                parity = INCHI_PARITY.EVEN;
            } else {
                throw new CDKException("Unknown extended tetrahedral chirality");
            }
            jniStereo = new JniInchiStereo0D((JniInchiAtom)atomMap.get(extendedTetrahedral.focus()), (JniInchiAtom)atomMap.get(peripherals[0]), (JniInchiAtom)atomMap.get(peripherals[1]), (JniInchiAtom)atomMap.get(peripherals[2]), (JniInchiAtom)atomMap.get(peripherals[3]), INCHI_STEREOTYPE.ALLENE, parity);
            this.input.addStereo0D(jniStereo);
        }
        try {
            this.output = JniInchiWrapper.getInchi(this.input);
        }
        catch (JniInchiException jniInchiException) {
            throw new CDKException("Failed to generate InChI: " + jniInchiException.getMessage(), jniInchiException);
        }
    }

    private static List<IBond> onlySingleBonded(List<IBond> bonds) {
        ArrayList<IBond> filtered = new ArrayList<IBond>();
        for (IBond bond : bonds) {
            if (bond.getOrder() != IBond.Order.SINGLE) continue;
            filtered.add(bond);
        }
        return filtered;
    }

    private static void swap(Object[] objs, int i, int j) {
        Object tmp = objs[i];
        objs[i] = objs[j];
        objs[j] = tmp;
    }

    public INCHI_RET getReturnStatus() {
        return this.output.getReturnStatus();
    }

    public String getInchi() {
        return this.output.getInchi();
    }

    public String getInchiKey() throws CDKException {
        try {
            JniInchiOutputKey key = JniInchiWrapper.getInchiKey(this.output.getInchi());
            if (key.getReturnStatus() == INCHI_KEY.OK) {
                return key.getKey();
            }
            throw new CDKException("Error while creating InChIKey: " + (Object)((Object)key.getReturnStatus()));
        }
        catch (JniInchiException exception) {
            throw new CDKException("Error while creating InChIKey: " + exception.getMessage(), exception);
        }
    }

    public String getAuxInfo() {
        if (this.auxNone) {
            LOGGER.warn("AuxInfo requested but AuxNone option is set (default).");
        }
        return this.output.getAuxInfo();
    }

    public String getMessage() {
        return this.output.getMessage();
    }

    public String getLog() {
        return this.output.getLog();
    }
}

