/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.Mol2Format;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public class Mol2Reader
extends DefaultChemObjectReader {
    boolean firstLineisMolecule = false;
    BufferedReader input = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(Mol2Reader.class);
    private static final Map<String, String> ATOM_TYPE_ALIASES = ImmutableMap.builder().put("S.o2", "S.O2").put("S.o", "S.O").put("CL", "Cl").put("CU", "Cu").put("FE", "Fe").put("BR", "Br").put("NA", "Na").put("SI", "Si").put("CA", "Ca").put("ZN", "Zn").put("LI", "Li").put("MG", "Mg").build();

    public Mol2Reader(Reader in) {
        this.input = new BufferedReader(in);
    }

    public Mol2Reader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public Mol2Reader() {
        this(new StringReader(""));
    }

    @Override
    public IResourceFormat getFormat() {
        return Mol2Format.getInstance();
    }

    @Override
    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    @Override
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @Override
    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        if (IChemModel.class.equals(classObject)) {
            return true;
        }
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (IChemModel.class.equals(anInterface)) {
                return true;
            }
            if (IChemFile.class.equals(anInterface)) {
                return true;
            }
            if (!IAtomContainer.class.equals(anInterface)) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        return superClass != null && this.accepts(superClass);
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)object);
        }
        if (object instanceof IChemModel) {
            return (T)this.readChemModel((IChemModel)object);
        }
        if (object instanceof IAtomContainer) {
            return (T)this.readMolecule((IAtomContainer)object);
        }
        throw new CDKException("Only supported are ChemFile and Molecule.");
    }

    private IChemModel readChemModel(IChemModel chemModel) throws CDKException {
        IAtomContainer m3;
        IAtomContainerSet setOfMolecules = chemModel.getMoleculeSet();
        if (setOfMolecules == null) {
            setOfMolecules = chemModel.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        }
        if ((m3 = this.readMolecule(chemModel.getBuilder().newInstance(IAtomContainer.class, new Object[0]))) != null) {
            setOfMolecules.addAtomContainer(m3);
        }
        chemModel.setMoleculeSet(setOfMolecules);
        return chemModel;
    }

    private IChemFile readChemFile(IChemFile chemFile) throws CDKException {
        IChemSequence chemSequence = chemFile.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        IChemModel chemModel = chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
        IAtomContainerSet setOfMolecules = chemFile.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        IAtomContainer m3 = this.readMolecule(chemFile.getBuilder().newInstance(IAtomContainer.class, new Object[0]));
        if (m3 != null) {
            setOfMolecules.addAtomContainer(m3);
        }
        chemModel.setMoleculeSet(setOfMolecules);
        chemSequence.addChemModel(chemModel);
        setOfMolecules = chemFile.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        chemModel = chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
        try {
            this.firstLineisMolecule = true;
            while (m3 != null) {
                m3 = this.readMolecule(chemFile.getBuilder().newInstance(IAtomContainer.class, new Object[0]));
                if (m3 == null) continue;
                setOfMolecules.addAtomContainer(m3);
                chemModel.setMoleculeSet(setOfMolecules);
                chemSequence.addChemModel(chemModel);
                setOfMolecules = chemFile.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                chemModel = chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
            }
        }
        catch (CDKException cdkexc) {
            throw cdkexc;
        }
        catch (IllegalArgumentException exception) {
            String error = "Error while parsing MOL2";
            logger.error(error);
            logger.debug(exception);
            throw new CDKException(error, exception);
        }
        try {
            this.input.close();
        }
        catch (Exception exc) {
            String error = "Error while closing file: " + exc.getMessage();
            logger.error(error);
            throw new CDKException(error, exc);
        }
        chemFile.addChemSequence(chemSequence);
        this.firstLineisMolecule = false;
        return chemFile;
    }

    public boolean accepts(IChemObject object) {
        if (object instanceof IChemFile) {
            return true;
        }
        if (object instanceof IChemModel) {
            return true;
        }
        return object instanceof IAtomContainer;
    }

    private IAtomContainer readMolecule(IAtomContainer molecule) throws CDKException {
        AtomTypeFactory atFactory = null;
        try {
            atFactory = AtomTypeFactory.getInstance("org/openscience/cdk/config/data/mol2_atomtypes.xml", molecule.getBuilder());
        }
        catch (Exception exception) {
            String error = "Could not instantiate an AtomTypeFactory";
            logger.error(error);
            logger.debug(exception);
            throw new CDKException(error, exception);
        }
        try {
            String line;
            int atomCount = 0;
            int bondCount = 0;
            do {
                if ((line = this.input.readLine()) != null) continue;
                return null;
            } while (!line.startsWith("@<TRIPOS>MOLECULE") && (line.startsWith("#") || line.trim().length() <= 0));
            if (this.firstLineisMolecule) {
                molecule.setTitle(line);
            } else {
                line = this.input.readLine();
                molecule.setTitle(line);
            }
            String counts = this.input.readLine();
            StringTokenizer tokenizer = new StringTokenizer(counts);
            try {
                atomCount = Integer.parseInt(tokenizer.nextToken());
            }
            catch (NumberFormatException nfExc) {
                String error = "Error while reading atom count from MOLECULE block";
                logger.error(error);
                logger.debug(nfExc);
                throw new CDKException(error, nfExc);
            }
            if (tokenizer.hasMoreTokens()) {
                try {
                    bondCount = Integer.parseInt(tokenizer.nextToken());
                }
                catch (NumberFormatException nfExc) {
                    String error = "Error while reading atom and bond counts";
                    logger.error(error);
                    logger.debug(nfExc);
                    throw new CDKException(error, nfExc);
                }
            } else {
                bondCount = 0;
            }
            logger.info("Reading #atoms: ", atomCount);
            logger.info("Reading #bonds: ", bondCount);
            logger.warn("Not reading molecule qualifiers");
            line = this.input.readLine();
            boolean molend = false;
            while (line != null) {
                int i;
                if (line.startsWith("@<TRIPOS>MOLECULE")) {
                    molend = true;
                    break;
                }
                if (line.startsWith("@<TRIPOS>ATOM")) {
                    logger.info("Reading atom block");
                    for (i = 0; i < atomCount; ++i) {
                        IAtomType atomType;
                        line = this.input.readLine().trim();
                        if (line.startsWith("@<TRIPOS>MOLECULE")) {
                            molend = true;
                            break;
                        }
                        tokenizer = new StringTokenizer(line);
                        tokenizer.nextToken();
                        String nameStr = tokenizer.nextToken();
                        String xStr = tokenizer.nextToken();
                        String yStr = tokenizer.nextToken();
                        String zStr = tokenizer.nextToken();
                        String atomTypeStr = tokenizer.nextToken();
                        if (ATOM_TYPE_ALIASES.containsKey(atomTypeStr)) {
                            atomTypeStr = ATOM_TYPE_ALIASES.get(atomTypeStr);
                        }
                        IAtom atom = molecule.getBuilder().newInstance(IAtom.class, new Object[0]);
                        try {
                            atomType = atFactory.getAtomType(atomTypeStr);
                        }
                        catch (Exception exception) {
                            atomType = null;
                        }
                        if (atomType == null && this.isElementSymbol(atomTypeStr)) {
                            atom.setSymbol(atomTypeStr);
                        } else {
                            if (atomType == null) {
                                atomType = atFactory.getAtomType("X");
                                logger.error("Could not find specified atom type: ", atomTypeStr);
                            }
                            AtomTypeManipulator.configure(atom, atomType);
                        }
                        atom.setAtomicNumber(Elements.ofString(atom.getSymbol()).number());
                        atom.setID(nameStr);
                        atom.setAtomTypeName(atomTypeStr);
                        try {
                            double x = Double.parseDouble(xStr);
                            double y = Double.parseDouble(yStr);
                            double z = Double.parseDouble(zStr);
                            atom.setPoint3d(new Point3d(x, y, z));
                        }
                        catch (NumberFormatException nfExc) {
                            String error = "Error while reading atom coordinates";
                            logger.error(error);
                            logger.debug(nfExc);
                            throw new CDKException(error, nfExc);
                        }
                        molecule.addAtom(atom);
                    }
                } else if (line.startsWith("@<TRIPOS>BOND")) {
                    logger.info("Reading bond block");
                    for (i = 0; i < bondCount; ++i) {
                        line = this.input.readLine();
                        if (line.startsWith("@<TRIPOS>MOLECULE")) {
                            molend = true;
                            break;
                        }
                        tokenizer = new StringTokenizer(line);
                        tokenizer.nextToken();
                        String atom1Str = tokenizer.nextToken();
                        String atom2Str = tokenizer.nextToken();
                        String orderStr = tokenizer.nextToken();
                        try {
                            int atom1 = Integer.parseInt(atom1Str);
                            int atom2 = Integer.parseInt(atom2Str);
                            if ("nc".equals(orderStr)) continue;
                            IBond bond = molecule.getBuilder().newInstance(IBond.class, molecule.getAtom(atom1 - 1), molecule.getAtom(atom2 - 1));
                            if ("1".equals(orderStr)) {
                                bond.setOrder(IBond.Order.SINGLE);
                            } else if ("2".equals(orderStr)) {
                                bond.setOrder(IBond.Order.DOUBLE);
                            } else if ("3".equals(orderStr)) {
                                bond.setOrder(IBond.Order.TRIPLE);
                            } else if ("am".equals(orderStr) || "ar".equals(orderStr)) {
                                bond.setOrder(IBond.Order.SINGLE);
                                bond.setFlag(32, true);
                                bond.getBegin().setFlag(32, true);
                                bond.getEnd().setFlag(32, true);
                            } else if ("du".equals(orderStr)) {
                                bond.setOrder(IBond.Order.SINGLE);
                            } else if ("un".equals(orderStr)) {
                                bond.setOrder(IBond.Order.SINGLE);
                            }
                            molecule.addBond(bond);
                            continue;
                        }
                        catch (NumberFormatException nfExc) {
                            String error = "Error while reading bond information";
                            logger.error(error);
                            logger.debug(nfExc);
                            throw new CDKException(error, nfExc);
                        }
                    }
                }
                if (molend) {
                    return molecule;
                }
                line = this.input.readLine();
            }
        }
        catch (IOException exception) {
            String error = "Error while reading general structure";
            logger.error(error);
            logger.debug(exception);
            throw new CDKException(error, exception);
        }
        return molecule;
    }

    private boolean isElementSymbol(String atomTypeStr) {
        for (int i = 1; i < PeriodicTable.getElementCount(); ++i) {
            if (!PeriodicTable.getSymbol(i).equals(atomTypeStr)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

