/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.openscience.cdk.exception.NoSuchAtomException;
import org.openscience.cdk.graph.invariant.MorganNumbersTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

public class IsomorphismTester
implements Serializable {
    private static final long serialVersionUID = 2499779110996693974L;
    long[] baseTable;
    long[] sortedBaseTable;
    long[] compareTable;
    long[] sortedCompareTable;
    IAtomContainer base = null;
    IAtomContainer compare = null;

    public IsomorphismTester() {
    }

    public IsomorphismTester(IAtomContainer mol2) throws NoSuchAtomException {
        this.setBaseTable(mol2);
    }

    public boolean isIsomorphic(IAtomContainer mol1, IAtomContainer mol2) {
        this.setBaseTable(mol1);
        return this.isIsomorphic(mol2);
    }

    public boolean isIsomorphic(IAtomContainer mol2) {
        int f;
        IAtom atom1 = null;
        IAtom atom2 = null;
        this.setCompareTable(mol2);
        for (f = 0; f < this.sortedBaseTable.length; ++f) {
            if (this.sortedBaseTable[f] == this.sortedCompareTable[f]) continue;
            return false;
        }
        for (f = 0; f < this.baseTable.length; ++f) {
            boolean found = false;
            for (int g2 = 0; g2 < this.compareTable.length; ++g2) {
                if (this.baseTable[f] != this.compareTable[g2]) continue;
                atom1 = this.base.getAtom(f);
                atom2 = this.compare.getAtom(g2);
                if (!atom1.getSymbol().equals(atom2.getSymbol()) && Objects.equals(atom1.getImplicitHydrogenCount(), atom2.getImplicitHydrogenCount())) {
                    return false;
                }
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private void setBaseTable(IAtomContainer mol2) {
        this.base = mol2;
        this.baseTable = MorganNumbersTools.getMorganNumbers(this.base);
        this.sortedBaseTable = new long[this.baseTable.length];
        System.arraycopy(this.baseTable, 0, this.sortedBaseTable, 0, this.baseTable.length);
        Arrays.sort(this.sortedBaseTable);
    }

    private void setCompareTable(IAtomContainer mol2) {
        this.compare = mol2;
        this.compareTable = MorganNumbersTools.getMorganNumbers(this.compare);
        this.sortedCompareTable = new long[this.compareTable.length];
        System.arraycopy(this.compareTable, 0, this.sortedCompareTable, 0, this.compareTable.length);
        Arrays.sort(this.sortedCompareTable);
    }
}

