/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.pharmacophore;

import org.openscience.cdk.Atom;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.pharmacophore.PharmacophoreAtom;
import org.openscience.cdk.smarts.SmartsPattern;

public class PharmacophoreQueryAtom
extends Atom
implements IQueryAtom {
    private String smarts;
    private SmartsPattern[] compiledSmarts;
    private String symbol;

    public PharmacophoreQueryAtom(String symbol, String smarts) {
        this.symbol = symbol;
        this.smarts = smarts;
        String[] subSmarts = smarts.split("\\|");
        this.compiledSmarts = new SmartsPattern[subSmarts.length];
        for (int i = 0; i < this.compiledSmarts.length; ++i) {
            this.compiledSmarts[i] = SmartsPattern.create(subSmarts[i]).setPrepare(false);
        }
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getSmarts() {
        return this.smarts;
    }

    SmartsPattern[] getCompiledSmarts() {
        return this.compiledSmarts;
    }

    @Override
    public boolean matches(IAtom atom) {
        PharmacophoreAtom patom = PharmacophoreAtom.get(atom);
        return patom.getSymbol().equals(this.getSymbol());
    }

    @Override
    public String toString() {
        StringBuffer s2 = new StringBuffer();
        s2.append(this.getSymbol()).append(" [").append(this.getSmarts()).append(']');
        return s2.toString();
    }
}

