/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.bond;

import org.openscience.cdk.charges.GasteigerMarsiliPartialCharges;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractBondDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.result.DoubleResult;

public class BondPartialSigmaChargeDescriptor
extends AbstractBondDescriptor {
    private GasteigerMarsiliPartialCharges peoe = new GasteigerMarsiliPartialCharges();
    private int maxIterations;
    private static final String[] NAMES = new String[]{"peoeB"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#bondPartialSigmaCharge", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("PartialSigmaChargeDescriptor only expects one parameter");
        }
        if (!(params[0] instanceof Integer)) {
            throw new CDKException("The parameter 1 must be of type Integer");
        }
        this.maxIterations = (Integer)params[0];
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.maxIterations};
        return params;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), NAMES, e);
    }

    @Override
    public DescriptorValue calculate(IBond bond, IAtomContainer ac) {
        Double originalCharge1 = bond.getBegin().getCharge();
        Double originalCharge2 = bond.getEnd().getCharge();
        if (!this.isCachedAtomContainer(ac)) {
            IAtomContainer mol2 = ac.getBuilder().newInstance(IAtomContainer.class, ac);
            if (this.maxIterations != 0) {
                this.peoe.setMaxGasteigerIters(this.maxIterations);
            }
            try {
                this.peoe.assignGasteigerMarsiliSigmaPartialCharges(mol2, true);
                for (IBond bondi : ac.bonds()) {
                    double result = Math.abs(bondi.getBegin().getCharge() - bondi.getEnd().getCharge());
                    this.cacheDescriptorValue(bondi, ac, new DoubleResult(result));
                }
            }
            catch (Exception ex1) {
                return this.getDummyDescriptorValue(ex1);
            }
        }
        bond.getBegin().setCharge(originalCharge1);
        bond.getEnd().setCharge(originalCharge2);
        return this.getCachedDescriptorValue(bond) != null ? new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), this.getCachedDescriptorValue(bond), NAMES) : null;
    }

    @Override
    public String[] getParameterNames() {
        String[] params = new String[]{"maxIterations"};
        return params;
    }

    @Override
    public Object getParameterType(String name) {
        if ("maxIterations".equals(name)) {
            return Integer.MAX_VALUE;
        }
        return null;
    }
}

